clear; close all; clc;

fsize = 11;
tmp = jet;
for k = 1:12
    cs{k} = tmp(21*(k-1)+1,:);
    lg{k} = sprintf('%2d',k);
end
cs = circshift(cs,8);

blue=0.7*[0 0 1];
red= 0.7*[1 0 0];
grey=.7*[1 1 1];
lgrey=.9*[1 1 1];
magenta = 0.7*[1 0 1];
cyan = 0.7*[0 1 1];

%%
load('Jqsvar.mat');
month = {'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'};
days_in_month = [31 28 31 30 31 30 31 31 30 31 30 31];
for m = 1:12
    seasonal(m).month = month{m};
    seasonal(m).days_in_month = days_in_month(m);
    seasonal(m).tau = Jqsvar.tau(1,m);
    seasonal(m).tau_mn1 = Jqsvar.tau(2,m);
    seasonal(m).tau_mn2 = Jqsvar.tau(3,m);
    seasonal(m).Qsw = Jqsvar.Jq0_swr(1,m);
    seasonal(m).Qsw_mn1 = Jqsvar.Jq0_swr(2,m);
    seasonal(m).Qsw_mn2 = Jqsvar.Jq0_swr(3,m);
    seasonal(m).Qns = Jqsvar.Jq0_ns(1,m);
    seasonal(m).Qns_mn1 = Jqsvar.Jq0_ns(2,m);
    seasonal(m).Qns_mn2 = Jqsvar.Jq0_ns(3,m);
    seasonal(m).Qnet = Jqsvar.Jq0_net(1,m);
    seasonal(m).dtop = Jqsvar.dtop(1,m);
    seasonal(m).dbot = Jqsvar.dbot(1,m);
    seasonal(m).ustar2Smax_Bo = Jqsvar.ustar2Smax_Bo(1,m);
    seasonal(m).ustar2Smax_Bo_mn1 = Jqsvar.ustar2Smax_Bo(2,m);
    seasonal(m).ustar2Smax_Bo_mn2 = Jqsvar.ustar2Smax_Bo(3,m);
    seasonal(m).zmax = Jqsvar.zmax(1,m);
    seasonal(m).z = Jqsvar.z_shear;
    seasonal(m).S = Jqsvar.Smag_z{1}(:,m);
end



%%  seasonal profiles
figure('unit','in','position',[1 1 7.75 6.25]);
for n = 1:4
    switch n
        case 1
            mid = [12,1,2];
        case 2
            mid = 3:5;
        case 3
            mid = 6:8;
        case 4
            mid = 9:11;
    end

    sp(n) = subplot(2,3,n); hold on;
    ct = 0;
    for m = mid
        ct = ct+1;
        tmp = find(seasonal(m).z >= -seasonal(m).dtop)
        sz = tmp(end);
        tmp = find(seasonal(m).z >= -seasonal(m).dbot)
        ez = tmp(end);
        plot(1e2*seasonal(m).S(sz:ez),seasonal(m).z(sz:ez),'Color',cs{m});
    end
    ct = 0;
    for m = mid
        ct = ct+1;
        zz = seasonal(m).z;
        plot(1e2*seasonal(m).S,seasonal(m).z,'Color',cs{m},'LineStyle',':');
    end

    box on; grid on;
    if n == 3
      legend(month{mid},'Location','West','Autoupdate','off');
    else
      legend(month{mid},'Location','best','Autoupdate','off');
    end
    xlim([0 2.5]);
    ylim([-90 0]);

    set(gca,'FontSize',fsize,'TickDir','out');
    set(gca,'YTick',-80:20:0,'YTicklabel',[]);
    set(gca,'XTick',0:2,'XTicklabel',0:2);
    if n == 1
        text(-0.5,8,'(c)','FontSize',fsize + 2);
        ylabel('depth [m]');
        set(gca,'YTick',-80:20:0,'YTicklabel',-80:20:0);
    elseif n == 2
        text(2,-105,'Shear [10$^{-2}$ s$^{-1}$]','FontSize',fsize + 2);
    end
end


sp(5) = subplot(2,3,5); hold on;
yyaxis left;


plot(1:12,[seasonal.tau],'-k');
ylabel('$\tau_w \, [N m^{-2}]$'); 
box on; grid on;
axis([0.5 12.5 0.03 0.08]);
text(-0.1,0.085,'(a)','FontSize',fsize + 2)
set(gca,'FontSize',fsize,'Ycolor','k')

yyaxis right; hold on;
plot(1:12,[seasonal.Qns]);
plot(1:12,-[seasonal.Qsw]);
ylabel('$Q \, [W m^{-2}]$');
lg = legend('\tau_{w}','Q_{ns}','-Q_s','location','South','NumColumns',4);
lg.Position = [0.3508    0.92    0.2912    0.0433];

axis([0.5 12.5 -300 -100]);

set(gca,'XTick',1:12,'XTickLabel',[],'Ycolor','r')
set(gca,'FontSize',fsize);

sp(6) = subplot(2,3,6); hold on;
plot(1:12,[seasonal.ustar2Smax_Bo],'k');
ylabel('$u_\ast^2S^{max}/B_0$'); 
box on; grid on;
axis([0.5 12.5 9 15]);
text(-0.1,15.2,'(b)','FontSize',fsize + 2)
set(gca,'XTick',1:12,'XTickLabel',month)
set(gca,'FontSize',fsize);

set(sp(1),'unit','in','position',[0.6 0.5 1.4 2.0])
set(sp(2),'unit','in','position',[2.3 0.5 1.4 2.0])
set(sp(3),'unit','in','position',[4.0 0.5 1.4 2.0])
set(sp(4),'unit','in','position',[5.7 0.5 1.4 2.0])
set(sp(5),'unit','in','position',[0.6 4.5 6.5 1.25])
set(sp(6),'unit','in','position',[0.6 3 6.5 1.25])

exportgraphics(gcf,'./image/fig13_seasonal_profile.jpg','Resolution',300);

