clear; close all; clc;
fsize = 12;

load('Jq3day.mat');

figure('unit','in','position',[1 1 7.75 4]);
sp(1) = subplot(1,3,1); hold on;
cs = 'krb';

for n = 1:3
    plot(Jq3day(n).Uvel,Jq3day(n).z_shear,[cs(n) '-']);
    plot(Jq3day(n).Vvel,Jq3day(n).z_shear,[cs(n) '--']);
end
legend('zonal','meridional','Location','NorthEast')
box on; grid on;
ylabel('depth [m]');
xlabel('velocity [m s$^{-1}$]')
xlim([-0.8 1.2]);
ylim([-120 0]);
text(-1.1,5,'(a)','FontSize',fsize+2);
set(gca,'FontSize',fsize,'TickDir','out');
set(gca,'YTick',-120:20:0,'YTicklabel',-120:20:0);
set(gca,'XTick',-0.5:0.5:1.2,'XTicklabel',-0.5:0.5:1.2);

sp(2) = subplot(1,3,2); hold on;
for n = 1:3
    plot(Jq3day(n).T,Jq3day(n).z_shear,[cs(n) '-']);
    lgstring{n} = datestr(Jq3day(n).t,'dd-mmm-yyyy');
end
lg = legend(lgstring,'Location','SouthEast');

box on; grid on;
xlabel('temperature [$^\circ$C]')
xlim([19 28]);
ylim([-120 0]);
text(19,5,'(b)','FontSize',fsize+2);
set(gca,'FontSize',fsize,'TickDir','out');
set(gca,'YTick',-120:20:0,'YTicklabel',[]);
set(gca,'XTick',20:2:28,'XTicklabel',20:2:28);

sp(3) = subplot(1,3,3); hold on;
for n = 1:3
    plot(Jq3day(n).Jqlocal,Jq3day(n).zlocal,[cs(n) '-o'],...
        'MarkerFaceColor',cs(n),'MarkerSize',5);
    Jq0_net = Jq3day(n).Jq0_net;
    Izmax = Jq3day(n).Izmax;
    plot(-(Jq0_net+Izmax),0,[cs(n) '^'],'MarkerFaceColor',cs(n));
end
box on; grid on;
xlabel('J$_{q,p}$ [W m$^{-2}$]')
xlim([-350 20]);
ylim([-120 0]);
text(-400,5,'(c)','FontSize',fsize+2);
set(gca,'FontSize',fsize,'TickDir','out');
set(gca,'YTick',-120:20:0,'YTicklabel',[]);
set(gca,'XTick',-300:100:0,'XTicklabel',-300:100:0);

set(sp(1),'unit','in','position',[0.6 0.5 2 3.0])
set(sp(2),'unit','in','position',[3.1 0.5 2 3.0])
set(sp(3),'unit','in','position',[5.6 0.5 2 3.0])

exportgraphics(gcf,'./image/fig12_daily_profile.jpg','Resolution',300);


