clear; close all; clc;

rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81; Ric = 0.3;
fsize = 12;

tmp = jet;
for k = 1:27
    cs{k} = tmp(8*(k-1)+1,:);
    lg{k} = sprintf('%2d',k);
end

load('tavg_stat.mat');
stat = tavg_stat; clear tavg_stat;

for m = 1:length(stat)
     tmp = find(stat(m).Rig <= Ric & (stat(m).z <= -20 & stat(m).z >= -100));
     stat(m).MI_indx = tmp(1)+0;
     stat(m).zMI = stat(m).z(tmp(1));
     stat(m).Jtmax_indx = find(stat(m).Jq == min(stat(m).Jq));
     stat(m).zmax = stat(m).z(stat(m).Jtmax_indx);
     stat(m).Jtmax = min(stat(m).Jq);
end

%% Scaling for zmax 
cases = 1:length(stat);
figure('unit','in','position',[1 1 7.25 7.5]);

sp(1) = subplot(2,2,1); hold on;
counter = 0;
sample_cases = [10 15 21 25];
for m = sample_cases
    counter = counter + 1;
    lstring{counter} = stat(m).case_name;
    zMI = stat(m).z(stat(m).MI_indx);
    zmax = stat(m).z(stat(m).Jtmax_indx);
    z = stat(m).z;
    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx; 
    Jq = stat(m).Jq;
    plot(Jq(sz:ez),z(sz:ez),'Color',cs{m}); hold on;
end


counter = 0;
for m = sample_cases
    counter = counter + 1;
    zMI = stat(m).z(stat(m).MI_indx);
    zmax = stat(m).z(stat(m).Jtmax_indx);
    z = stat(m).z;
    Jq = stat(m).Jq;
    plot(Jq(z==zmax),zmax,'^','MarkerEdgeColor',cs{m},...
        'MarkerFaceColor',cs{m},'MarkerSize',8);
end
xlabel('J$_q$ [W m$^{-2}$]');
ylabel('depth [m]');
ylim([-80 -10]);
text(-420,-7,'(a)');
legend(lstring,'Location','SouthWest');
text(-350,-35,'z$^{max}$','FontSize',fsize+2)
set(gca,'YTick',-80:20:-10,'YTickLabel',-80:20:-10);
box on; grid on;
set(gca,'FontSize',fsize)

sp(2) = subplot(2,2,2); hold on;
counter = 0;
for m = sample_cases
    counter = counter + 1;

    zMI = stat(m).z(stat(m).MI_indx);
    zmax = stat(m).z(stat(m).Jtmax_indx);
    z = stat(m).z;
    S = sqrt(stat(m).S2);

    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx; 
    MLD = stat(m).MLD;
    intS = trapz(z(sz:ez),S(sz:ez));
    Savg = intS/(z(ez)-z(sz));
    indx = find(S >= Savg & z < MLD & z > zMI);
    indx = indx(end);
    zcen = z(indx); 

    plot(1e2*S(sz:ez),z(sz:ez),'Color',cs{m}); hold on;
    plot(1e2*S(indx),zcen,'o','MarkerEdgeColor',cs{m},...
        'MarkerFaceColor',cs{m},'MarkerSize',8);
end
xlabel('S [10$^{-2}$ s$^{-1}$]');
text(0.35,-7,'(b)');
text(2.2,-35,'z$^{cen}$','FontSize',fsize+2)
box on; grid on;
ylim([-80 -10]);
set(gca,'YTick',-80:20:-10,'YTickLabel',[]);
set(gca,'FontSize',fsize)

clear xx yy
sp(3) = subplot(2,2,3); hold on;
counter = 0;
for m = 1:length(stat)
    counter = counter + 1;
    zMI = stat(m).z(stat(m).MI_indx);
    zmax = stat(m).z(stat(m).Jtmax_indx);
    z = stat(m).z;

    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx; 
    MLD = stat(m).MLD;
    S = sqrt(stat(m).S2);
    intS = trapz(z(sz:ez),S(sz:ez));
    Savg = intS/(z(ez)-z(sz));
    indx = find(S >= Savg & z < MLD & z > zMI);
    indx = indx(end);
    zcen = interp1(S(indx:indx+1),z(indx:indx+1),Savg);
    
    xx(m) = zcen/MLD;
    yy(m) = zmax/MLD;
    plot(xx(m),yy(m),'o','MarkerSize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
end


% Polynomial Curve Fit (poly1)
% f(x) = p1*x + p2
% 
% Coefficients and 95% Confidence Bounds
%        Value      Lower      Upper  
% p1    0.9995     0.8940     1.1050 
% p2    -0.2098    -0.3938    -0.0257
% 
% Goodness of Fit
%              Value  
% SSE         0.1582 
% R-square    0.9384 
% DFE         25.0000
% Adj R-sq    0.9359 
% RMSE        0.0796 



zmax_model = @(zcen_o_MLD) 1*(zcen_o_MLD) - 0.2;
plot([1 xx 2.5],zmax_model([1 xx 2.5]),'k');
text(1.05,2.3,'$\frac{z^{max}}{MLD}$ = $\frac{z^{cen}}{MLD}$ - 0.2','Interpreter','latex','FontSize',fsize+2);
text(1.05,2.15,'$r^2 = 0.94$','FontSize',fsize+2);
text(0.9,2.7,'(c)');

axis([1 2.5 1 2.6]);
xlabel('z$^{cen}/MLD$');
ylabel('z$^{max}/MLD$');
box on; grid on;
set(gca,'FontSize',fsize,'YTick',1:0.5:2.5);

set(sp(1),'unit','in','position',[0.75 4.25 3 3])
set(sp(2),'unit','in','position',[4 4.25 3 3])
set(sp(3),'unit','in','position',[2.5 0.5 3 3])

exportgraphics(gcf,'./image/fig11_zmax_model.jpg','Resolution',300);


