clear; close all; clc;

rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81; Ric = 0.3;
fsize = 12;

tmp = jet;
for k = 1:27
    cs{k} = tmp(8*(k-1)+1,:);
    lg{k} = sprintf('%2d',k);
end

load('tavg_stat.mat');
stat = tavg_stat; clear tavg_stat;

for m = 1:length(stat)
     tmp = find(stat(m).Rig <= Ric & (stat(m).z <= -20 & stat(m).z >= -100));
     stat(m).MI_indx = tmp(1)+0;
     stat(m).zMI = stat(m).z(tmp(1));
     stat(m).Jtmax_indx = find(stat(m).Jq == min(stat(m).Jq));
     stat(m).zmax = stat(m).z(stat(m).Jtmax_indx);
     stat(m).Jtmax = min(stat(m).Jq);
     ustar = sqrt(-stat(m).tauw/rho0);
     stat(m).L_MO = ustar.^3/0.4/stat(m).Bo;
     stat(m).zMO = -ustar.^3/0.4/stat(m).Bo;
     tmp = find(stat(m).z<= -stat(m).L_MO);
     stat(m).LMO_indx = tmp(end);
end

%% Scaling for Jqmax
figure('unit','in','position',[1 1 8.25 3.75]); 
sp(1) = subplot(1,2,1);
counter = 0;
hold on;
for m = 1:length(stat)
    counter = counter + 1;
    ustar = sqrt(-stat(m).tauw/rho0);
    Bo_ns = stat(m).Bo;
    Smax = sqrt(stat(m).S2(stat(m).Jtmax_indx));
    xx(counter) = ustar^2*Smax/Bo_ns;
    yy(counter) = -stat(m).Jq(stat(m).Jtmax_indx)/(rho0*cp/alphaT/g*ustar^2*Smax);
    plot(xx(counter),yy(counter),'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
end

% Custom Curve Fit
% f(x) = a/x+b
% 
% Coefficients and 95% Confidence Bounds
%      Value     Lower     Upper  
% a    0.1513    0.1399    0.1627
% b    0.0675    0.0606    0.0744
% 
% Goodness of Fit
%              Value  
% SSE         0.0057 
% R-square    0.9679 
% DFE         25.0000
% Adj R-sq    0.9666 
% RMSE        0.0151 


gammaJ_Jqmax_proxy1 = @(ustar2Smax_Bo) 0.15./ustar2Smax_Bo + 0.068;
plot(linspace(0.35,max(xx)+10,100),gammaJ_Jqmax_proxy1(linspace(0.35,max(xx)+10,100)),'-k');

box on; grid on;
xlabel('$u_\ast^2 S^{max}/B_0$','FontSize',fsize+2)
ylabel('$\gamma_J^{max} = -\frac{\alpha g}{\rho_0 c_p} \frac{J_q^{max}}{u_\ast^2 S^{max}}$','FontSize',fsize+2)
text(5,0.45,'$\gamma_J^{max} =  0.15 (\frac{u_\ast^2S^{max}}{B_0})^{-1} +  0.068$','FontSize',fsize);
text(5,0.41,'$r^2 = 0.97$','FontSize',fsize);
text(-12,0.62,'$(a)$','FontSize',fsize+2);
axis([0 60 0 0.5]);
set(gca,'FontSize',fsize);


%% Scaling for JqMLD
clear xx yy
sp(2) = subplot(1,2,2);
hold on;
counter = 0;
for m = 1:length(stat)
    counter = counter + 1;
    ustar = sqrt(-stat(m).tauw/rho0);
    Bo_ns = stat(m).Bo;
    SMLD = sqrt(stat(m).S2(stat(m).MLD_indx));
    xx(counter) = ustar^2*SMLD/Bo_ns;
    yy(counter) = -stat(m).Jq(stat(m).MLD_indx)/(rho0*cp/alphaT/g*ustar^2*SMLD);
    plot(xx(counter),yy(counter),'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
end

% Custom Curve Fit
% f(x) = a/x+b
% 
% Coefficients and 95% Confidence Bounds
%      Value     Lower     Upper  
% a    0.1421    0.1312    0.1531
% b    0.0684    0.0603    0.0765
% 
% Goodness of Fit
%              Value  
% SSE         0.0073 
% R-square    0.9662 
% DFE         25.0000
% Adj R-sq    0.9648 
% RMSE        0.0171 

gammaJ_JqMLD_proxy1 = @(ustar2SMLD_Bo) 0.14./ustar2SMLD_Bo + 0.068;

plot(linspace(0.35,max(xx)+10,100),gammaJ_JqMLD_proxy1(linspace(0.35,max(xx)+10,100)),'-k');

box on; grid on;
xlabel('$u_\ast^2 S^{MLD}/B_0$','FontSize',fsize+2)
ylabel('$\gamma_J^{MLD} = -\frac{\alpha g}{\rho_0 c_p} \frac{J_q^{MLD}}{u_\ast^2 S^{MLD}}$','FontSize',fsize+2)
text(3,0.45,'$\gamma_J^{MLD} =  0.14 (\frac{u_\ast^2S^{MLD}}{B_0})^{-1} + 0.068$','FontSize',fsize);
text(3,0.41,'$r^2 = 0.97$','FontSize',fsize);
text(-6,0.62,'$(b)$','FontSize',fsize+2);
axis([0 30 0 0.5]);
set(gca,'FontSize',fsize);
set(sp(1),'Units','inches','Position',[0.75 0.5 3 3])
set(sp(2),'Units','inches','Position',[4.75 0.5 3 3])
exportgraphics(gcf,'./image/fig10_Jqmax_JqMLD_model.jpg','Resolution',300);
