(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22829,        531]
NotebookOptionsPosition[     21585,        501]
NotebookOutlinePosition[     21980,        517]
CellTagsIndexPosition[     21937,        514]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Spectrum Plots", "Title",
 CellChangeTimes->{{3.879879253527519*^9, 
  3.87987926592211*^9}},ExpressionUUID->"17519ed0-9cc0-46a5-9d9a-\
72a0f2cb2cd4"],

Cell[CellGroupData[{

Cell["Reader", "Section",
 CellChangeTimes->{{3.879879153664411*^9, 3.879879154769874*^9}, {
  3.879879188699011*^9, 
  3.87987918948831*^9}},ExpressionUUID->"f07b76a3-ec0e-436d-a802-\
90f9e8ef91dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateSpectrumPlots", "[", "inputData_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "temp", ",", "DataFPsic", ",", "DataFPsi\[Mu]", ",", "DataFPsin"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", "1", "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", "1", "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFPsic", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", "1", "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", "2", "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFPsi\[Mu]", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", "1", "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", "3", "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFPsin", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ListPlot", "[", 
         RowBox[{"DataFPsic", ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "20"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<c\>\"", ",", 
             "\"\<\!\(\*SuperscriptBox[\(M\), \(2\)]\)/|M|\>\""}], "}"}]}], 
          ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Purple"}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Avenir\>\""}], ",", "11", 
             ",", 
             RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"DataFPsi\[Mu]", ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "20"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\[Mu]\>\"", ",", 
             "\"\<\!\(\*SuperscriptBox[\(M\), \(2\)]\)/|M|\>\""}], "}"}]}], 
          ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Purple"}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Avenir\>\""}], ",", "11", 
             ",", 
             RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"DataFPsin", ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "0.05"}], ",", "4.05"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "59"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<n\>\"", ",", 
             "\"\<\!\(\*SuperscriptBox[\(M\), \(2\)]\)/|M|\>\""}], "}"}]}], 
          ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Purple"}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Avenir\>\""}], ",", "11", 
             ",", 
             RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}]}], "]"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.879591372286591*^9, 3.879591469105638*^9}, {
   3.879591543051403*^9, 3.87959157133181*^9}, {3.879594634710054*^9, 
   3.87959463646796*^9}, {3.8795972613269367`*^9, 3.879597261336966*^9}, {
   3.879703169054529*^9, 3.879703351754521*^9}, {3.879703398873502*^9, 
   3.879703414628199*^9}, {3.879703452020465*^9, 3.879703494156551*^9}, {
   3.8797035402350388`*^9, 3.879703540438155*^9}, {3.879879298912891*^9, 
   3.87987930098742*^9}, {3.886419542097246*^9, 3.88641971833669*^9}, {
   3.8864197804237947`*^9, 3.886419902814967*^9}, {3.886420227202999*^9, 
   3.8864202684350033`*^9}, {3.914835100989255*^9, 3.914835240348216*^9}, {
   3.9148352710943727`*^9, 3.91483530731231*^9}, {3.914835347126642*^9, 
   3.914835427901826*^9}, 3.914835466848826*^9, {3.914835801358858*^9, 
   3.914835909245212*^9}, {3.9148359454352293`*^9, 3.914835964026307*^9}, {
   3.9148360323605556`*^9, 3.914836091093132*^9}, {3.9148361405498343`*^9, 
   3.9148361481413393`*^9}, {3.91483620636938*^9, 3.914836225581182*^9}, {
   3.914836700494709*^9, 3.9148367176884737`*^9}, {3.914836766237134*^9, 
   3.914836776354371*^9}, {3.914837041531391*^9, 3.914837111993702*^9}, {
   3.914837391407654*^9, 3.914837392712859*^9}, {3.914837430956668*^9, 
   3.91483744217759*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"84306960-8e0b-4422-be1e-54eec7e92416"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inputData", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<RoSpectrumData.csv\>\""}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8795945881724663`*^9, 3.879594597496763*^9}, {
   3.8795951026530724`*^9, 3.8795951188444567`*^9}, 3.879597261344736*^9, {
   3.879703103263084*^9, 3.879703126652169*^9}, {3.8797032308866243`*^9, 
   3.879703241032983*^9}, {3.8797035875128317`*^9, 3.879703588168993*^9}, 
   3.8798792254510403`*^9, {3.8806192081357546`*^9, 3.880619208472011*^9}, {
   3.886419923604473*^9, 3.886419954964669*^9}, 3.8864199860186863`*^9, {
   3.8864200717135277`*^9, 3.886420092555393*^9}, {3.886420132993267*^9, 
   3.886420163255459*^9}, {3.886429323495349*^9, 3.886429343790575*^9}, 
   3.886429444528472*^9, {3.914835744451725*^9, 3.914835747388975*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"323c4861-39b3-4695-8993-04002702d98c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellChangeTimes->{{3.87987924330765*^9, 
  3.879879244923197*^9}},ExpressionUUID->"6ac53374-b05c-426f-9bab-\
8fb6a43aa715"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"CreateSpectrumPlots", "[", "inputData", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateSpectrumPlots", "[", "inputData", "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateSpectrumPlots", "[", "inputData", "]"}], "[", 
  RowBox[{"[", "3", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, 3.879597260947003*^9, {
   3.879703629763515*^9, 3.879703747494426*^9}, {3.879704188185258*^9, 
   3.879704188783512*^9}, {3.879704544338423*^9, 3.879704565083949*^9}, 
   3.879879306112813*^9, {3.880613161883105*^9, 3.880613162328912*^9}, {
   3.8806132007543907`*^9, 3.8806132028089185`*^9}, {3.886420103241376*^9, 
   3.886420110188546*^9}, {3.8864202889879093`*^9, 3.8864203502461987`*^9}, {
   3.914835784242536*^9, 3.9148357873629704`*^9}, {3.914835948518353*^9, 
   3.914835949777781*^9}, {3.9148371273636*^9, 3.914837217360304*^9}, {
   3.9148373479228373`*^9, 3.9148373637899523`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"2d00fd12-9066-4443-ae60-434cc949fce2"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.5, 0, 0.5], PointSize[0.007333333333333334], AbsoluteThickness[
    1.6], PointBox[CompressedData["
1:eJxd2F2IlFUcx/HdbNNW032Zfd+dl533mZ2XZ6YLb7Y5CFFEN0oQgQUV2YVQ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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"c\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"\\!\\(\\*SuperscriptBox[\\(M\\), \\(2\\)]\\)/|M|\"", HoldForm],
      TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontFamily -> "Avenir", 11, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 6.}, {-2., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.914837208149612*^9, 3.91483721153378*^9}, {
  3.914837348703368*^9, 3.914837364511717*^9}, {3.914837444951057*^9, 
  3.914837470573969*^9}},
 CellLabel->"Out[3]=",ExpressionUUID->"1d248625-7add-4cbb-a0ae-426ad670a4a0"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.5, 0, 0.5], PointSize[0.007333333333333334], AbsoluteThickness[
    1.6], PointBox[CompressedData["
1:eJxd2nuMnFUZx/HKRbFg292dBdpud2f2MrO7c9m5vXMfe9QQVDAIqKCpBFDR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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"\[Mu]\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"\\!\\(\\*SuperscriptBox[\\(M\\), \\(2\\)]\\)/|M|\"", HoldForm],
      TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontFamily -> "Avenir", 11, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 2.}, {-2., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.914837208149612*^9, 3.91483721153378*^9}, {
  3.914837348703368*^9, 3.914837364511717*^9}, {3.914837444951057*^9, 
  3.914837470612535*^9}},
 CellLabel->"Out[4]=",ExpressionUUID->"a81bef0e-d961-439f-9d44-f754def05c71"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.5, 0, 0.5], PointSize[0.011000000000000001`], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd0ztIQlEYB/BLEYQthQ7RoBUE9gLJnqZ5fF6fkLZqg1BBS0mbQQRhS0Nj
ERVBLyiQhiKnBqeIGsOmwFWDgrCpoPud0/3b9YBcfp57znfO9323K7UUn2uQ
JMmj/OipDoeueLzs0DPV83yYYFO2Essf9jDp/1jvh9O0wZUFXqDlZ9Y6j9Z5
An6L5Y3ZSzv8ZU5sF26ccKGq/JFywfy4ZTccV5ZX0l5YWV01f/u099mUYSsN
fVB7n6OQdv++CEzU3Ub//OGkdBibBuEkxdu3wMO0/+eQ1isj8Aydt20cbqEA
Dzb4heLtOGAef4zB/HwXLpg/Oj3wqiEnl/a8MIWLtfu13pW173cEYd4PByGY
5787AgdKGUPuXM2HxHh/zNrgKVr/M6mdf3XAIj+oLxPxUV9G6c2G3VpveWDe
H8+oNxP18sN19Rbz5QDM+3Ua9RbnuwvDT4/KGFDv18zourLLA1O5E+81i/Ve
WOTHB/N+OfXDop9kWNwnAJ8o08XGEMz72R6Geby1CNxLL9yr521lvH7JICy+
h5op3ZnrEMzjbYRhnq/FCCy+vyj7BXHS+lI=
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"n\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"\\!\\(\\*SuperscriptBox[\\(M\\), \\(2\\)]\\)/|M|\"", HoldForm],
      TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontFamily -> "Avenir", 11, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.05, 4.05}, {-2., 59.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.914837208149612*^9, 3.91483721153378*^9}, {
  3.914837348703368*^9, 3.914837364511717*^9}, {3.914837444951057*^9, 
  3.914837470650889*^9}},
 CellLabel->"Out[5]=",ExpressionUUID->"24905ee8-95be-43fb-a11e-467a37d9f9fd"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 756},
WindowMargins->{{165, Automatic}, {-43, Automatic}},
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c3a38153-7bf0-4e7a-a13c-855c52da8180"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 156, 3, 98, "Title",ExpressionUUID->"17519ed0-9cc0-46a5-9d9a-72a0f2cb2cd4"],
Cell[CellGroupData[{
Cell[761, 29, 199, 4, 67, "Section",ExpressionUUID->"f07b76a3-ec0e-436d-a802-90f9e8ef91dc"],
Cell[963, 35, 6780, 168, 343, "Input",ExpressionUUID->"84306960-8e0b-4422-be1e-54eec7e92416"],
Cell[7746, 205, 991, 17, 30, "Input",ExpressionUUID->"323c4861-39b3-4695-8993-04002702d98c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8774, 227, 151, 3, 67, "Section",ExpressionUUID->"6ac53374-b05c-426f-9bab-8fb6a43aa715"],
Cell[CellGroupData[{
Cell[8950, 234, 1256, 21, 73, "Input",ExpressionUUID->"2d00fd12-9066-4443-ae60-434cc949fce2"],
Cell[10209, 257, 3631, 76, 246, "Output",ExpressionUUID->"1d248625-7add-4cbb-a0ae-426ad670a4a0"],
Cell[13843, 335, 5587, 108, 246, "Output",ExpressionUUID->"a81bef0e-d961-439f-9d44-f754def05c71"],
Cell[19433, 445, 2112, 51, 283, "Output",ExpressionUUID->"24905ee8-95be-43fb-a11e-467a37d9f9fd"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

