use "$OUTPUT/modified_data_october23.dta", clear 
xtset id time
*DEFINE UNEMPLOYMENT GAP
bys id :  replace u = (u/nairu_oecd-1)*100
********************************************************************************
*ENDOGENOUS VARIABLES
bys id: gen u_after_gr = u*after_gr
bys id: gen u_after_sdc = u*after_sdc
bys id: gen u_shift_gr = u*shift_gr_n
bys id: gen u_shift_sdc = u*shift_sdc_n
bys id: gen u_manuf_gr = u*Dva_manuf_gr
bys id: gen u_manuf_sdc = u*Dva_manuf_sdc

bys id:replace  u_after_gr = L.u_after_gr if u_after_gr==.
bys id:replace  u_after_sdc = L.u_after_sdc if u_after_sdc==.
bys id:replace  u_shift_gr = L.u_shift_gr if u_shift_gr==.
bys id:replace  u_shift_gr = L.u_shift_sdc if u_shift_sdc==.
bys id:replace  u_manuf_gr = L.u_manuf_gr if u_after_gr==.
bys id:replace  u_manuf_sdc = L.u_manuf_sdc if u_after_sdc==.
********************************************************************************
*MONETARY POLICY INSTRUMENTS
*set at t
bys id:gen k0 =  mp_shock
bys id: gen k1 = k0*after_gr
bys id: gen k2 = k0*after_sdc
bys id: gen k3 = k0*shift_gr_n
bys id: gen k4 = k0*shift_sdc_n
bys id: gen k5 = k0*Dva_manuf_gr
bys id: gen k6 = k0*Dva_manuf_sdc

*set at t-1
gen lk0 =  lmp_shock
bys id: gen lk1 = lk0*after_gr
bys id: gen lk2 = lk0*after_sdc
bys id: gen lk3 = lk0*shift_gr_n
bys id: gen lk4 = lk0*shift_sdc_n
bys id: gen lk5 = lk0*Dva_manuf_gr
bys id: gen lk6 = lk0*Dva_manuf_sdc

*set at t-2
gen l2k0 =  l2mp_shock
bys id: gen l2k1 = l2k0*after_gr
bys id: gen l2k2 = l2k0*after_sdc
bys id: gen l2k3 = l2k0*shift_gr_n
bys id: gen l2k4 = l2k0*shift_sdc_n
bys id: gen l2k5 = l2k0*Dva_manuf_gr
bys id: gen l2k6 = l2k0*Dva_manuf_sdc

*set at t-3
gen l3k0 =  l3mp_shock
bys id: gen l3k1 = l3k0*after_gr
bys id: gen l3k2 = l3k0*after_sdc
bys id: gen l3k3 = l3k0*shift_gr_n
bys id: gen l3k4 = l3k0*shift_sdc_n
bys id: gen l3k5 = l3k0*Dva_manuf_gr
bys id: gen l3k6 = l3k0*Dva_manuf_sdc

*set at t-4
gen l4k0 =  l4mp_shock
bys id: gen l4k1 = l4k0*after_gr
bys id: gen l4k2 = l4k0*after_sdc
bys id: gen l4k3 = l4k0*shift_gr_n
bys id: gen l4k4 = l4k0*shift_sdc_n
bys id: gen l4k5 = l4k0*Dva_manuf_gr
bys id: gen l4k6 = l4k0*Dva_manuf_sdc

*set at t-5
gen l5k0 =  l5mp_shock
bys id: gen l5k1 = l5k0*after_gr
bys id: gen l5k2 = l5k0*after_sdc
bys id: gen l5k3 = l5k0*shift_gr_n
bys id: gen l5k4 = l5k0*shift_sdc_n
bys id: gen l5k5 = l5k0*Dva_manuf_gr
bys id: gen l5k6 = l5k0*Dva_manuf_sdc

*set at t-6
gen l6k0 =  l6mp_shock
bys id: gen l6k1 = l6k0*after_gr
bys id: gen l6k2 = l6k0*after_sdc
bys id: gen l6k3 = l6k0*shift_gr_n
bys id: gen l6k4 = l6k0*shift_sdc_n
bys id: gen l6k5 = l6k0*Dva_manuf_gr
bys id: gen l6k6 = l6k0*Dva_manuf_sdc

*set at t-7
gen l7k0 =  l7mp_shock
bys id: gen l7k1 = l7k0*after_gr
bys id: gen l7k2 = l7k0*after_sdc
bys id: gen l7k3 = l7k0*shift_gr_n
bys id: gen l7k4 = l7k0*shift_sdc_n
bys id: gen l7k5 = l7k0*Dva_manuf_gr
bys id: gen l7k6 = l7k0*Dva_manuf_sdc

*set at t-8
gen l8k0 =  l8mp_shock
bys id: gen l8k1 = l8k0*after_gr
bys id: gen l8k2 = l8k0*after_sdc
bys id: gen l8k3 = l8k0*shift_gr_n
bys id: gen l8k4 = l8k0*shift_sdc_n
bys id: gen l8k5 = l8k0*Dva_manuf_gr
bys id: gen l8k6 = l8k0*Dva_manuf_sdc

*MONETARY POLICY INSTRUMENTS
*set at t
bys id:gen k0_long =  mp_shock_long
bys id: gen k1_long = k0_long*after_gr
bys id: gen k2_long = k0_long*after_sdc
bys id: gen k3_long = k0_long*shift_gr_n
bys id: gen k4_long = k0_long*shift_sdc_n
bys id: gen k5_long = k0_long*Dva_manuf_gr
bys id: gen k6_long = k0_long*Dva_manuf_sdc

*set at t-1
gen lk0_long =  lmp_shock_long
bys id: gen lk1_long = lk0_long*after_gr
bys id: gen lk2_long = lk0_long*after_sdc
bys id: gen lk3_long = lk0_long*shift_gr_n
bys id: gen lk4_long = lk0_long*shift_sdc_n
bys id: gen lk5_long = lk0_long*Dva_manuf_gr
bys id: gen lk6_long = lk0_long*Dva_manuf_sdc

*set at t-2
gen l2k0_long =  l2mp_shock_long
bys id: gen l2k1_long = l2k0_long*after_gr
bys id: gen l2k2_long = l2k0_long*after_sdc
bys id: gen l2k3_long = l2k0_long*shift_gr_n
bys id: gen l2k4_long = l2k0_long*shift_sdc_n
bys id: gen l2k5_long = l2k0_long*Dva_manuf_gr
bys id: gen l2k6_long = l2k0_long*Dva_manuf_sdc

********************************************************************************
*INTERNAL INSTRUMENT  
*set at t-1 
gen lz0 =  (0.25*(lu+l2u+l3u+l4u)/lnairu_oecd-1)*100  
bys id: gen lz1 = lz0*after_gr
bys id: gen lz2 = lz0*after_sdc
bys id: gen lz3 = lz0*shift_gr_n
bys id: gen lz4 = lz0*shift_sdc_n
bys id: gen lz5 = lz0*Dva_manuf_gr
bys id: gen lz6 = lz0*Dva_manuf_sdc

*set at t-2
gen l2z0 =  (0.25*(l2u+l3u+l4u+l5u)/l2nairu_oecd-1)*100 
bys id: gen l2z1 = l2z0*after_gr
bys id: gen l2z2 = l2z0*after_sdc
bys id: gen l2z3 = l2z0*shift_gr_n
bys id: gen l2z4 = l2z0*shift_sdc_n
bys id: gen l2z5 = l2z0*Dva_manuf_gr
bys id: gen l2z6 = l2z0*Dva_manuf_sdc

*set at t-3
gen l3z0 =  (0.25*(l3u+l4u+l5u+l6u)/l3nairu_oecd-1)*100 
bys id: gen l3z1 = l3z0*after_gr
bys id: gen l3z2 = l3z0*after_sdc
bys id: gen l3z3 = l3z0*shift_gr_n
bys id: gen l3z4 = l3z0*shift_sdc_n
bys id: gen l3z5 = l3z0*Dva_manuf_gr
bys id: gen l3z6 = l3z0*Dva_manuf_sdc

*set at t-4
gen l4z0 =  (0.25*(l4u+l5u+l6u+l7u)/l4nairu_oecd-1)*100  
bys id: gen l4z1 = l4z0*after_gr
bys id: gen l4z2 = l4z0*after_sdc
bys id: gen l4z3 = l4z0*shift_gr_n
bys id: gen l4z4 = l4z0*shift_sdc_n
bys id: gen l4z5 = l4z0*Dva_manuf_gr
bys id: gen l4z6 = l4z0*Dva_manuf_sdc

*set at t-5
gen l5z0 =  (0.25*(l5u+l6u+l7u+l8u)/l5nairu_oecd-1)*100 
bys id: gen l5z1 = l5z0*after_gr
bys id: gen l5z2 = l5z0*after_sdc
bys id: gen l5z3 = l5z0*shift_gr_n
bys id: gen l5z4 = l5z0*shift_sdc_n
bys id: gen l5z5 = l5z0*Dva_manuf_gr
bys id: gen l5z6 = l5z0*Dva_manuf_sdc


*Aggregate Inflation Expectation for EMU11 countries 
bys time: egen 	ep_1yEU    = mean(ep_1y)
bys time: egen 	lep_1yEU   = mean(lep_1y)	
bys time: egen 	l2ep_1yEU  = mean(l2ep_1y)	
bys time: egen 	l3ep_1yEU  = mean(l3ep_1y)
bys time: egen 	l4ep_1yEU  = mean(l4ep_1y)
bys time: egen 	l5ep_1yEU  = mean(l5ep_1y)
bys time: egen 	l6ep_1yEU  = mean(l6ep_1y)
bys time: egen 	l7ep_1yEU  = mean(l7ep_1y)
gen ma_ep_1yEU = (l4ep_1yEU + l5ep_1yEU+ l6ep_1yEU +l7ep_1yEU)*0.25
xtset id time 		

********************************************************************************  
********************************************************************************  
**********************************REGRESSIONS***********************************   
********************************************************************************  
********************************************************************************  



********************************************************************************
*****************************Table 3, column (1)-(3)****************************
********************************************************************************
xtset id time
global instruments k0 k1 k2 k3 k4 k5 k6 /// 
				   lk0 lk1 lk2 lk3 lk4 lk5 lk6 /// 
                   l2k0 l2k1 l2k2 l2k3 l2k4 l2k5 l2k6 ///
				   l3k0 l3k1 l3k2 l3k3 l3k4 l3k5 l3k6 ///
				   l4k0 l4k1 l4k2 l4k3 l4k4 l4k5 l4k6 ///
                   lep_1yEU				  
*Column 1				  					 
eststo: ivreg2 dprc (u ep_1y = $instruments) /// 
i.phase_i i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc,  ///
partial(i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc) ffirst
estadd local Country_Fe "Yes"
estadd local Controls "Yes" 
estadd local Time_Fe "No"
estadd local IV "Ext." 
 
*Column 2
eststo: ivreg2 dprc (u u_after_gr ep_1y = $instruments) ///
i.phase_i i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc,  ///
partial(i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc) ffirst
estadd local Country_Fe "Yes"
estadd local Controls "Yes" 
estadd local Time_Fe "No"
estadd local IV "Ext."   
  
*Column 3
eststo: ivreg2 dprc (u u_after_gr u_shift_gr u_after_sdc ///
u_shift_sdc u_manuf_gr ///
u_manuf_sdc ep_1y = $instruments) /// 
i.phase_i i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc,  ///
partial(i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc) ffirst
estadd local Country_Fe "Yes"
estadd local Controls "Yes" 
estadd local Time_Fe "No"
estadd local IV "Ext."  
  
preserve
mat first=e(first)
matrix list first
gen stat_u1 = first[4,1]
gen stat_exp1 = first[4,8]
gen wald_f = e(arf)
keep stat_u1 stat_exp1 wald_f
gen stat= "F" if _n ==1
replace stat= "Wald F-stat" if _n ==2
keep if _n<3
replace stat_u1 = wald_f if _n ==2
replace stat_exp1 = . if _n==2
drop wald_f
order stat
save "$OUTPUT/1st_stage_1.dta", replace 
restore
 
********************************************************************************
*****************************Table 3, column (4)-(6)****************************
********************************************************************************
global clear
bys id : gen ma_ep =  ((lep_1y+l2ep_1y+l3ep_1y+l4ep_1y)*0.25) 
global instruments2  l2z0 l2z1 l2z2 l2z3 l2z4 l2z5 l2z6 ///
				     ma_ep  

*BASELINE ADDING CONTROLS FOR CHANGES IN THE LEVEL OF INFLATION OVER TIME DUE TO 
*STRUCTURAL CHANGES
xtset id time 
eststo: ivreg2 dprc (u ep_1y = $instruments2 ) /// 
i.phase_i i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc,  ///
partial(i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc) 
estadd local Country_Fe "Yes"
estadd local Controls "Yes" 
estadd local Time_Fe "No"
estadd local IV "Int."    

*FLATTENING
eststo:   ivreg2 dprc (u u_after_gr ep_1y = $instruments2 ) /// 
i.phase_i i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc,  ///
partial(i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc)    
estadd local Country_Fe "Yes"
estadd local Controls "Yes" 
estadd local Time_Fe "No"
estadd local IV "Int."     

*ALL FLATTENINGS
eststo: ivreg2 dprc (u u_after_gr u_shift_gr u_after_sdc ///
 u_shift_sdc u_manuf_gr ///
u_manuf_sdc ep_1y = $instruments2 ) /// 
i.phase_i i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc, r ///
partial(i.id Import_Prices P_nrg ///
i.after_gr i.after_sdc shift_gr_n shift_sdc_n ///
Dva_manuf_gr Dva_manuf_sdc) ffirst
estadd local Country_Fe "Yes"
estadd local Controls "Yes" 
estadd local Time_Fe "No"
estadd local IV "Int." 

preserve
mat first=e(first)
gen stat_u2 = first[4,1]
gen stat_exp2 = first[4,8]
gen wald_f = e(cdf)
keep stat_u2 stat_exp2 wald_f
gen stat= "F" if _n ==1
replace stat= "Wald F-stat" if _n ==2
keep if _n<3
replace stat_u2 = wald_f if _n ==2
replace stat_exp2 = . if _n==2
drop wald_f
order stat
save "$OUTPUT/1st_stage_2.dta", replace 
restore
   
 
