use "$OUTPUT/modified_data_october23.dta", clear 
sort geo time
merge 1:1 id time using "$OUTPUT/hiring_separation_rates_2022", force
keep if _merge==3
drop _merge
merge 1:1 id time using  "$OUTPUT/national_account_data"
keep if _merge==3
drop _merge
merge m:1 id  using "$OUTPUT/betas_feb2023.dta"
drop _merge
********************************************************************************
xtset id time
 
bys id: gen sust_r = 100*log(gov_debt_ratio/l.gov_debt_ratio)
bys id phase_i : egen sust = mean(sust_r) 

foreach k in va_manuf RoutineNarrow DELTA H  ///
  u nairu_oecd dprc dprc_x_nrg_food sust{
bys geo phase_i: gen `k'_peak_ =`k' if _n== _N  & phase_i ==0
bys geo : egen `k'_peak = max(`k'_peak_)
drop `k'_peak_
bys geo phase_i: gen `k'_peak_2 =`k' if _n== _N  & phase_i ==2
bys geo : egen `k'_peak2 = max(`k'_peak_2)
drop `k'_peak_2
}

bys id  : replace Dva_manuf_gr = Dva_manuf_gr[_N] if Dva_manuf_gr==0
bys id  : replace Dva_manuf_sdc = Dva_manuf_sdc[_N] if Dva_manuf_sdc==0

*keep the variable and sample needed
bys geo rec_i_all: keep if _n==1
gen S = 1 if phase_i==1|phase_i==3
replace S=0 if S==.
drop if rec_i_all==0

sort geo time
drop id
gen id =_n
order id 
sort id time
order geo time phase_i

*Define labels 
label define id_label 1 "Austria GR" 2 "Austria SDC" 3 "Belgium GR" 4 "Belgium SDC" ///
5 "Finland GR" 6 "Finland SDC" 7 "Finland 13q4" 8 "Finland 15q1" 9 "Finland 18q4" ///
10 "France GR" 11 "France SDC" 12 "Germany 02q2" 13 "Germany 03q2" 14 "Germany 05q1" ///
15 "Germany GR" 16 "Germany SDC" 17 "Greece 05q2" 18 "Greece GR" 19 "Greece SDC" ///
20 "Ireland GR" 21 "Ireland SDC" 22 "Italy 02q2" 23 "Italy 03q2" 24 "Italy GR"  ///
25 "Italy SDC" 26 "Italy 18q3" 27 "Netherlands GR" 28 "Netherlands SDC" ///
 29 " Portugal 03q1" 30 "Portugal GR" ///
31 "Portugal SDC" 32 "Spain GR" 33 "Spain SDC"

label values id id_label 

keep if S==1
egen id2 = group(geo)

label define id2 1 "AT" 2 "BE" 3 "FI" 4 "FR" 5 "DE" 6 "GR" 7 "IE" ///
8 "IT" 9 "NL" 10 "PT" 11 "ES"
label values id2 id2

bys geo: gen shift_gr = shift_n if _n==1
bys geo: gen shift_sdc = shift_n[_n+1] if _n==1
bys geo: gen I = 1 if _n==1
********************************************************************************
**********************************SHIFTS****************************************
********************************************************************************

*Figure 4
*Occupational Shifts
graph bar shift_gr shift_sdc if I==1 , over(id2) ///
title(" ") bar(1, fcolor(white) lcolor(black) lwidth(medium))  bar(2, fcolor(gray) lcolor(black) lwidth(medium))  legend(label(1 "Great Recession") label(2 "Sovereign Debt Crisis")) ///
graphregion(fcolor(white)) ytitle(" ") ytitle("Occupational Shift (%)") 
graph export "$FIGURES/figure_4.pdf", as(pdf) replace

*Figure 7.c
*Sectoral Shifts
graph bar Dva_manuf_gr Dva_manuf_sdc if I==1, over(id2)  ///
title(" ")  bar(1, fcolor(white) lcolor(black) lwidth(medium))  bar(2, fcolor(gray) lcolor(black) lwidth(medium))  legend(label(1 "Great Recession") label(2 "Sovereign Debt Crisis")) ///
graphregion(fcolor(white)) ytitle(" ") ytitle("Sectoral Shift (%)") 
graph export "$FIGURES/figure_7c.pdf", as(pdf) replace

********************************************************************************
*******************************SCATTER PLOTS************************************
********************************************************************************

********************************************************************************
********************************FIGURE 5****************************************
********************************************************************************

*Figure 5.a
bys geo: replace RoutineNarrow_peak = RoutineNarrow_peak2 if _n==2
replace RoutineNarrow_peak = (RoutineNarrow_peak*100)
pwcorr RoutineNarrow_peak shift_n , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter RoutineNarrow_peak shift_n,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit RoutineNarrow_peak shift_n, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:}") legend(off) graphregion(fcolor(white)) ///
ytitle("Routine Share at Peak (%)") xtitle("Occupational Shift (%)")  		
graph export "$FIGURES/figure_5a.pdf", as(pdf) replace

*Figure 5.b
order coef_*
replace coef_before_gr = (coef_before_gr*100)
replace coef_before_sdc = (coef_before_sdc*100)
bys geo: replace coef_before_gr = coef_before_sdc if _n==2

pwcorr coef_before_gr shift_n, star(0.10) 
local corr2 : di %5.3g r(rho) 
twoway (scatter coef_before_gr shift_n,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit coef_before_gr shift_n, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:}") legend(off) graphregion(fcolor(white)) ///
ytitle("Long-run Routine Emp. Share growth rate (%)") xtitle("Occupational Shift (%)")  
graph export "$FIGURES/figure_5b.pdf", as(pdf) replace

*Figure 5.c
bys geo: replace va_manuf_peak = va_manuf_peak2 if _n==2
pwcorr va_manuf_peak shift_n, star(0.10)
local corr2 : di %5.3g r(rho)
twoway (scatter va_manuf_peak shift_n,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit va_manuf_peak shift_n   , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript:}") legend(off) graphregion(fcolor(white)) ///
ytitle("Value Added Share from Manuf. & Constr. at Peak") xtitle("Occupational Shift (%)")  
graph export "$FIGURES/figure_5c.pdf", as(pdf) replace

*Figure 5.d
bys geo: replace dprc_peak = dprc_peak2 if _n==2
pwcorr  dprc_peak shift_n, star(0.10)
local corr2 : di %5.3g r(rho)
twoway (scatter dprc_peak shift_n,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit dprc_peak shift_n   , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript:}") legend(off) graphregion(fcolor(white)) ///
ytitle("CPI Inflation at Peak (%)") xtitle("Occupational Shift (%)")  
graph export "$FIGURES/figure_5d.pdf", as(pdf) replace

********************************************************************************
***********************************FIGURE 6*************************************
********************************************************************************
*Figure 6.a 
pwcorr shock_T shift_n, star(0.01)
local corr2 : di %5.3g r(rho) 
twoway (scatter shock_T shift_n ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit shock_T shift_n, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:***}") legend(off) graphregion(fcolor(white)) ///
ytitle("Gdp Pct. Change between Peak and Trough (%)") xtitle("Occupational Shift (%)")  
graph export "$FIGURES/figure_6a.pdf", as(pdf) replace


*Figure 6.b 
pwcorr duration shift_n, star(0.01)
local corr2 : di %5.3g r(rho)
twoway (scatter duration shift_n,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit duration shift_n   , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript:***}") legend(off) graphregion(fcolor(white)) ///
ytitle("Lenght of Recession (qtr)") xtitle("Occupational Shift (%)")  
graph export "$FIGURES/figure_6b.pdf", as(pdf) replace

********************************************************************************
***********************************FIGURE 7.D***********************************
********************************************************************************
*Figure 7.d.
bys geo: replace Dva_manuf_gr = Dva_manuf_sdc if _n==2
pwcorr Dva_manuf_gr shift_n, star(0.1)
local corr2 : di %5.3g r(rho)
twoway (scatter Dva_manuf_gr shift_n,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit Dva_manuf_gr shift_n   , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript:*}") legend(off) graphregion(fcolor(white)) ///
ytitle("Sectoral Shift (%)") xtitle("Occupational Shift (%)")  
graph export "$FIGURES/figure_7d.pdf", as(pdf) replace

********************************************************************************
**********************************FIGURE B.2************************************
********************************************************************************

*Figure B.2.a
pwcorr RoutineNarrow_peak Dva_manuf_gr , star(0.05)
local corr2 : di %5.3g r(rho) 
twoway (scatter RoutineNarrow_peak Dva_manuf_gr,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit RoutineNarrow_peak Dva_manuf_gr, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:**}") legend(off) graphregion(fcolor(white)) ///
ytitle("Routine Share at Peak (%)") xtitle("Sectoral Shift (%)")  
graph export "$FIGURES/figure_B2a.pdf", as(pdf) replace

*Figure B.2.b
pwcorr coef_before_gr Dva_manuf_gr , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter coef_before_gr Dva_manuf_gr ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit coef_before_gr Dva_manuf_gr , lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:*}") legend(off) graphregion(fcolor(white)) ///
ytitle("Long-run Routine Emp. Share growth rate (%)") xtitle("Sectoral Shift (%)")  
graph export "$FIGURES/figure_B2b.pdf", as(pdf) replace

*Figure B.2.c
bys geo: replace va_manuf_peak = va_manuf_peak2 if _n==2
pwcorr va_manuf_peak Dva_manuf_gr, star(0.10)
local corr2 : di %5.3g r(rho)
twoway (scatter va_manuf_peak Dva_manuf_gr,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit va_manuf_peak Dva_manuf_gr   , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript:}") legend(off) graphregion(fcolor(white)) ///
ytitle("Value Added Share from Manuf. & Constr. at Peak (%)") xtitle("Sectoral Shift (%)")  
graph export "$FIGURES/figure_B2c.pdf", as(pdf) replace

*Figure B.2.d
bys geo: replace dprc_peak = dprc_peak2 if _n==2
pwcorr dprc_peak Dva_manuf_gr, star(0.10)
local corr2 : di %5.3g r(rho)
twoway (scatter dprc_peak Dva_manuf_gr,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit dprc_peak Dva_manuf_gr  , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript: }") legend(off) graphregion(fcolor(white)) ///
ytitle("CPI Inflation at Peak (%)") xtitle("Sectoral Shift (%)")  
graph export "$FIGURES/figure_B2d.pdf", as(pdf) replace

********************************************************************************
**********************************FIGURE B.2************************************
********************************************************************************
*Figure B.2.a 
pwcorr shock_T Dva_manuf_gr, star(0.05)
local corr2 : di %5.3g r(rho) 
twoway (scatter shock_T Dva_manuf_gr ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit shock_T Dva_manuf_gr, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:**}") legend(off) graphregion(fcolor(white)) ///
ytitle("Gdp Pct. Change between Peak and Trough (%)") xtitle("Sectoral Shift (%)")  
graph export "$FIGURES/figure_B4a.pdf", as(pdf) replace

*Figure B.2.b 
pwcorr duration Dva_manuf_gr, star(0.01)
local corr2 : di %5.3g r(rho)
twoway (scatter duration Dva_manuf_gr,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit duration Dva_manuf_gr   , lwidth(thick) lcolor(navy)) ,  /// 
title(" ")subtitle(" {&rho} = `corr2'{superscript:***}") legend(off) graphregion(fcolor(white)) ///
ytitle("Lenght of Recession (qtr)") xtitle("Sectoral Shift (%)")  
graph export "$FIGURES/figure_B4b.pdf", as(pdf) replace
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************

********************************************************************************
********************************************************************************
*Figure B1a
bys geo: replace u_peak = u_peak2 if _n==2
pwcorr u_peak shift_n, star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter u_peak shift_n ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit u_peak shift_n, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) graphregion(fcolor(white)) ///
xtitle("Occupational Shift (%)") ytitle("Aggregate Unemp. Rate (%)")  
graph export "$FIGURES/figure_B1a.pdf", as(pdf) replace

*Figure B3a
pwcorr u_peak Dva_manuf_gr , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter u_peak Dva_manuf_gr  ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit u_peak Dva_manuf_gr , lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) graphregion(fcolor(white)) ///
xtitle("Sectoral Shift (%)") ytitle("Aggregate Unemp. Rate (%)")  
graph export "$FIGURES/figure_B3a.pdf", as(pdf) replace

drop coef_before_gr coef_before_sdc
preserve
use "$OUTPUT/betas_feb2023.dta", clear
rename id id_
save  "$OUTPUT/betas_feb2023_scatter.dta", replace 
restore

egen id_=group(geo)
merge m:1 id_ using "$OUTPUT/betas_feb2023_scatter.dta"
drop _merge
 
*Figure B1c
bys geo: replace coef_before_gr = coef_before_sdc[2] if _n==2
pwcorr coef_before_gr shift_n , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter coef_before_gr shift_n ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit coef_before_gr shift_n, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) graphregion(fcolor(white)) ///
xtitle("Occupational Shift (%)")  ytitle("{&kappa} at Peak")  
graph export "$FIGURES/figure_B1c.pdf", as(pdf) replace

*Figure B3c
pwcorr coef_before_gr Dva_manuf_gr , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter coef_before_gr Dva_manuf_gr ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit coef_before_gr Dva_manuf_gr, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) graphregion(fcolor(white)) ///
xtitle("Sectoral Shift (%)")  ytitle("{&kappa} at Peak")  
graph export "$FIGURES/figure_B3c.pdf", as(pdf) replace

*Figure B1b
bys geo: replace DELTA_peak = DELTA_peak2 if _n==2 
pwcorr DELTA_peak shift_n , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter DELTA_peak shift_n ,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit DELTA_peak shift_n, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) graphregion(fcolor(white)) ///
xtitle("Occupational Shift (%)") ytitle("Aggregate Separation Rate (%)")  
graph export "$FIGURES/figure_B1b.pdf", as(pdf) replace

*Figure B3b
pwcorr DELTA_peak Dva_manuf_gr , star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter DELTA_peak Dva_manuf_gr,  mlabel(id) mcolor(navy) mlabposition(12) ) ///
(lfit DELTA_peak Dva_manuf_gr, lwidth(thick) lcolor(navy)), ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:}") legend(off) graphregion(fcolor(white)) ///
xtitle("Sectoral Shift (%)") ytitle("Aggregate Separation Rate (%)")  
graph export "$FIGURES/figure_B3b.pdf", as(pdf) replace
