use "$OUTPUT/modified_data_october23.dta", clear 
xtset geo time

*DEFINE UNEMPLOYMENT GAP
bys id : replace u =  (u/nairu_oecd-1 )*100
bys id : replace lu = (lu/lnairu_oecd-1)*100
bys id : replace l2u = (l2u/l2nairu_oecd-1)*100
bys id : replace l2u = (l3u/l3nairu_oecd-1)*100
bys id : replace l4u = (l4u/l4nairu_oecd-1)*100
*Define variables as in Stock and Watson
bys id : gen u_sw  = 0.25*(u + lu + l2u + l3u)
bys id : gen ygap_sw  = 0.25*(y_gap + ly_gap + l2y_gap + l3y_gap) 
bys id : gen dprc_sw =  (dprc_x_nrg_food + ldprc_x_nrg_food + l2dprc_x_nrg_food + l3dprc_x_nrg_food)*0.25  ///
- (l4dprc_x_nrg_food + l5dprc_x_nrg_food + l6dprc_x_nrg_food +l7dprc_x_nrg_food)*0.25 
*Dummy before and after 2010
gen before_2010 = 0 if year< 2011
replace before_2010 = 1 if year>=2011
xtset id time
********************************************************************************
***********************************Table 1**************************************
********************************************************************************
*STOCK AND WHATSON CORRELATION

*TABLE 1 
gen after_09=year>2009
eststo clear
eststo: xtreg dprc_sw u_sw  c.u_sw#i.after_09 i.after_09  , fe  cluster(id)
esttab using  "$TABLES/tab_1.tex", nocon drop(_cons *.after_09 0.after_09*) b(4) se(4) scalars("Window" "Window") ///
label compress star(* 0.10 ** 0.05 *** 0.01) coeflabel(u_sw "\$\hat{u}\$" 1.after_09#c.u_sw  ///
"\$\hat{u}\times\mathbb{I}(year>2009)\$") ///
mtitles("\$\pi^{Core}\$" "\$\pi^{Core}\$" )  ///
substitute("\_" "_") replace
eststo clear

********************************************************************************
*******Generate slopes by country and periods to be used for scatterplots*******
********************************************************************************
*By country
preserve 
xtreg dprc_sw i.id#c.u_sw if after_gr==0, fe  
regsave using "$OUTPUT/results_before2010", ci replace 
use "$OUTPUT/results_before2010", clear 
drop if var=="_cons"  
gen id = _n 
keep coef id
rename coef coef_before2010
save "$OUTPUT/results_before2010", replace 
restore

*By country
preserve 
xtreg dprc_sw i.id#c.u_sw if after_gr==1,  fe  
regsave using "$OUTPUT/results_after2010", ci replace 
use "$OUTPUT/results_after2010", clear 
drop if var=="_cons" 
gen id = _n 
keep coef id
rename coef coef_after2010 
save "$OUTPUT/results_after2010", replace  
restore

*FOR SCATTER*By country
preserve 
xtreg dprc_sw i.id#c.u_sw if phase_i<1, fe  
regsave using "$OUTPUT/results_before_gr", ci replace 
use "$OUTPUT/results_before_gr", clear 
drop if var=="_cons"  
gen id = _n 
keep coef id

rename coef coef_before_gr
save "$OUTPUT/results_before_gr", replace 
restore

preserve 
xtreg dprc_sw i.id#c.u_sw if phase_i==2, fe  
regsave using "$OUTPUT/results_before_sdc", ci replace 
use "$OUTPUT/results_before_sdc", clear 
drop if var=="_cons"  
gen id = _n 
keep coef id
rename coef coef_before_sdc
save "$OUTPUT/results_before_sdc", replace 
restore


********************************************************************************
***********************************Table C.1************************************
********************************************************************************
*STOCK AND WHATSON CORRELATIONS
eststo clear
eststo: xtreg dprc_sw u_sw if year < 2010, fe
estadd local Window "[2002-2009]"   
eststo: xtreg dprc_sw u_sw if year >= 2010, fe  
estadd local Window "[2010-2018]" 
eststo: xtreg dprc_sw ygap_sw if year < 2010, fe
estadd local Window "[2002-2009]"   
eststo: xtreg dprc_sw ygap_sw if year >= 2010, fe  
estadd local Window "[2010-2018]" 

esttab using "$TABLES/tab_C1.tex", nocon noobs drop(_cons) b(2) se(2) scalars("Window" "Window") ///
label compress star(* 0.10 ** 0.05 *** 0.01) coeflabel(u_sw "\$\hat{u}\$" ygap_sw "\$\hat{y}\$"  ) ///
mtitles("\$\pi^{Core}\$" "\$\pi^{Core}\$" "\$\pi^{Core}\$" "\$\pi^{Core}\$")  ///
substitute("\_" "_") replace


******
use "$OUTPUT/results_before2010", clear 
merge 1:1 id using "$OUTPUT/results_after2010"
drop _merge

label define id 1 "AT" 2 "BE" 3 "FI" 4 "FR" 5 "DE" 6 "GR" 7 "IE" ///
 8 "IT" 9 "NL" 10 "PT" 11 "ES"
label values id  id 
order id 
gen DELTA_beta = coef_after2010 - coef_before2010
save "$OUTPUT/DELTA_beta", replace

use "$OUTPUT/modified_data_october23.dta", clear 
xtset geo time

bys id: gen DELTA_ROUTINE_SHARE = 100*(RoutineNarrow[_N]/RoutineNarrow[1]-1)
bys id: keep if _n==1 
keep  geo id DELTA_ROUTINE_SHARE
merge 1:1 id using "$OUTPUT/DELTA_beta"
drop _merge

********************************************************************************
**********************************FIGURE 3************************************
********************************************************************************
pwcorr DELTA_beta DELTA_ROUTINE_SHARE , star(0.01)
local corr2 : di %5.3g r(rho) 
twoway (scatter DELTA_beta DELTA_ROUTINE_SHARE, mlabel(geo) mcolor(navy) mlabposition(12) ) ///
(lfit DELTA_beta DELTA_ROUTINE_SHARE, lwidth(thick) lcolor(red)) , ///
title(" ") subtitle(" {&rho} = `corr2'{superscript:***}") legend(off) ///
graphregion(fcolor(white)) ytitle("{&kappa}{subscript:T} - {&kappa}{subscript:0}") ///
xtitle("{&Delta}Routine Emp{subscript:(T,0)} (%)")  
graph export "$FIGURES/figure_3.pdf", as(pdf) replace


use "$OUTPUT/results_before_gr", clear 
merge 1:1 id using "$OUTPUT/results_before_sdc"
drop _merge
save "$OUTPUT/betas_feb2023", replace 

********************************************************************************
**********************************FIGURE 10.c***********************************
********************************************************************************

use "$OUTPUT/modified_data_october23.dta", clear 
merge 1:1 id time using "$OUTPUT/hiring_separation_rates_2022"
keep if _merge ==3
drop _merge 
order geo time phase_i DELTA 
bys id  phase_i : keep if (_n>_N-8 & phase_i==0) | (_n<=8 & phase_i==4)
bys id phase_i: egen mean_d_phase_i = mean(DELTA)
bys id phase_i: egen mean_h_phase_i = mean(H)
order geo id phase_i mean_d_phase_i
keep if phase_i ==0 | phase_i ==4 
bys id phase_i: keep if _n==1
bys id : gen delta_DELTA = 100*(mean_d_phase_i[2]/mean_d_phase_i[1]-1)
bys id : gen delta_H = 100*(mean_h_phase_i[2]/mean_h_phase_i[1]-1)
bys id : keep if _n ==1 
merge 1:1 id using "$OUTPUT/DELTA_beta"
keep id DELTA_beta delta_DELTA* delta_H geo mean_h_phase_i

pwcorr DELTA_beta delta_DELTA,  star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter DELTA_beta delta_DELTA, mlabel(geo) mcolor(navy) mlabposition(12) ) ///
(lfit DELTA_beta delta_DELTA, lwidth(thick) lcolor(red)) , ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) ///
graphregion(fcolor(white)) ytitle("{&kappa}{subscript:T} - {&kappa}{subscript:0}") ///
xtitle("{&Delta}Separation Rate{subscript:(T,0)} (%)")  
graph export "$FIGURES/figure_10c.pdf", as(pdf) replace


********************************************************************************
**********************************FIGURE E1c*************************************
********************************************************************************
preserve
drop if id ==7
pwcorr DELTA_beta delta_H,  star(0.10)
local corr2 : di %5.3g r(rho) 
twoway (scatter DELTA_beta delta_H, mlabel(geo) mcolor(navy) mlabposition(12) ) ///
(lfit DELTA_beta delta_H, lwidth(thick) lcolor(red)) , ///
title(" ") subtitle(" {&rho} = `corr2'{superscript: }") legend(off) ///
graphregion(fcolor(white)) ytitle("{&kappa}{subscript:T} - {&kappa}{subscript:0}") ///
xtitle("{&Delta}Hiring Rate{subscript:(T,0)} (%)")  
graph export "$FIGURES/figure_E1c.pdf", as(pdf) replace
restore
********************************************************************************

keep id delta_DELTA
rename delta_DELTA Ddelta
save "$OUTPUT/Ddelta", replace










