use "$OUTPUT/modified_data_october23.dta", clear 
xtset geo time

********************************************************************************
******************************ROUTINE SHARE*************************************
********************************************************************************
*Figure A.1
gen r = RoutineNarrow*100
twoway (tsline r if id==1, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline r if id==2, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline r if id==3, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline r if id==4, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline r if id==5, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline r if id==6, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline r if id==7, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline r if id==8, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline r if id==9, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline r if id==10, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline r if id==11, lwidth(thick)), ytitle("Routine Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A1.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
********************************COGNITIVE SHARE*********************************
********************************************************************************
*Figure A.2
gen a = Cognitive*100
twoway (tsline a if id==1, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline a if id==2, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline a if id==3, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline a if id==4, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline a if id==5, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline a if id==6, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline a if id==7, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline a if id==8, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline a if id==9, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline a if id==10, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline a if id==11, lwidth(thick)), ytitle("Abstract Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A2.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
******************************MANUAL SHARE**************************************
********************************************************************************
*Figure A.3
gen m = 100-a-r
twoway (tsline m if id==1, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline m if id==2, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline m if id==3, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline m if id==4, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline m if id==5, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline m if id==6, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline m if id==7, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline m if id==8, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline m if id==9, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline m if id==10, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline m if id==11, lwidth(thick)), ytitle("Manual Emp. Share (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A3.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
***************************Unemployment*****************************************
********************************************************************************
*Figure A.4
twoway (tsline u if id==1, lwidth(thick)) (tsline nairu_oecd if id==1, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline u if id==2, lwidth(thick)) (tsline nairu_oecd if id==2, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline u if id==3, lwidth(thick)) (tsline nairu_oecd if id==3, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline u if id==4, lwidth(thick))(tsline nairu_oecd if id==4, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline u if id==5, lwidth(thick))(tsline nairu_oecd if id==5, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline u if id==6, lwidth(thick))(tsline nairu_oecd if id==6, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece")   xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline u if id==7, lwidth(thick))(tsline nairu_oecd if id==7, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline u if id==8, lwidth(thick))(tsline nairu_oecd if id==8, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline u if id==9, lwidth(thick))(tsline nairu_oecd if id==9, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline u if id==10, lwidth(thick))(tsline nairu_oecd if id==10, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline u if id==11, lwidth(thick))(tsline nairu_oecd if id==11, lwidth(thick)), ytitle("Unemp. Rate & NAIRU (%)")  ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232)legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A4.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
*************************************GDP****************************************
********************************************************************************
*Figure A.5
replace dgdp = dgdp*100
twoway (tsline dgdp if id==1, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline dgdp if id==2, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline dgdp if id==3, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline dgdp if id==4, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")  xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline dgdp if id==5, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline dgdp if id==6, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline dgdp if id==7, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline dgdp if id==8, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline dgdp if id==9, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline dgdp if id==10, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline dgdp if id==11, lwidth(thick)), ytitle("Gdp Growth Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A5.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
****************************CPI Inflation***************************************
********************************************************************************
*Figure A.6
twoway (tsline dprc  if id==1, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline dprc  if id==2, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline dprc  if id==3, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline dprc  if id==4, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline dprc  if id==5, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline dprc  if id==6, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline dprc  if id==7, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")  xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline dprc  if id==8, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline dprc  if id==9, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline dprc  if id==10, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline dprc  if id==11, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A6.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph


********************************************************************************
***************************Core Inflation***************************************
********************************************************************************
*Figure A.7
twoway (tsline dprc_x_nrg_food if id==1, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline dprc_x_nrg_food if id==2, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline dprc_x_nrg_food if id==3, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline dprc_x_nrg_food if id==4, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline dprc_x_nrg_food if id==5, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline dprc_x_nrg_food if id==6, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline dprc_x_nrg_food if id==7, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")  xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline dprc_x_nrg_food if id==8, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline dprc_x_nrg_food if id==9, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline dprc_x_nrg_food if id==10, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline dprc_x_nrg_food if id==11, lwidth(thick)), ytitle("Core Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A7.pdf" , as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph


********************************************************************************
*****************************NT Inflation***************************************
********************************************************************************
*Figure A.8
twoway (tsline dp_nt  if id==1, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline dp_nt  if id==2, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline dp_nt  if id==3, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline dp_nt  if id==4, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline dp_nt  if id==5, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline dp_nt  if id==6, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline dp_nt  if id==7, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")  xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline dp_nt  if id==8, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline dp_nt  if id==9, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline dp_nt  if id==10, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline dp_nt  if id==11, lwidth(thick)), ytitle("CPI Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A8.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
*******************************EXPECTED CPI Inflation***************************
********************************************************************************
*Figure A.11
twoway (tsline ep_1y if id==1, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline ep_1y if id==2, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(#4) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline ep_1y if id==3, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(#4) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline ep_1y if id==4, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline ep_1y if id==5, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline ep_1y if id==6, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece")   xlabel(#4) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline ep_1y if id==7, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")   xlabel(#4) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline ep_1y if id==8, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy")   xlabel(#4) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline ep_1y if id==9, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands")   xlabel(#4) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline ep_1y if id==10, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline ep_1y if id==11, lwidth(thick)), ytitle("Expected Inf. Rate (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain")   xlabel(#4) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A11.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
*******************************Import Price Index ******************************
********************************************************************************
*Figure A.12 
twoway (tsline Import_Prices if id==1, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline Import_Prices if id==2, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(#4) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline Import_Prices if id==3, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(#4) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline Import_Prices if id==4, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline Import_Prices if id==5, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline Import_Prices if id==6, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece")   xlabel(#4) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline Import_Prices if id==7, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")   xlabel(#4) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline Import_Prices if id==8, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy")   xlabel(#4) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)


twoway (tsline Import_Prices if id==9, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands")   xlabel(#4) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline Import_Prices if id==10, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline Import_Prices if id==11, lwidth(thick)), ytitle("Import Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain")   xlabel(#4) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A12.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
*****************************ENERGY Price Index ********************************
********************************************************************************
*Figure A.13
twoway (tsline   P_nrg if id==1, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline   P_nrg if id==2, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(#4) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline  P_nrg if id==3, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(#4) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline  P_nrg if id==4, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline  P_nrg if id==5, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline  P_nrg if id==6, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece")   xlabel(#4) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline  P_nrg if id==7, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")   xlabel(#4) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline  P_nrg if id==8, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy")   xlabel(#4) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline  P_nrg if id==9, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands")   xlabel(#4) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline  P_nrg if id==10, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline   P_nrg if id==11, lwidth(thick)), ytitle("Energy Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain")   xlabel(#4) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A13.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
*******************************NT Price Index **********************************
********************************************************************************
*Figure A.14
replace  p_nt = 100-p_nt
twoway (tsline p_nt if id==1, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline   p_nt if id==2, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(#4) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline  p_nt if id==3, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(#4) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline  p_nt if id==4, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline  p_nt if id==5, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline  p_nt if id==6, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece")   xlabel(#4) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline  p_nt if id==7, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland")   xlabel(#4) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline  p_nt if id==8, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy")   xlabel(#4) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline  p_nt if id==9, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands")   xlabel(#4) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline p_nt if id==10, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal")   xlabel(#4) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline  p_nt if id==11, lwidth(thick)), ytitle("Non-tradable Price Index") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain")   xlabel(#4) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A14.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph

********************************************************************************
*************************CONDITIONAL SEPARATION/HIRING RATE*********************
********************************************************************************
*Figure E.2
use "$OUTPUT/conditional_hiring_separation", clear 

by id: gen ua = unemp_a/lf
by id: gen ur = unemp_r/lf
by id: gen um = unemp_m/lf

xtreg X_a i.time ua, fe cluster(id)
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Separation Rate Abstract Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))  
graph export "$FIGURES/figure_E2a.pdf", as(pdf) replace

xtreg X_r i.time ur, fe cluster(id)
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Separation Rate Routine Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_E2b.pdf", as(pdf) replace

xtreg X_m i.time um, fe cluster(id)
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Separation Rate Manual Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))  
graph export "$FIGURES/figure_E2c.pdf", as(pdf) replace

preserve
drop if id==7
xtreg h_a i.time ua, fe cluster(id)
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Hiring Rate Abstract Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))  
graph export "$FIGURES/figure_E2d.pdf", as(pdf) replace

xtreg h_r i.time ur, fe cluster(id)
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Hiring Rate Routine Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))  
graph export "$FIGURES/figure_E2e.pdf", as(pdf) replace

xtreg h_m i.time um, fe cluster(id)
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Hiring Rate Manual Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))  
graph export "$FIGURES/figure_E2f.pdf", as(pdf) replace
restore
********************************************************************************
********************************************************************************
********************************************************************************
rename X_a delta_a2
rename X_r delta_r2
rename X_m delta_m2
keep id geo time phase_i phase delta_a2 delta_r2 delta_m2 h_a h_r h_m
save "$OUTPUT/intermediate_conditional_h_d", replace 
 
*define jobs and 1st wave
forvalues k=0/4{
use "$OUTPUT/intermediate_conditional_h_d", clear 
keep geo time phase_i delta_r2 h_r
keep if phase_i==`k'
rename delta_r2 delta
rename h_r h
gen job = 1
gen wave = `k'
save deltaR1_def`k', replace

use "$OUTPUT/intermediate_conditional_h_d", clear 
keep geo time phase_i delta_a2 h_a
keep if phase_i==`k' 
rename delta_a2 delta
rename h_a h
gen job = 2
gen wave = `k'
save deltaA1_def`k', replace

use "$OUTPUT/intermediate_conditional_h_d", clear 
keep geo time phase_i delta_m2 h_m
keep if phase_i==`k'
rename delta_m2 delta 
rename h_m h
gen job = 3
gen wave = `k'
save deltaM1_def`k', replace
}

use deltaR1_def0, clear 
forvalues k=1/4{
append using deltaR1_def`k'
}
save Rfinal, replace

use deltaA1_def0, clear 
forvalues k=1/4{
append using deltaA1_def`k'
}
save Afinal, replace

use deltaM1_def0, clear 
forvalues k=1/4{
append using deltaM1_def`k'
}
save Mfinal, replace

use Rfinal, clear 
append using Mfinal
append using Afinal
label define job 1 "Routine" 2 "Abstract" 3 "Manual"
label values job job
label define wave  0 "Before GR "1 "GR" 2 "Between GR & SDC" 3 "SDC" 4 "After SDC"
label values wave wave
drop if phase_i ==1|phase_==3|phase_==2

*Figure 10a 
cibar delta ,  over(job)  barcolor(white gray black) baropts(lcolor(black) lwidth(medium)) ciopts(lcolor(red) lwidth(medium)) graphopts(graphregion(fcolor(white) )    ///
ytitle("Decomposition of the Separation Rate by Occupation (%)", size(small)) legend(col(3))   )
graph export "$FIGURES/figure_10a.pdf", as(pdf) replace

*Figure E1a
drop if geo=="Ireland"
cibar h ,  over( job  )  barcolor(white gray black) baropts(lcolor(black) lwidth(medium)) ciopts(lcolor(red) lwidth(medium))  graphopts(graphregion(fcolor(white))   ///
ytitle("Decomposition of the Hiring Rate by Occupation (%)", size(small)) legend(col(3)) )
graph export "$FIGURES/figure_E1a.pdf", as(pdf) replace
 
erase Mfinal.dta   
erase Rfinal.dta 
erase Afinal.dta
erase "$OUTPUT/intermediate_conditional_h_d.dta"

forvalues k=0/4{
erase deltaA1_def`k'.dta
} 

forvalues k=0/4{
erase deltaR1_def`k'.dta
} 

forvalues k=0/4{
erase deltaM1_def`k'.dta
} 

********************************************************************************
*************************AGGREGATE SEPARATION/HIRING RATE***********************
********************************************************************************
use "$OUTPUT/aggregate_hiring_separation", clear 
*Figure 10b
xtreg DELTA i.time  u , fe cluster(id) 
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Aggregate Separation Rate (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_10b.pdf", as(pdf) replace

*Figure E1b
xtreg H i.time  u if id!=7,   fe cluster(id) 
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Aggregate Hiring Rate (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ") xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_E1b.pdf", as(pdf) replace

keep id time  DELTA H  
save "$OUTPUT/hiring_separation_rates_2022.dta", replace 

********************************************************************************
*************************MULTIPLE CONTRACTS PROB. BY JOB************************
********************************************************************************
use "$OUTPUT/multiple_contract_probability", clear 
xtset id time

*Figure E3d
xtreg multi_a i.time , fe  
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Prob. of Multiple Contracts in Abstract Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_E3a.pdf", as(pdf) replace

*Figure E3e
xtreg multi_r i.time, fe  
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Prob. of Multiple Contracts in Routine Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_E3b.pdf", as(pdf) replace

*Figure E3f
xtreg multi_m i.time, fe  
margins i.time
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Prob. of Multiple Contracts in Manual Jobs (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_E3c.pdf", as(pdf) replace

preserve 
keep id year multi_r  phase_i 
rename multi_r prob_t
 gen job =1
save temp_1, replace 
restore 

preserve 
keep id year  multi_a  phase_i 
rename multi_a prob_t
 gen job =2
save temp_2, replace 
restore

preserve 
keep id year multi_m phase_i 
rename multi_m prob_t
gen job =3
save temp_3, replace 
restore

use temp_1, clear 
append using temp_2
append using temp_3

label define job 1 "Routine" 2 "Abstract" 3 "Manual"
label values job job

 
bys id job: replace prob_t = prob_t
replace prob_t =. if prob_t==0

*Figure 11.a
keep if phase_i==0| phase_i==4 
bys job : sum prob_t
cibar prob_t , over(job) barcolor(white gray black) baropts(lcolor(black) lwidth(medium)) ciopts(lcolor(red) lwidth(medium)) graphopts(graphregion(fcolor(white))  ///
ytitle("(Conditional) Probability of having more than one job (%)", ///
size(small)) legend(col(3)) )
graph export "$FIGURES/figure_11.pdf", as(pdf) replace

erase temp_1.dta   
erase temp_2.dta 
erase temp_3.dta

********************************************************************************
**********************Share of Productivity Henacement Investments**************
********************************************************************************
*Figure 12
use "$OUTPUT/tech_change_investment.dta", clear 
xtreg inv_into_tech_change i.time ,fe  
margins i.time , 
marginsplot, recast(line) recastci(rarea)  tline( 2008  , lwidth(7.3) lcolor(gs15) ) tline( 2011 2012 , lwidth(7.3) lcolor(gs15) ) ///
title(" ") ///
ytitle("Investments in ICT & Innovation (%)") graphregion(fcolor(white)) xtitle(" ")  xlabel(#8) /// 
plotopts(lcolor(midblue) lwidth(thick)) ciopts(fcolor(ltblue) fintensity(30%) lcolor(ltblue))
graph export "$FIGURES/figure_12.pdf", as(pdf) replace

 
********************************************************************************
*********************************CALVO PARAMETER********************************
********************************************************************************
use "$DATA/WDN_ecb_data.dta", clear 
*Figure 10d.1
twoway (lfitci P_frequency_1013 r_share [pw=wb] , lwidth(thick)  level(99) ), ///
ytitle("N. of price change per year") graphregion(fcolor(white)) title("(d).1") ///
xtitle("Routine Share (%)") legend(off) saving(a, replace)
twoway (lfitci P_frequency_1013 a_share [pw=wb] , lwidth(thick)  level(99) ), ///
ytitle("N. of price change per year") graphregion(fcolor(white)) title("(d).2") ///
xtitle("Abstract Share (%)") legend(off) saving(b, replace)
twoway (lfitci P_frequency_1013 m_share [pw=wb] , lwidth(thick)  level(99) ), ///
ytitle("N. of price change per year") graphregion(fcolor(white)) title("(d).3") ///
xtitle("Manual Share (%)") legend(off) saving(c, replace)
gr combine a.gph b.gph c.gph, graphregion(fcolor(white)) cols(3)  xcommon 
graph export "$FIGURES/figure_10d.pdf", as(pdf) replace
erase a.gph 
erase b.gph 
erase c.gph 

********************************************************************************
***********************WAGE INFLATION BUSINESS ECON.****************************
********************************************************************************
use "$OUTPUT/modified_data_october23.dta", clear 
xtset id time
merge 1:1 id time using  "$OUTPUT/wage_nontradable_inflation2023"
rename _merge merge_1
merge 1:1 id time using "$OUTPUT/labor_cost_index_nace_2023_new_BN", force
xtset id time
keep if merge_1 ==3
xtset id time
 
*Figure A.9
twoway (tsline inf_w_bn if id==1, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)

twoway (tsline inf_w_bn if id==2, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)

twoway (tsline inf_w_bn if id==3, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline inf_w_bn if id==4, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")  xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline inf_w_bn if id==5, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline inf_w_bn if id==6, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline inf_w_bn if id==7, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline inf_w_bn if id==8, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)

twoway (tsline inf_w_bn if id==9, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline inf_w_bn if id==10, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline inf_w_bn if id==11, lwidth(thick)), ytitle("Wage Inflation - Bus. Economy (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)

gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
,graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A9.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph


********************************************************************************
*************************NON TRADABLE WAGE INFLATION****************************
********************************************************************************

twoway (tsline w_inf_nt if id==1, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Austria")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(a,replace)


twoway (tsline w_inf_nt if id==2, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Belgium")   xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(b,replace)


twoway (tsline w_inf_nt if id==3, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Finland")   xlabel(168 184 200 216 232) legend(off) ///
tline(2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(c,replace)

twoway (tsline w_inf_nt if id==4, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("France")  xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(d,replace)

twoway (tsline w_inf_nt if id==5, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Germany") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(e,replace)

twoway (tsline w_inf_nt if id==6, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Greece") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1, lwidth(1) lcolor(gs15) ) ///
tline(2009q4 2010q1 2010q2 2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 ///
2012q3 2012q4 2013q1, lwidth(1) lcolor(gs15) ) saving(f,replace)

twoway (tsline w_inf_nt if id==7, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Ireland") xlabel(168 184 200 216 232) legend(off) ///
tline(2007q1 2007q2 2007q3 2007q4 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 , lwidth(1) lcolor(gs15) ) saving(g,replace)

twoway (tsline w_inf_nt if id==8, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Italy") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, lwidth(1) lcolor(gs15) ) ///
tline(2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 , lwidth(1) lcolor(gs15) ) saving(h,replace)


twoway (tsline w_inf_nt if id==9, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Netherlands") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(i,replace)

twoway (tsline w_inf_nt if id==10, lwidth(thick)), ytitle("Wage Inflation - NT Sectors (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Portugal") xlabel(168 184 200 216 232) legend(off) ///
tline(2008q1 2008q2 2008q3 2008q4 2009q1 , lwidth(1) lcolor(gs15) ) ///
tline(2010q3 2010q4 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 , lwidth(1) lcolor(gs15) ) saving(j,replace)

twoway (tsline w_inf_nt if id==11, lwidth(thick)), ytitle("Wage Inflation - NT Sectors  (%)") ///
graphregion(fcolor(white)) title(" ") xtitle(" ") title("Spain") xlabel(168 184 200 216 232) legend(off) ///
tline( 2008q2 2008q3 2008q4 2009q1 2009q2 2009q3 2009q4 2010q1, lwidth(1) lcolor(gs15) ) ///
tline(2010q4 2011q1 2011q1 2011q2 2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1 ///
2013q2 2013q3 , lwidth(1.5) lcolor(gs15) ) saving(k,replace)


gr combine a.gph b.gph c.gph d.gph e.gph f.gph g.gph h.gph i.gph j.gph k.gph ///
, graphregion(fcolor(white)) 
graph export "$FIGURES/figure_A10.pdf", as(pdf) replace 
erase a.gph 
erase b.gph 
erase c.gph 
erase d.gph 
erase e.gph 
erase f.gph 
erase g.gph 
erase h.gph 
erase i.gph 
erase j.gph 
erase k.gph




 



 




