*Analysis on Job Polarization
 
use "$OUTPUT/modified_data_october23.dta", clear 
*define panel 
xtset geo time
*redefine variables
replace RoutineNarrow = RoutineNarrow*100
replace Coginitive = Coginitive*100
replace ManualBroad = ManualBroad*100
rename RoutineNarrow r
rename Coginitive a
rename ManualBroad m
replace m = 100-a-r

********************************************************************************
***********************************TABLE 2**************************************
********************************************************************************

eststo clear
eststo: xtreg r time, fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg r time i.phase_i i.phase_i#c.time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
 
eststo: xtreg a time, fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg a time i.phase_i i.phase_i#c.time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"

eststo: xtreg m  time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg m time i.phase_i i.phase_i#c.time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"

esttab, nocon drop( *.phase_i _cons) b(3) se(3) scalars("Country_Fe" "Controls") ///
label compress star(* 0.10 ** 0.05 *** 0.01) 
esttab using "$TABLES/tab_2.tex", replace drop(*.phase_i  _cons 0.phase_i#c.time) ///
scalars("Country_Fe" "Controls") substitute("\_" "_" "_" " " ) ///
mtitles("\$Share^{R}\$" "\$Share^{R}\$" "\$Share^{A}\$" "\$Share^{A}\$" "\$Share^{M}\$" "\$Share^{M}\$") ///
b(3) se(3) r2(3) label compress star(* 0.10 ** 0.05 *** 0.01) 
eststo clear

********************************************************************************
******************************APPENDIX: TABLE B1********************************
********************************************************************************
eststo clear
eststo: xtreg r time, fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg r time i.phase_i i.phase_i#c.time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
 
eststo: xtreg a time, fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg a time i.phase_i i.phase_i#c.time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"

eststo: xtreg m  time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg m time i.phase_i i.phase_i#c.time, fe  cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"

esttab, nocon keep( *.phase_i  ) b(3) se(3) scalars("Country_Fe" "Controls") ///
label compress star(* 0.10 ** 0.05 *** 0.01) 
esttab using "$TABLES/tab_B1.tex", replace keep(*.phase_i)  ///
scalars("Country_Fe" "Controls")  ///
mtitles("\$Share^{R}\$" "\$Share^{R}\$" "\$Share^{A}\$" "\$Share^{A}\$" "\$Share^{M}\$" "\$Share^{M}\$") ///
b(3) se(3)   label compress star(* 0.10 ** 0.05 *** 0.01) 
eststo clear


********************************************************************************
********************************************************************************
************************************GRAPHS**************************************
********************************************************************************
********************************************************************************

 
********************************************************************************
*******************************FIGURE 1.b***************************************
********************************************************************************
xtreg r i.time, fe 
margins i.time 
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Routine Emp. Share (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_1.pdf", as(pdf) replace


********************************************************************************
*********************************FIGURE 2***************************************
********************************************************************************
*Figure 2.a
xtreg a i.time, fe
margins i.time 
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Abstract Emp. Share (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232)  plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))
graph export "$FIGURES/figure_2a.pdf", as(pdf) replace

*Figure 2.b
xtreg m i.time, fe
margins i.time 
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Manual Emp. Share (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue))
graph export "$FIGURES/figure_2b.pdf", as(pdf) replace

********************************************************************************
*********************************FIGURE 8***************************************
********************************************************************************

xtreg u i.time, fe  
margins i.time 
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Unemployment rate (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_8.pdf", as(pdf) replace


********************************************************************************
********************************FIGURE 7a***************************************
********************************************************************************
xtset geo time
drop t 
bys geo : gen t = _n 
sort geo time
merge 1:1 id t using "$OUTPUT/emp_by_sector_final", force
drop _merge
sort id time
gen mancon_va_share = va_manuf 

*Figure 7.a
xtreg mancon_emp_share i.time , fe 
margins i.time 
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Manufacturing & Construction Emp. Share (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_7a.pdf", as(pdf) replace

********************************************************************************
********************************FIGURE 7b***************************************
********************************************************************************
xtreg mancon_va_share i.time , fe 
margins i.time 
marginsplot, recast(line) recastci(rarea) tline(2008q1 2008q2 2008q3 2008q4 2009q1 2009q2, ///
lwidth(2) lcolor(gs15) ) tline(2011q3 2011q4 2012q1 2012q2 2012q3 2012q4 2013q1, lwidth(2) lcolor(gs15) ) ///
ytitle("Manufacturing & Construction Value Added Share (%)") graphregion(fcolor(white)) title(" ") xtitle(" ") ///
title(" ")  xlabel(168 184 200 216 232) plotopts(lcolor(red) lwidth(thick)) ciopts(fcolor(ltblue) ///
fintensity(30%) lcolor(ltblue)) 
graph export "$FIGURES/figure_7b.pdf", as(pdf) replace

********************************************************************************
********************************************************************************
*****************************APPENDIX: TABLE B.3********************************
********************************************************************************
********************************************************************************

eststo clear
eststo: xtreg mancon_emp_share time , fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg mancon_emp_share time c.time#i.phase_i i.phase_i  , fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg mancon_va_share time , fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"
eststo: xtreg mancon_va_share time c.time#i.phase_i i.phase_i  , fe cluster(geo)
estadd local Country_Fe "Yes"
estadd local Controls "No"

esttab, nocon drop(*.phase_i _cons) b(3) se(3) scalars("Country FE" "Controls") ///
label compress star(* 0.10 ** 0.05 *** 0.01) addnotes("Errors clustered at Country level") 
esttab using "$TABLES/tab_B3.tex", replace drop(*.phase_i  _cons 0.phase_i#c.time) ///
scalars("Country_Fe" "Controls") substitute("\_" "_" "_" " " )  ///
mtitles("\$Share^{Manuf}\$" "\$Share^{Manuf}\$" "\$VA.Share^{Manuf}\$" "\$VA.Share^{Manuf}\$") ///
b(3) se(3) r2(3) label compress star(* 0.10 ** 0.05 *** 0.01) 
eststo clear


