clear
*define Directory
cd "$DATA"
*import Data
import excel "$DATA/dataset_october23.xlsx", sheet("DATASET") firstrow
********************************************************************************
************************DEFINE PANEL VARIABLES**********************************
********************************************************************************
*generate Country numeric identifier
encode Country, gen(geo)
drop Country
order geo Date 

*generate year-quarter variable 
sort geo Date 
by geo : gen time = _n+151
order geo time Date
format %tq time
xtset geo time

*generate year dummy
xtset geo time
tostring Date, gen(Date_str)
gen year = substr(Date_str,1,4) 
destring year, replace
*generate quarter 
bys geo year: gen quarter=_n
********************************************************************************
************************DEFINE EMU12 COUNTRIES**********************************
********************************************************************************

*generate dummy for first 12 EMU countries
gen emu12 = 1 if geo==1|geo==2|geo==6|geo==7|geo==8|geo==9|geo==10|geo==11| ///
geo==14|geo==16|geo==17|geo==20
replace emu12=0 if emu12==.

*Keep only the first EMU12 countries
keep if emu==1

preserve 
keep geo time u RealGDP year 
drop if geo==14
egen id = group(geo)
drop geo 
save "$OUTPUT/data_for_nairu.dta", replace 
restore

********************************************************************************
************************BUSINESS CYCLE DUMMIES**********************************
********************************************************************************

*adjust recession dummies in order to include peak
order geo time CEPRrecessions Countryrecession
replace  CEPRrecessions=1 if CEPRrecessions[_n]==0 & CEPRrecessions[_n+1]==1 /// 
& CEPRrecessions[_n-1]==0 
replace  Countryrecession=1 if Countryrecession[_n]==0 & Countryrecession[_n+1]==1 ///
& Countryrecession[_n-1]==0 
rename CEPRrecessions rec
rename Countryrecession rec_i

*generate dummy for each business cycle phase (expansion and downturns) in 
*cronological order according to the common CEPR business cycle dates, which
*define the GREAT RECESSION and the SOVEREIGN DEBT CRISIS as the only crises occurred 
*in the European Union/EMU
order geo time Date 
by geo : gen phase = 0 if Date<=2007.75
by geo : replace phase = 1 if rec==1 & Date<=2009.25
by geo : replace phase = 3 if rec==1 & Date>=2011.05
by geo : replace phase = 2 if phase ==. & Date<=2011.25
by geo : replace phase = 4 if phase ==. 
label define phase 0 "Before GR" 1 "GR" 2 "Between GR and SDC" 3 "SDC" 4 "After SDC"
label values phase phase

*generate categorical variable for each recession within each countries
order geo time Date rec_i 
by geo: gen start = Date if rec_i[_n]==1 & rec_i[_n-1]==0
by geo: replace start = start[_n-1] if start[_n-1]!=. & rec_i==1
egen id = group(geo)
gen rec_i_all = .
forvalues i=1/12{
egen x = group(start) if id==`i'
replace rec_i_all = x if id==`i'
drop x
}
replace rec_i_all=0 if rec_i_all==.
drop id 
rename start start_rec_i

*generate dummy for each business cycle phase (expansion and downturns) in 
*cronological order according to the common country-specific business cycle dates
*considering ONLY the GREAT RECESSION and the SOVEREIGN DEBT CRISIS
by geo: gen phase_i = 1 if Date >2006.75 & Date<=2010 & rec_i==1
by geo: replace phase_i = 3 if Date >2009.75 & Date<=2013 & rec_i==1
*Correction for Spain
replace phase_i = 3 if rec_i_all==2 & geo ==20
replace phase_i = 1 if rec_i_all==1 & geo ==20
*Correction for Greace
replace phase_i = 3 if rec_i_all==3 & geo ==9
replace phase_i=0 if  rec_i==0 & Date< 2008
replace phase_i=0 if phase_i==. & Date <2008.5
replace phase_i=4 if  phase_i==. & Date>2012.5 
*Correction for Luxembourg
replace phase_i = 2 if Date>=2009.25 & geo == 14 
*Correction for Ireland
replace phase_i = 4 if Date>=2012 & geo == 10
replace phase_i = 2 if phase_i==.
label define phase_i 0 "Before GR" 1 "GR" 2 "Between GR and SDC" 3 "SDC" 4 "After SDC"
label values phase_i phase_i
*create country-specific dummies for periods after the GR and the SDC
by geo: gen after_gr = 1 if phase_i>1
by geo: replace after_gr = 0 if after_gr==.
by geo: gen after_sdc = 1 if phase_i==4
by geo: replace after_sdc = 0 if after_sdc==.
order geo time Date rec rec_i rec_i_all phase phase_i 

********************************************************************************
*******************************UNEMPLOYMENT ************************************
********************************************************************************

xtset geo time
by geo: gen lu = l.u 
by geo: gen l2u = l2.u 
by geo: gen l3u = l3.u 
by geo: gen l4u = l4.u
by geo:gen l5u = l5.u
by geo:gen l6u = l6.u
by geo:gen l7u = l7.u
by geo:gen l8u = l8.u
by geo:gen l9u = l9.u
by geo:gen l10u = l10.u
by geo:gen l11u = l11.u
by geo:gen l12u = l12.u

bys geo: gen sum_u1 = u  + 0.99*F.u  + (0.99^2)*F2.u  + (0.99^3)*F3.u
bys geo: gen sum_u2 = u  + 0.99*F.u  + (0.99^2)*F2.u  + (0.99^3)*F3.u + (0.99^4)*F4.u + ///
(0.99^5)*F5.u + (0.99^6)*F6.u + (0.99^7)*F7.u 
bys geo: gen sum_u3 = u  + 0.99*F.u  + (0.99^2)*F2.u  + (0.99^3)*F3.u + (0.99^4)*F4.u + ///
(0.99^5)*F5.u + (0.99^6)*F6.u + (0.99^7)*F7.u + (0.99^8)*F8.u  + (0.99^9)*F9.u + (0.99^10)*F10.u + (0.99^11)*F11.u


********************************************************************************
*********************OCCUPATIONAL SHIFTS DURING DOWNTURNS***********************
********************************************************************************
********************************************************************************

*define the occupational shift for ALL RECESSIONS according to country-specific
*business cycle dates
sort geo rec_i_all time

*shift - narrow routine share
bys geo rec_i_all: gen shift_n = 100*(RoutineNarrow[1]-RoutineNarrow[_N])/RoutineNarrow[1]
replace shift_n =0 if rec_i_all==0
*shift - narrow routine share
bys geo rec_i_all: gen shift_b = 100*(RoutineBroad[1]-RoutineBroad[_N])/RoutineBroad[1]
replace shift_b =0 if rec_i_all==0
sort geo time

*define the occupational shift for GR and SDC ONLY oaccording to country-specific
*business cycle dates
sort geo phase_i time

*shift - narrow routine share
bys geo phase_i: gen shift_gr_n = 100*(RoutineNarrow[1]-RoutineNarrow[_N])/RoutineNarrow[1] ///
if phase_i==1
replace shift_gr_n=0 if shift_gr_n==.

bys geo phase_i: gen shift_sdc_n = 100*(RoutineNarrow[1]-RoutineNarrow[_N])/RoutineNarrow[1] ///
if phase_i==3
replace shift_sdc_n=0 if shift_sdc_n==.

*shift - broad routine share
bys geo phase_i: gen shift_gr_b = 100*(RoutineBroad[1]-RoutineBroad[_N])/RoutineBroad[1] ///
if phase_i==1
replace shift_gr_b=0 if shift_gr_b==.

bys geo phase_i: gen shift_sdc_b = 100*(RoutineBroad[1]-RoutineBroad[_N])/RoutineBroad[1] ///
if phase_i==3
replace shift_sdc_b=0 if shift_sdc_b==.

sort geo time
foreach k in shift_gr_n shift_sdc_n shift_gr_b shift_sdc_b {
by geo: egen `k'_ = max(`k')
by geo: egen `k'__ = min(`k')
drop `k'
rename `k'_ `k'
replace  `k' = `k'__ if `k'==0
drop `k'__
}

*create interaction respectively with post_gr and post_sdc periods (this will be
*needed in the empirical analysis)
by geo: replace shift_gr_n = shift_gr_n*after_gr
by geo: replace shift_gr_b = shift_gr_b*after_gr
by geo: replace shift_sdc_n = shift_sdc_n*after_sdc
by geo: replace shift_sdc_b = shift_sdc_b*after_sdc

********************************************************************************
************************LENGTH OF EACH RECESSION EPISODE************************
********************************************************************************
sort geo rec_i_all time
bys geo rec_i_all : gen duration = _N
replace duration=. if rec_i_all==0
sort geo time 

********************************************************************************
************Fall in GDP at the beginning of the local crisis********************
********************************************************************************
sort geo time
by geo : gen dgdp = (RealGDP[_n]-RealGDP[_n-1])/RealGDP[_n-1]
sort geo rec_i_all time
bys geo rec_i_all: gen shock = dgdp if _n==2
replace shock = 0 if rec_i_all==0
bys geo rec_i_all: gen shock_T = (RealGDP[_N]-RealGDP[1])/RealGDP[1] 
replace shock_T = 0 if rec_i_all==0

sort geo rec_i_all time 
by geo rec_i_all: egen shock_ = min(shock)
by geo rec_i_all: egen shock_T_ = min(shock_T)
drop shock shock_T
rename shock_ shock
rename shock_T_ shock_T
replace shock = 100*shock
replace shock_T = 100*shock_T
replace shock = -shock
replace shock_T = -shock_T

********************************************************************************
***************************GDP GROWTH VOLATILITY********************************
********************************************************************************
sort geo time

*Volatility over entire sample
egen id = group(geo)
gen std_dgdp = .
forvalues i=1/12{
egen x = sd(dgdp) if id==`i'
replace std_dgdp = x if id==`i'
drop x
}
replace std_dgdp = 100*std_dgdp

*volatility in non-recession periods 
gen std_dgdp2 = .
forvalues i=1/12{
egen x = sd(dgdp) if id==`i' & rec_i==0
replace std_dgdp2 = x if id==`i' & rec_i==0
drop x
}
drop id
by geo: egen std_dgdp2_ = max(std_dgdp2)
drop std_dgdp2
rename std_dgdp2_ std_dgdp2
replace std_dgdp2 = 100*std_dgdp2

********************************************************************************
****************************SHOCK NORMALIZED************************************
********************************************************************************
sort geo time
by geo: gen normshock = shock/std_dgdp
by geo: gen normshock_T = shock_T/std_dgdp

by geo: gen normshock2 = shock/std_dgdp2
by geo: gen normshock_T2 = shock_T/std_dgdp2

********************************************************************************
*******************************OUTOPUT GAP**************************************
********************************************************************************
sort geo time
gen log_gdp = log(RealGDP)
gen y_gap = .
gen y_trend = .
egen id = group(geo)
forvalues i=1/12{

tsfilter hp y_cyc = log_gdp if id==`i', smooth(1600) trend(gdp_trend)
replace y_gap=y_cyc if id==`i'
replace y_trend=gdp_trend if id==`i'
drop y_cyc gdp_trend
}
replace y_gap = (log_gdp/y_trend-1)*100

drop id log_gdp
xtset geo time
bys geo: gen ly_gap = l.y_gap
bys geo: gen l2y_gap = l2.y_gap
bys geo: gen l3y_gap = l3.y_gap
bys geo: gen l4y_gap = l4.y_gap
bys geo: gen l5y_gap = l5.y_gap
bys geo: gen l6y_gap = l6.y_gap
bys geo: gen l7y_gap = l7.y_gap
bys geo: gen l8y_gap = l8.y_gap

********************************************************************************
*****************************PRE-RECESSION TREND********************************
********************************************************************************
egen id = group(geo)
by geo: gen t = _n
gen coef_before_gr=.
forvalues i = 1/12{
reg RoutineNarrow t if id==`i' & phase_i==0, 
replace coef_before_gr = _b[t] if id==`i'
}

gen coef_before_sdc=.
forvalues i = 1/12{
reg RoutineNarrow t if id==`i'  , 
replace coef_before_sdc = _b[t] if id==`i'
}

drop id 
sort geo time
xtset geo time

********************************************************************************
*****************************DROP LUXEMBOURG************************************
********************************************************************************

*Data on Lux are partially unreliable
drop if geo==14

********************************************************************************
*********ONE SINGLE CATEGORICAL VAR. FOR EACH POST-RECESSION PERIODS************
********************************************************************************

sort geo time
*create one single categorical variable taking value 1, 2, 3 after each recession
by geo : egen d = max(Date) if rec_i_all==1
bys geo : egen d_ = max(d)
drop d
order d_
by geo : gen cycle  = 0 if Date<=d_
order cycle
replace cycle=1 if cycle==. & d_!=.
drop d_
sort geo time

by geo : egen d = max(Date) if rec_i_all==2
bys geo : egen d_ = max(d)
drop d
order d_
replace cycle=2 if cycle==1 & Date>d_
sort geo time
drop d_
sort geo time

by geo : egen d = max(Date) if rec_i_all==3
bys geo : egen d_ = max(d)
drop d
order d_
replace cycle=3 if cycle==2 & Date>d_
sort geo time
drop d_
sort geo time

by geo : egen d = max(Date) if rec_i_all==4
bys geo : egen d_ = max(d)
drop d
order d_
replace cycle=4 if cycle==3 & Date>d_
sort geo time
drop d_
sort geo time

by geo : egen d = max(Date) if rec_i_all==5
bys geo : egen d_ = max(d)
drop d
order d_
replace cycle=5 if cycle==4 & Date>d_
sort geo time
drop d_
sort geo time

*adjust for AU 
replace cycle = 2 if after_gr==1 & geo==1 
replace cycle = 3 if after_sdc==1 & geo==1 
*adjust for BE
replace cycle = 2 if after_gr==1 & geo==2
replace cycle = 3 if after_sdc==1 & geo==2

rename cycle CYCLE

********************************************************************************
***********ONE SINGLE VAR. CONTAINING ALL SHIFT FROM ALL RECESSION**************
********************************************************************************
by geo: egen s_n= max(shift_n) if rec_i_all==1
by geo: egen s_n_= min(shift_n) if rec_i_all==1
replace  s_n= s_n_ if s_n==0
drop s_n_
by geo :egen s_n1 =max(s_n)
by geo :egen s_n1_ =min(s_n)
replace s_n1=s_n1_ if s_n1==0
drop s_n1_ s_n


by geo: egen s_n= max(shift_n) if rec_i_all==2
by geo: egen s_n_= min(shift_n) if rec_i_all==2
replace  s_n= s_n_ if s_n==0
drop s_n_
by geo :egen s_n2 =max(s_n)
by geo :egen s_n2_ =min(s_n)
replace s_n1=s_n2_ if s_n2==0
drop s_n2_ s_n

by geo: egen s_n= max(shift_n) if rec_i_all==3
by geo: egen s_n_= min(shift_n) if rec_i_all==3
replace  s_n= s_n_ if s_n==0
drop s_n_
by geo :egen s_n3 =max(s_n)
by geo :egen s_n3_ =min(s_n)
replace s_n1=s_n3_ if s_n3==0
drop s_n3_ s_n

by geo: egen s_n= max(shift_n) if rec_i_all==4
by geo: egen s_n_= min(shift_n) if rec_i_all==4
replace  s_n= s_n_ if s_n==0
drop s_n_
by geo :egen s_n4 =max(s_n)
by geo :egen s_n4_ =min(s_n)
replace s_n1=s_n4_ if s_n3==0
drop s_n4_ s_n

by geo: egen s_n= max(shift_n) if rec_i_all==5
by geo: egen s_n_= min(shift_n) if rec_i_all==5
replace  s_n= s_n_ if s_n==0
drop s_n_
by geo :egen s_n5 =max(s_n)
by geo :egen s_n5_ =min(s_n)
replace s_n1=s_n5_ if s_n5==0
drop s_n5_ s_n

by geo : gen SHIFT = 0 if CYCLE==0
by geo : replace SHIFT = s_n1 if CYCLE==1
by geo : replace SHIFT = s_n2 if CYCLE==2
by geo : replace SHIFT = s_n3 if CYCLE==3
by geo : replace SHIFT = s_n4 if CYCLE==4
by geo : replace SHIFT = s_n5 if CYCLE==5

order geo time 

********************************************************************************
********************GENERATE INFLATION and PRICE DATA***************************
********************************************************************************
preserve 
do "$PROGRAMS_STATA/1.2_cleaning_expected_inflation.do"
do "$PROGRAMS_STATA/1.3_cleaning_non_tradable_inflation.do"
do "$PROGRAMS_STATA/1.4_cleaning_cpi_inflation.do"
do "$PROGRAMS_STATA/1.8_cleaning_import_index.do"
restore

********************************************************************************
**************************MERGE WITH DATA ON INFLATION**************************
********************************************************************************
egen id = group(geo)
xtset id time
merge 1:1 id time using "$OUTPUT/expected_inflation_november22"
 drop _merge
merge 1:1 id time using "$OUTPUT/inflation_nontradable.dta"
drop _merge
merge 1:1 id time using "$OUTPUT/price_nontradable.dta"
drop _merge
xtset id time

*Price-levels for non tradable
replace p_nt = p_nt*100
bys id: gen sum_p_nt1 = p_nt + 0.99*F.p_nt + (0.99^2)*F2.p_nt + (0.99^3)*F3.p_nt 
bys id: gen sum_p_nt2 = p_nt + 0.99*F.p_nt + (0.99^2)*F2.p_nt + (0.99^3)*F3.p_nt + (0.99^4)*F4.p_nt + ///
(0.99^5)*F5.p_nt + (0.99^6)*F6.p_nt + (0.99^7)*F7.p_nt 
bys id: gen sum_p_nt3 = p_nt + 0.99*F.p_nt + (0.99^2)*F2.p_nt + (0.99^3)*F3.p_nt + (0.99^4)*F4.p_nt + ///
(0.99^5)*F5.p_nt + (0.99^6)*F6.p_nt + (0.99^7)*F7.p_nt + (0.99^8)*F8.p_nt + (0.99^9)*F9.p_nt ///
+ (0.99^10)*F10.p_nt + (0.99^11)*F11.p_nt

bys id: gen l1yr_ma_p_nt = 0.25*(L4.p_nt  + L5.p_nt  + L6.p_nt  + L7.p_nt )
bys id: gen ll1yr_ma_p_nt = l.l1yr_ma_p_nt
bys id: gen l2l1yr_ma_p_nt = l.l1yr_ma_p_nt

bys id: gen lp_nt = L.p_nt
bys id: gen l2p_nt = L2.p_nt
bys id: gen l3p_nt = L3.p_nt
bys id: gen l4p_nt = L4.p_nt   
bys id: gen l5p_nt = L5.p_nt 
bys id: gen l6p_nt = L6.p_nt 
bys id: gen l7p_nt = L7.p_nt 

merge m:1 time using "$OUTPUT/px_november23.dta"
keep if _merge==3
drop _merge
********************************************************************************
***********************CYCLE BY COUNTRY - STACKED VERSION***********************
********************************************************************************
gen CYCLE_ = 101 if phase_i==2|phase_i==3|phase_i==4
replace CYCLE_ = 102 if phase_i==4

replace CYCLE_ = 0 if CYCLE==1 & geo==8
replace CYCLE_ = -2 if CYCLE==2 & geo==8
replace CYCLE_ = -1 if CYCLE==3 & geo==8

replace CYCLE_ = +1 if CYCLE==4 & geo==6
replace CYCLE_ = +2 if CYCLE==5 & geo==6

replace CYCLE_ = -1 if CYCLE==1 & geo==9

replace CYCLE_ = -2 if CYCLE==1 & geo==11
replace CYCLE_ = -1 if CYCLE==2 & geo==11
replace CYCLE_ = +1 if CYCLE==5 & geo==11

replace CYCLE_ = -1 if CYCLE==1 & geo==17

replace CYCLE_ =0 if CYCLE_==.
drop CYCLE
rename CYCLE_ CYCLE

replace CYCLE = 103 if CYCLE == 1
replace CYCLE = 104 if CYCLE == 2
replace CYCLE = 100 if CYCLE == -1
replace CYCLE = 99 if CYCLE == -2
label define CYCLE 99 "-2" 100 "-1" 101 "Post-GR" 102 "Post-SDC" 103 "+1" 104 "+2"
label values CYCLE CYCLE

replace CYCLE = 103 if geo==6 & CYCLE ==104

drop if geo==.
sort geo time
drop id
xtset geo time

********************************************************************************
************Clean Monetary Policy Shocks from Altvilla et al. 2019**************
********************************************************************************
preserve 
do "$PROGRAMS_STATA/1.5_cleaning_mp_shocks_altavilla.do"
restore

********************************************************************************
*************************Clean Valeu Added by Sector****************************
********************************************************************************
preserve 
do "$PROGRAMS_STATA/1.6_cleaning_value_added.do"
restore

********************************************************************************
****************************Clean Sector/Emp Data*******************************
********************************************************************************
preserve 
do "$PROGRAMS_STATA/1.9_cleaning_sectoral_emp_data.do"
restore
********************************************************************************
*****************************Clean DATASTREAM***********************************
********************************************************************************
preserve 
do "$PROGRAMS_STATA/1.7_cleaning_datastream.do"
restore

********************************************************************************
**********************************OTHER DATA************************************
********************************************************************************
xtset geo time

* merge data on VAT
egen id = group(geo)
drop t 
bys id: gen t = _n 
save "$OUTPUT/data_for_otherstuff.dta", replace 

merge 1:1 id time using "$OUTPUT/valueadded"
keep if _merge==3
drop _merge

merge 1:1 id time using "$OUTPUT/cpi_nov22_redux_final" 
keep if _merge==3
drop _merge

*mp shocks from altavilla et al 
merge m:1 time using "$OUTPUT/mp_shock_altavilla"
drop if _merge==2
drop _merge
xtset id time
// drop year quarter
foreach k in mp_shock lmp_shock l2mp_shock l3mp_shock l4mp_shock l5mp_shock l6mp_shock ///
l7mp_shock l8mp_shock {
replace `k' = 0 if `k'==.
}
**************************
sort geo time
xtset geo time

*ROLE of sectorial composition in explaining the structurak break
*there is a statistical break for ireland Ireland. We smooth it out in level
bys id: replace va_manuf = va_manuf - 18 if id==7 & _n>68
replace va_manuf  = va_manuf  + va_con
bys id phase_i : gen Dva_manuf_gr_ = 100*(va_manuf[1] - va_manuf[_N])/va_manuf[1] if phase_i==1
bys id: egen Dva_manuf_gr  = max(Dva_manuf_gr_) 
replace Dva_manuf_gr  = after_gr if after_gr==0
drop Dva_manuf_gr_
bys id phase_i : gen Dva_manuf_sdc_ = 100*(va_manuf[1] - va_manuf[_N])/va_manuf[1] if phase_i==3
bys id: egen Dva_manuf_sdc  = max(Dva_manuf_sdc_) 
replace Dva_manuf_sdc  = after_sdc if after_sdc==0
drop Dva_manuf_sdc_
 
xtset geo time

********************************************************************************
*********************************NAIRU from OECD********************************
********************************************************************************
preserve
do "$PROGRAMS_STATA/1.1_cleaning_nairu.do"
restore
 
merge 1:1 id time using "$OUTPUT/nairu_oecd_may2023"
keep if _m==3
drop _merge
xtset id time
		
merge 1:1 id time using "$OUTPUT/datastream_feb23"
keep if _m==3
xtset id time
drop _merge
	
drop if year>2018
drop if year<2002

replace Import_Prices = 100+ xp if id ==10
bys time: egen mean_FuelsDomesticPrice = mean(FuelsDomesticPrice) 
xtset id time 
replace FuelsDomesticPrice = mean_FuelsDomesticPrice if id ==10

*CPI INFLATION
gen c = 0 if phase_i<2
replace c=1 if phase_i==2|phase_i==3
replace c = 2 if c==.

*Monetary Policy Shocks
bys id: gen mp_shockX = mp_shock[1]+ 100 if _n==1
bys id: replace mp_shockX = mp_shockX[_n-1] + mp_shock if _n>1
drop mp_shock
rename mp_shockX mp_shock
order mp_shock lmp_shock l2mp_shock l3mp_shock l4mp_shock l5mp_shock l6mp_shock l7mp_shock l8mp_shock

bys id : replace lmp_shock = l.mp_shock if _n>1
bys id : replace lmp_shock = lmp_shock+f.lmp_shock if _n==1
bys id : replace l2mp_shock = l.lmp_shock if _n>1
bys id : replace l2mp_shock = l2mp_shock + f.l2mp_shock if _n==1
bys id : replace l3mp_shock = l.l2mp_shock if _n>1
bys id : replace l3mp_shock = l3mp_shock + f.l3mp_shock if _n==1
bys id : replace l4mp_shock = l.l3mp_shock if _n>1
bys id : replace l4mp_shock = l4mp_shock + f.l4mp_shock if _n==1
bys id : replace l5mp_shock = l.l4mp_shock if _n>1
bys id : replace l5mp_shock = l5mp_shock + f.l5mp_shock if _n==1
bys id : replace l6mp_shock = l.l5mp_shock if _n>1
bys id : replace l6mp_shock = l6mp_shock + f.l6mp_shock if _n==1
bys id : replace l7mp_shock = l.l6mp_shock if _n>1
bys id : replace l7mp_shock = l7mp_shock + f.l7mp_shock if _n==1
bys id : replace l8mp_shock = l.l7mp_shock if _n>1
bys id : replace l8mp_shock = l8mp_shock + f.l8mp_shock if _n==1

replace mp_shock_long = 0 if mp_shock_long==.
bys id: gen mp_shock_longX = mp_shock_long[1]+ 100 if _n==1
bys id: replace mp_shock_longX = mp_shock_longX[_n-1] + mp_shock_long if _n>1
drop mp_shock_long
rename mp_shock_longX mp_shock_long

bys id : replace lmp_shock_long = l.mp_shock_long if _n>1
bys id : replace lmp_shock_long = lmp_shock_long+f.lmp_shock_long if _n==1
bys id : replace l2mp_shock_long = l.lmp_shock_long if _n>1
bys id : replace l2mp_shock_long = l2mp_shock_long + f.l2mp_shock_long if _n==1
bys id : replace l3mp_shock_long = l.l2mp_shock_long if _n>1
bys id : replace l3mp_shock_long = l3mp_shock_long + f.l3mp_shock_long if _n==1
bys id : replace l4mp_shock_long = l.l3mp_shock_long if _n>1
bys id : replace l4mp_shock_long = l4mp_shock_long + f.l4mp_shock_long if _n==1
bys id : replace l5mp_shock_long = l.l4mp_shock_long if _n>1
bys id : replace l5mp_shock_long = l5mp_shock_long + f.l5mp_shock_long if _n==1
bys id : replace l6mp_shock_long = l.l5mp_shock_long if _n>1
bys id : replace l6mp_shock_long = l6mp_shock_long + f.l6mp_shock_long if _n==1
bys id : replace l7mp_shock_long = l.l6mp_shock_long if _n>1
bys id : replace l7mp_shock_long = l7mp_shock_long + f.l7mp_shock_long if _n==1
bys id : replace l8mp_shock_long = l.l7mp_shock_long if _n>1
bys id : replace l8mp_shock_long = l8mp_shock_long + f.l8mp_shock_long if _n==1

********************************************************************************
**********************************SAVE DATA*************************************
********************************************************************************
save "$OUTPUT/modified_data_october23.dta", replace
********************************************************************************
*************************LABOR COST DATA****************************************
********************************************************************************
do "$PROGRAMS_STATA/1.10_cleaning_wages.do"
********************************************************************************
*********************************EPL DATA***************************************
********************************************************************************
do "$PROGRAMS_STATA/1.11_cleaning_EPL_Duval_et_al.do"
********************************************************************************
**************************AGGREGATE & SEPARATION RATES**************************
********************************************************************************
do "$PROGRAMS_STATA/1.14_cleaning_aggregate_separation_hiring.do"
do "$PROGRAMS_STATA/1.15_cleaning_conditional_separation_hiring.do"
********************************************************************************
*****************************OTHER VARIABLES************************************
********************************************************************************
do "$PROGRAMS_STATA/1.12_cleaning_variables_for_robustness_check.do"
do "$PROGRAMS_STATA/1.13_cleaning_tech_change.do"
do "$PROGRAMS_STATA/1.16_cleaning_multiple_contracts.do"
********************************************************************************
cd "$HOME"

 
