use "$OUTPUT/hiring_separation_rates_2022.dta", clear 
keep id time DELTA
bys id : keep if _n==5|_n==_N 
bys id: gen Ddelta = (DELTA[2]/DELTA[1] - 1 ) 
bys id : keep if _n==1
*for France 
replace Ddelta =  0.2077914 if Ddelta ==.
keep id Ddelta 
save  "$OUTPUT/long_term_change_delta.dta" , replace 

********************************************************************************
********************************************************************************
use "$OUTPUT/tech_change_investment", clear 
drop if inv_into_tech_change==.
bys id : gen Dict = (inv_into_tech_change[_N]/inv_into_tech_change[1]) - 1 
bys id: keep if _n==1
keep id Dict 
save "$OUTPUT/long_term_change_tech.dta", replace

********************************************************************************
********************************************************************************
use "$OUTPUT/modified_data_october23.dta", clear 
xtset id time
merge m:1 id using "$OUTPUT/long_term_change_delta.dta"
drop _merge
merge m:1 id using  "$OUTPUT/long_term_change_tech.dta"
drop _merge

bys id : gen After_sdc_Ddelta = after_gr*Ddelta*100
bys id : gen After_sdc_Dict = after_gr*Dict*100

keep if phase_i==0|phase_i==4
eststo clear 
eststo: reg dprc_x_nrg_food i.after_sdc ///
After_sdc_Ddelta After_sdc_Dict 
esttab using "$TABLES/regression_page35.tex" , replace 
eststo clear 

   
