use "$OUTPUT/modified_data_october23.dta", clear 
xtset geo time
drop t
by geo:gen t = _n 

*DEFINE UNEMPLOYMENT GAP
bys id : egen mean_nairu_oecd = mean(nairu_oecd)
bys id : replace u =   (u/nairu_oecd-1 )*100
bys id :  replace lu = (lu/lnairu_oecd-1)*100
bys id :  replace l2u = (l2u/l2nairu_oecd-1)*100
bys id :  replace l2u = (l3u/l3nairu_oecd-1)*100
bys id :  replace l4u = (l4u/l4nairu_oecd-1)*100
xtset id time
bys id : gen u_sw  = 0.25*(u + lu + l2u + l3u)
bys id : gen ygap_sw  = 0.25*(y_gap + ly_gap + l2y_gap + l3y_gap) 

xtset id time


********************************************************************************
**********************PILLIPS CURVE - 8YEARS ROLLING WINDOW*********************
***********************     CROSS-COUNTRY ESTIMATION    ************************
********************************************************************************

xtset id time
bys id : gen ma_inf_1yr = (ldprc + l2dprc + l3dprc +l4dprc)*0.25
bys id : gen ma_inf_2yr = (l4dprc + l5dprc + l6dprc +l7dprc)*0.25
bys  id : gen dprc_sw =  (dprc_x_nrg_food + ldprc_x_nrg_food + l2dprc_x_nrg_food + l3dprc_x_nrg_food)*0.25  ///
- (l4dprc_x_nrg_food + l5dprc_x_nrg_food + l6dprc_x_nrg_food +l7dprc_x_nrg_food)*0.25 
forvalues k=0/65{
  xtreg dprc_sw  i.id#c.u_sw        if t>=1+`k' & t<=32+`k'   ,    fe     
  regsave using results_`k', ci replace
}

forvalues k=0/65{
use results_`k', clear 
drop if var=="_cons"
gen id = _n
gen t=`k'+1
keep id t coef ci_lower ci_upper 
save results_`k', replace
}

use results_0, clear 
forvalues k=1/65{
append using results_`k'

}

xtset id t
bys id:  gen time = _n+167
format %tq time
drop t
order id time
xtset id time
// save "$OUTPUT/BETA_agg.dta", replace

forvalues k=0/65{
erase results_`k'.dta

}
// use BETA_agg.dta, clear 

rename coef beta_rw

merge 1:1 id time using "$OUTPUT/modified_data_october23.dta", 
keep if _merge==3 
drop _merge

preserve
use "$OUTPUT/EPL.dta", clear 
drop id
keep if country=="Austria"|country=="Belgium"|country=="Finland"|country=="France"| ///
country=="Germany"|country=="Greece"|country=="Ireland"|country=="Italy"| ///
country=="Netherlands"| country=="Portugal"|country=="Spain"
sort country 
egen id = group(country)
xtset id year
bys id: gen lepl_lib = l.epl_lib
bys id: gen l2epl_lib = l2.epl_lib
bys id: gen l3epl_lib = l3.epl_lib
bys id: gen l4epl_lib = l4.epl_lib

rename country geo_label
save "$OUTPUT/EPL_final.dta", replace
restore

merge m:1 id year using "$OUTPUT/EPL_final.dta"
  keep if _merge ==3
xtset id time 

********************************************************************************
********************************************************************************
********************************************************************************
keep id geo time year RoutineNarrow beta_rw phase_i EPL EPLtemp *epl_lib epl_tig ///
after_gr after_sdc geo_label u nairu_oecd
xtset id time
rename beta_rw beta  
gen routine_share =  (RoutineNarrow)*100
bys id : gen db = (f.beta - beta)*100  
********************************************************************************
********************************************************************************
********************************************************************************

eststo clear 
*Table C7
eststo clear 
drop if year>2014
eststo: ivreg2 routine_share i.lepl_lib c.time##i.phase_i i.id,  r 
estadd local Country_Fe "Yes"
estadd local Estimator "Ols" 
eststo: ivreg2 db  routine_share i.id,  r   
estadd local Country_Fe "Yes"
estadd local Estimator "Ols" 
eststo:ivreg2 db (routine_share=i.lepl_lib c.time##i.phase_i ) i.id, ///
first ffirst r
estadd local Country_Fe "Yes"
estadd local Estimator "Tsls" 
esttab using "$TABLES/tab_C7.tex",  drop(*.id* *.phase_i* *time* 0.lepl_lib _cons)b(4) se(4)  scalars("Country_Fe" "Estimator") ///
coeflabel(lepl_lib "\$I(EPL)\$" routine_share "\$Share^{R}\$" 1.lepl_lib "\$I(EPL)\$") mtitles( "\$Share^{R}\$" "\$\Delta\kappa\$" "\$\Delta\kappa\$")  ///
 label compress star(* 0.10 ** 0.05 *** 0.01) substitute("\_" "_" "_" " ") replace  
  
 
