use "$OUTPUT/national_account_data.dta", clear 
merge 1:1 id time using "$OUTPUT/modified_data_october23.dta"
keep if _merge ==3
drop _merge 

rename coef_before_gr coef_pol_before_gr 
rename coef_before_sdc coef_pol_before_sdc
merge m:1 id   using "$OUTPUT/betas_feb2023.dta" 
keep if _merge ==3
drop _merge 
merge 1:1 id time using "$OUTPUT/emp_by_sector_final", force
keep if _merge ==3
drop _merge 
merge 1:1 id time using  "$OUTPUT/hiring_separation_rates_2022", force
keep if _merge==3
drop _merge


order geo id time phase_i
xtset id time
gen st_liquidity_risk =   ( (fincorp_asset_F2)/(fincorp_liab_F2) ) 
replace H =. if id ==7
replace  RoutineNarrow =  RoutineNarrow*100
order geo time phase_i RealGDP shock_T
bys id phase_i: gen shock_cum = 100*(RealGDP[1]-RealGDP)/RealGDP[1]


preserve 
keep if phase_i==0|phase_i==2
bys id phase_i: egen mean_H = mean(H)
bys id phase_i: egen mean_DELTA = mean(DELTA)
bys id phase_i: egen mean_u = mean(u)
bys id phase_i: egen mean_va_manuf = mean(va_manuf)
xtset id time
bys id: gen growth_r_ = 100*(RoutineNarrow/l.RoutineNarrow-1)
bys id : egen growth_r =mean(growth_r_)  if phase_i ==0
gen growth_r_x = - growth_r if growth_r> 0 
replace  growth_r_x =  growth_r if   growth_r<0
bys id : egen growth_r_fin = min(growth_r_x)
replace growth_r_fin= -growth_r_fin if growth_r> 0 
bys id phase_i: keep if _n==_N
keep id RoutineNarrow mancon_emp_share growth_r_fin  DELTA H   u ///
P coef_before_gr gov_debt_ratio st_liquidity_risk duration
bys id : gen phase_i = 1 if _n==1
bys id : replace phase_i = 3 if _n==2
save "$OUTPUT/pre_recession_characteristics.dta", replace 
restore





preserve 
keep if phase_i==1
keep id DELTA H
bys id : keep if _n ==1
save "$OUTPUT/DELTA_H_before_crisis", replace
restore

keep if phase_i==1|phase_i==3
order id time geo phase_i shock_cum
keep id time geo phase_i shock_cum  
merge m:1 id phase_i using "$OUTPUT/pre_recession_characteristics.dta"
drop _merge
replace st_liquidity_risk = st_liquidity_risk*100
drop duration DELTA H
merge m:1 id using "$OUTPUT/DELTA_H_before_crisis"
drop _merge
bys id  phase_i :  gen duration = _N
egen mean_d = mean(duration)

  
eststo clear 
foreach k in  RoutineNarrow mancon_emp_share growth_r_fin  DELTA   u ///
P coef_before_gr gov_debt_ratio st_liquidity_risk   {
gen x =  `k' 
eststo : reg shock_cum x
drop x

}

 
bys id phase_i : keep if _n==_N
bys id :replace DELTA = DELTA[1] if _n==2

esttab using "$TABLES/tab_B2.tex",  nocon noobs   b(2) se(2)   ///
label compress star(* 0.10 ** 0.05 *** 0.01)   ///
mtitles( "Routine Emp. Share" "Manuf. Emp. Share" "Routine Share long-term growth" ///
"Separation Rate" "Unemployment"  "HCPI Price Level"  "Slope of the PC"   ///
"Gov.Debt-to-GDP"  "Financial Firms Solvency") coeflabel(x "$\Delta Gdp_{t,Peak}$" )    ///
substitute("\_" "_") nonotes  replace

eststo clear 
foreach k in RoutineNarrow  mancon_emp_share growth_r_fin DELTA u ///
P coef_before_gr gov_debt_ratio st_liquidity_risk{
gen y =  `k' 
eststo : reg duration y

drop y
}

esttab using "$TABLES/tab_B2.tex", nocon noobs   b(2) se(2)   ///
label compress star(* 0.10 ** 0.05 *** 0.01)  ///
mtitles( "Routine Emp. Share" "Manuf. Emp. Share" "Routine Share long-term growth" ///
"Separation Rate" "Unemployment"  "HCPI Price Level"  "Slope of the PC"   ///
"Gov.Debt-to-GDP"  "Financial Firms Solvency") coeflabel(y "Duration")  ///
substitute("\_" "_")  append
eststo clear 
********************************************************************************
erase "$OUTPUT/pre_recession_characteristics.dta"
erase  "$OUTPUT/DELTA_H_before_crisis.dta"

