use "$OUTPUT/modified_data_october23.dta", clear 
bys geo phase_i: keep if _n==1|_n==_N
order geo phase_i time
keep if phase_i==1|phase_i==3
keep geo phase_i time

preserve 
keep  if phase_i == 1
gen obs = _n
save dates_gr, replace 
restore
preserve 
keep  if phase_i ==3
gen obs = _n
save dates_sdc, replace 
restore

use dates_gr, clear 
rename time Great_Recession
merge 1:1 geo obs using dates_sdc
drop _merge 
drop obs phase_i
rename time Sovereign_Debt_Crisis
erase dates_gr.dta
erase dates_sdc.dta 
eststo clear 
egen id = group(geo)
gen COUNTRY  = "Austria" if id ==1
replace COUNTRY  = "Belgium" if id ==2
replace COUNTRY  = "Finland" if id ==3
replace COUNTRY  = "France" if id ==4
replace COUNTRY  = "Germany" if id ==5
replace COUNTRY  = "Greece" if id ==6
replace COUNTRY  = "Ireland" if id ==7
replace COUNTRY  = "Italy" if id ==8
replace COUNTRY  = "Netherlands" if id ==9
replace COUNTRY  = "Portugal" if id ==10
replace COUNTRY  = "Spain" if id ==11
bys id : gen peak_trough= "peak" if _n ==1
bys id : replace peak_trough= "trough" if _n ==2
drop id
 
order COUNTRY peak_trough Great_Recession Sovereign_Debt_Crisis
texsave * using "$TABLES/tab_A1.tex", replace
 
