********************************************************************************
clear
import excel "$DATA/LFSQ_EGANA.xlsx", sheet("Sheet 1") cellrange(A11:W55) firstrow

rename GEOLabels TIME
gen time = _n+38*4-1
format %tq time
order time 
drop TIME
rename Germanyuntil1990formerterri Germany



foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' tot_emp
save tot_emp_`var', replace
restore

}

foreach var in C E G I K M O Q S U W{
preserve
keep time `var'
gen stat_break  = `var'
drop `var'

save stat_break_`var', replace
restore

}

use tot_emp_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using tot_emp_`var'
}

save tot_empNACE9808.dta, replace

use stat_break_C, clear
foreach var in  E G I K M O Q S U W{
append using stat_break_`var'
}

save break_9808.dta, replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase tot_emp_`var'.dta
}

foreach var in C E G I K M O Q S U W{
erase stat_break_`var'.dta
}

use tot_empNACE9808.dta
gen obs = _n
save tot_empNACE9808.dta, replace 

use break_9808.dta
gen obs = _n
save break_9808.dta, replace 

use tot_empNACE9808.dta
merge 1:1 obs using break_9808.dta
drop _merge 
drop obs

save tot_empNACE9808.dta, replace 

********************************************************************************
clear
import excel "$DATA/LFSQ_EGANA.xlsx", sheet("Sheet 2") cellrange(A11:W55) firstrow

rename GEOLabels TIME
gen time = _n+38*4-1
format %tq time
order time 
drop TIME
rename Germanyuntil1990formerterri Germany

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' tot_emp_manuf
save tot_emp_manuf_`var', replace
restore

}

foreach var in C E G I K M O Q S U W{
preserve
keep time `var'
gen stat_break_manuf  = `var'
drop `var'

save stat_break_`var', replace
restore
}

use tot_emp_manuf_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using tot_emp_manuf_`var'
}

save tot_emp_manufNACE9808.dta, replace

use stat_break_C, clear
foreach var in  E G I K M O Q S U W{
append using stat_break_`var'
}

save break_manuf_9808.dta, replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase tot_emp_manuf_`var'.dta
}

foreach var in C E G I K M O Q S U W{
erase stat_break_`var'.dta
}

use tot_emp_manufNACE9808.dta
gen obs = _n
save tot_emp_manufNACE9808.dta, replace 

use break_manuf_9808.dta
gen obs = _n
save break_manuf_9808.dta, replace 

use tot_emp_manufNACE9808.dta
merge 1:1 obs using break_manuf_9808.dta
drop _merge 
drop obs

save tot_emp_manufNACE9808.dta, replace 
********************************************************************************
clear
import excel "$DATA/LFSQ_EGANA.xlsx", sheet("Sheet 3") cellrange(A11:W55) firstrow

rename GEOLabels TIME
gen time = _n+38*4-1
format %tq time
order time 
drop TIME
rename Germanyuntil1990formerterri Germany

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' tot_emp_con
save tot_emp_con_`var', replace
restore
}

foreach var in C E G I K M O Q S U W{
preserve
keep time `var'
gen stat_break_con  = `var'
drop `var'
save stat_break_`var', replace
restore

}

use tot_emp_con_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using tot_emp_con_`var'
}

save tot_emp_conNACE9808.dta, replace

use stat_break_C, clear
foreach var in  E G I K M O Q S U W{
append using stat_break_`var'
}

save break_con_9808.dta, replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase tot_emp_con_`var'.dta
}

foreach var in C E G I K M O Q S U W{
erase stat_break_`var'.dta
}

use tot_emp_conNACE9808.dta
gen obs = _n
save tot_emp_conNACE9808.dta, replace 

use break_con_9808.dta
gen obs = _n
save break_con_9808.dta, replace 

use tot_emp_conNACE9808.dta
merge 1:1 obs using break_con_9808.dta
drop _merge 
drop obs

save tot_emp_conNACE9808.dta, replace 

*This program cleans labor cost data (from EUROSTAT)
********************************************************************************
clear
import excel "$DATA/LFSQ_EGANA2.xlsx", sheet("Sheet 1") cellrange(A11:W63) firstrow

rename GEOLabels TIME
gen time = _n+48*4-1
format %tq time
order time 
drop TIME
rename Germanyuntil1990formerterri Germany

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' tot_emp
save tot_emp_`var', replace
restore
}

foreach var in C E G I K M O Q S U W{
preserve
keep time `var'
gen stat_break  = `var'
drop `var'
save stat_break_`var', replace
restore
}

use tot_emp_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using tot_emp_`var'
}

save tot_empNACE0920.dta, replace

use stat_break_C, clear
foreach var in  E G I K M O Q S U W{
append using stat_break_`var', force 
}

save break_0920.dta, replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase tot_emp_`var'.dta
}

foreach var in C E G I K M O Q S U W{
erase stat_break_`var'.dta
}

use tot_empNACE0920.dta
gen obs = _n
save tot_empNACE0920.dta, replace 

use break_0920.dta
gen obs = _n
save break_0920.dta, replace 

use tot_empNACE0920.dta
merge 1:1 obs using break_0920.dta
drop _merge 
drop obs

save tot_empNACE0920.dta, replace 

********************************************************************************
clear
import excel "$DATA/LFSQ_EGANA2.xlsx", sheet("Sheet 2") cellrange(A11:W63) firstrow

rename GEOLabels TIME
gen time = _n+48*4-1
format %tq time
order time 
drop TIME
rename Germanyuntil1990formerterri Germany

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' tot_emp_manuf
save tot_emp_manuf_`var', replace
restore

}

foreach var in C E G I K M O Q S U W{
preserve
keep time `var'
gen stat_break_manuf  = `var'
drop `var'

save stat_break_`var', replace
restore

}

use tot_emp_manuf_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using tot_emp_manuf_`var'
}

save tot_emp_manufNACE0920.dta, replace

use stat_break_C, clear
foreach var in  E G I K M O Q S U W{
append using stat_break_`var', force
}

save break_manuf_0920.dta, replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase tot_emp_manuf_`var'.dta
}

foreach var in C E G I K M O Q S U W{
erase stat_break_`var'.dta
}

use tot_emp_manufNACE0920.dta
gen obs = _n
save tot_emp_manufNACE0920.dta, replace 

use break_manuf_0920.dta
gen obs = _n
save break_manuf_0920.dta, replace 

use tot_emp_manufNACE0920.dta
merge 1:1 obs using break_manuf_0920.dta
drop _merge 
drop obs

save tot_emp_manufNACE0920.dta, replace 

*This program cleans labor cost data (from EUROSTAT)
********************************************************************************
clear
import excel "$DATA/LFSQ_EGANA2.xlsx", sheet("Sheet 3") cellrange(A11:W63) firstrow

rename GEOLabels TIME
gen time = _n+48*4-1
format %tq time
order time 
drop TIME
rename Germanyuntil1990formerterri Germany

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' tot_emp_con
save tot_emp_con_`var', replace
restore
}

foreach var in C E G I K M O Q S U W{
preserve
keep time `var'
gen stat_break_con  = `var'
drop `var'
save stat_break_`var', replace
restore
}

use tot_emp_con_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using tot_emp_con_`var'
}
save tot_emp_conNACE0920.dta, replace

use stat_break_C, clear
foreach var in  E G I K M O Q S U W{
append using stat_break_`var',  force
}
save break_con_0920.dta, replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase tot_emp_con_`var'.dta
}

foreach var in C E G I K M O Q S U W{
erase stat_break_`var'.dta
}

use tot_emp_conNACE0920.dta
gen obs = _n
save tot_emp_conNACE0920.dta, replace 

use break_con_0920.dta
gen obs = _n
save break_con_0920.dta, replace 

use tot_emp_conNACE0920.dta
merge 1:1 obs using break_con_0920.dta
drop _merge 
drop obs

save tot_emp_conNACE0920.dta, replace 

********************************************************************************
********************************************************************************
use tot_emp_conNACE0920.dta, clear 
merge 1:1 geo time using tot_emp_manufNACE0920.dta
drop _merge
merge 1:1 geo time using tot_empNACE0920
drop _merge
sort geo time
by geo : drop if _n<5
save emp_by_sector_0920, replace

erase tot_empNACE0920.dta 
erase tot_emp_manufNACE0920.dta 
erase tot_emp_conNACE0920.dta

use tot_emp_conNACE9808.dta, clear 
merge 1:1 geo time using tot_emp_manufNACE9808.dta
drop _merge
merge 1:1 geo time using tot_empNACE9808
drop _merge
save emp_by_sector_9808, replace

erase tot_empNACE9808.dta 
erase tot_emp_manufNACE9808.dta 
erase tot_emp_conNACE9808.dta

use emp_by_sector_9808, clear 
append using emp_by_sector_0920
sort geo time
save emp_by_sector_final, replace 
********************************************************************************
********************************************************************************
use emp_by_sector_final.dta, clear 
order geo time tot_emp stat_break tot_emp_manuf stat_break_manuf ///
tot_emp_con stat_break_con

sort time geo 
egen id =group(geo)
egen t =group(time)
xtset id time
drop if t<17
drop if t>84

gen mancon_emp_share = 100*(tot_emp_manuf+tot_emp_con)/tot_emp

keep geo time id t mancon_emp_share
drop t
bys geo : gen t = _n

save "$OUTPUT/emp_by_sector_final", replace
********************************************************************************
********************************************************************************
************
erase "break_0920.dta"
erase "break_9808.dta"
erase "break_con_0920.dta"
erase "break_con_9808.dta"
erase "break_manuf_0920.dta"
erase "break_manuf_9808.dta"
erase "emp_by_sector_0920.dta"
erase "emp_by_sector_9808.dta"
erase "emp_by_sector_final.dta"






 



