********************************************************************************
import excel "$DATA/datastream_feb2023.xlsx", sheet("Sheet1") firstrow clear
drop if Country == "Eurozone"|Country == "Luxembourg"
egen id = group(Country)
bys id : gen time = _n+155
order id time Dates
format %tq time
xtset id time
drop Dates

 foreach k in HICP HICPENERGY HICPENERGYFOODALCHOLTOB HICPSERVICE HICPENERGYFOOD{
 bys id : gen `k'_yoy = (`k'/l4.`k'-1)*100
 bys id : gen `k'_qoq = (`k'/l.`k'-1)*100
 }

keep id time *_yoy *_qoq Import_Prices Terms_Trade nairu_oxford Energy ///
FuelsDomesticPrice CrudeOilPriceAverageineur Wages SPF_nextYear SPF_2Y SPF_5Y SPF_1Y

xtset id time
bys id :  gen lImport_Prices = l.Import_Prices

save "$OUTPUT/datastream_feb23", replace 
********************************************************************************
