********************************************************************************
import excel "$DATA/valueadded.xlsx", sheet("va_manuf") firstrow clear

rename time TIME
gen time = _n+20*4-1
format %tq time
order time 
drop TIME

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' va_manuf
save va_manuf_`var', replace
restore
}

use va_manuf_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using va_manuf_`var'
}
sort geo time
egen id=group(geo)
xtset id time 
drop geo
save va_manuf.dta, replace

********************************************************************************
import excel "$DATA/valueadded.xlsx", sheet("va_con") firstrow clear

rename time TIME
gen time = _n+20*4-1
format %tq time
order time 
drop TIME


foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' va_con
save va_con_`var', replace
restore
}

use va_con_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using va_con_`var'
}
sort geo time
egen id=group(geo)
xtset id time 
drop geo
save va_con.dta, replace

********************************************************************************
import excel "$DATA/valueadded.xlsx", sheet("va_trade") firstrow clear

rename time TIME
gen time = _n+20*4-1
format %tq time
order time 
drop TIME

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' va_trade
save va_trade_`var', replace
restore
}

use va_trade_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using va_trade_`var'
}
sort geo time
egen id=group(geo)
xtset id time 
drop geo
save va_trade.dta, replace

********************************************************************************
import excel "$DATA/valueadded.xlsx", sheet("va_prof") firstrow clear

rename time TIME
gen time = _n+20*4-1
format %tq time
order time 
drop TIME

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' va_prof
save va_prof_`var', replace
restore
}

use va_prof_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using va_prof_`var'
}
sort geo time
egen id=group(geo)
xtset id time 
drop geo
save va_prof.dta, replace
********************************************************************************
*Final data 

use va_con.dta, clear 
merge 1:1 id time using va_manuf.dta
drop _merge 
merge 1:1 id time using va_trade.dta
drop _merge 
merge 1:1 id time using va_prof.dta
drop _merge 
order id time
save "$OUTPUT/valueadded", replace
 
foreach var in Belgium  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase "va_prof_`var'.dta"
}

foreach var in Belgium  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase "va_con_`var'.dta"
}

foreach var in Belgium  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase "va_trade_`var'.dta"
}

foreach var in Belgium  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase "va_manuf_`var'.dta"
}

erase va_manuf.dta
erase va_con.dta
erase va_prof.dta
erase va_trade.dta
********************************************************************************

