*This file cleans data MP shocks from Altavilla et al. 2018
clear
import excel "$DATA/Dataset_EA-MPD.xlsx", sheet("Monetary Event Window") firstrow

*Create time dummy for year, month, quarter 
gen year = year(date) 
gen month = month(date)
gen quarter = 1 if month<=3
replace quarter = 2 if month>=4 & month<=6
replace quarter = 3 if month>=7 & month<=9
replace quarter = 4 if month>=10 & month<=12

*Define mp shock as sum of shock within same quarter
bys year quarter: egen mp_shock = sum(OIS_3M)
bys year quarter: egen mp_shock_long = sum(OIS_10Y)
bys year quarter: egen mkt = sum(STOXX50)
bys year quarter: keep if _n ==1
// replace mp_shock = mp_shock_long if year>=2011

//consider only pure monetary policy shocks
//(inverselly correlated with stock exchange movements)
gen check  = mp_shock*mkt
keep  if check>0

keep year quarter mp_shock mp_shock_long

*Define time variable 
gen time = yq(year, quarter)
format time %tq
tsset time

order time year quarter mp_shock*

*Define lags
gen lmp_shock = l.mp_shock
gen l2mp_shock = l2.mp_shock
gen l3mp_shock = l3.mp_shock
gen l4mp_shock = l4.mp_shock
gen l5mp_shock = l5.mp_shock
gen l6mp_shock = l6.mp_shock
gen l7mp_shock = l7.mp_shock
gen l8mp_shock = l8.mp_shock

replace lmp_shock = 0 if lmp_shock==.
replace l2mp_shock = 0 if l2mp_shock==.
replace l3mp_shock = 0 if l3mp_shock==.
replace l4mp_shock = 0 if l4mp_shock==.
replace l5mp_shock = 0 if l5mp_shock==.
replace l6mp_shock = 0 if l6mp_shock==.
replace l7mp_shock = 0 if l7mp_shock==.
replace l8mp_shock = 0 if l8mp_shock==.

gen lmp_shock_long = l.mp_shock_long
gen l2mp_shock_long = l2.mp_shock_long
gen l3mp_shock_long = l3.mp_shock_long
gen l4mp_shock_long = l4.mp_shock_long
gen l5mp_shock_long = l5.mp_shock_long
gen l6mp_shock_long = l6.mp_shock_long
gen l7mp_shock_long = l7.mp_shock_long
gen l8mp_shock_long = l8.mp_shock_long

replace lmp_shock_long = 0 if lmp_shock_long==.
replace l2mp_shock_long = 0 if l2mp_shock_long==.
replace l3mp_shock_long = 0 if l3mp_shock_long==.
replace l4mp_shock_long = 0 if l4mp_shock_long==.
replace l5mp_shock_long = 0 if l5mp_shock_long==.
replace l6mp_shock_long = 0 if l6mp_shock_long==.
replace l7mp_shock_long = 0 if l7mp_shock_long==.
replace l8mp_shock_long = 0 if l8mp_shock_long==.

gen lmp_shock_ma = 0.25*(lmp_shock + l2mp_shock + l3mp_shock + l4mp_shock)
replace lmp_shock_ma=0 if lmp_shock_ma==.
save "$OUTPUT/mp_shock_altavilla", replace 
********************************************************************************


