********************************************************************************
clear
use "$DATA/cpi_eurostat_weights_complete_nov22", clear 
keep if coicop=="TOT_X_NRG_FOOD" | coicop=="TOT_X_NRG_FOOD_NP" | ///
coicop=="TOT_X_NRG_FOOD_S" |coicop=="NRG"|coicop=="FOOD"    
sort coicop
egen p_id = group(coicop)
forvalues k=1/5{
preserve 
keep if p_id==`k'
rename prc_hicp_inw   w_icp_`k'
replace w_icp_`k'=w_icp_`k'/1000
keep geo geo_label time  w_icp_`k' 
save  w_icp_nov22_`k', replace
restore
}

use w_icp_nov22_1, clear 
forvalues k=2/5{
merge 1:1 geo time using w_icp_nov22_`k'
drop _m
}
sort geo_label time
drop geo
egen id =group(geo_label)
order id 
rename time year 
forvalues k=1/5{
erase w_icp_nov22_`k'.dta 
}

rename w_icp_1 w_icp_food
rename w_icp_2 w_icp_nrg 
rename w_icp_3 w_icp_x_nrg_food 
rename w_icp_4 w_icp_x_nrg_foodnp
rename w_icp_5 w_icp_x_nrg_foods

save "$OUTPUT/weights_cpi_nov22_final", replace 
********************************************************************************

use "$DATA/cpi_eurostat_complete_nov22", clear 
drop unit_label unit

keep if coicop=="SERV" | coicop=="TOT_X_FOOD_S" | coicop=="TOT_X_NRG" | ///
coicop=="TOT_X_NRG_FOOD" | coicop=="TOT_X_NRG_FOOD_NP" | ///
coicop=="TOT_X_NRG_FOOD_S" |coicop=="CP00" | coicop=="NRG"|coicop=="CP045"|coicop=="ELC_GAS"

sort coicop
egen p_id = group(coicop)

forvalues k=1/10{
preserve 
keep if p_id==`k'
rename prc_hicp_midx   prc_`k'
keep geo geo_label time prc_`k' coicop_label
save cpi_nov22_`k', replace
restore
}

use cpi_nov22_1, clear 
forvalues k=2/10{
merge 1:1 geo time using cpi_nov22_`k'
drop _m
}
sort geo_label time
drop geo
egen id =group(geo_label)
order id 

*year/quarter dummy 
bys id: gen year = yofd(dofm(time))
bys id year: gen month = _n
bys id year : gen quarter = 1 if month<=3
bys id year : replace quarter = 2 if month>3 & month<=6
bys id year : replace quarter = 3 if month>6 & month<=9
bys id year : replace quarter = 4 if quarter==.

*Inflation 
xtset id time
bys id: gen nrg_p_index =  (prc_2 +  l.prc_2 +l2.prc_2)/3
foreach k in prc_1 prc_2 prc_3 prc_4 prc_5 prc_6 prc_7 prc_8 prc_9 prc_10 {
gen P_`k' = `k'
replace `k' =  ( `k')
}

sort id time
xtset id time
foreach k in prc_1 prc_2 prc_3 prc_4 prc_5 prc_6 prc_7 prc_8 prc_9 prc_10  {
bys id: gen d`k'_monthly = 100*(`k'-l12.`k')/l12.`k'
bys id: gen d`k'_monthly_qoq = 100*(`k'-l3.`k')/l3.`k'
bys id: gen d`k'_SW_monthly = 100*(`k'-l12.`k')/l12.`k' - 100*(l12.`k'-l24.`k')/l24.`k'
}

foreach k in prc_1 prc_2 prc_3 prc_4 prc_5 prc_6 prc_7 prc_8 prc_9 prc_10{
bys id year quarter: egen d`k' = mean(d`k'_monthly)
}
bys id year quarter: egen dprc_1_SW = mean(dprc_1_SW_monthly)
bys id year quarter: egen dprc_1_qoq = mean(dprc_1_monthly_qoq)
bys id year quarter : keep if _n==3
drop *_monthly
keep id geo_l year quarter dprc* P* nrg_p_index coicop_label  

bys id : gen time = _n+143
order geo time 
format %tq time
xtset id time
bys id:  gen lnrg_p_index =  l.nrg_p_index 
bys id:  gen Dnrg_p_index =  (nrg_p_index/l.nrg_p_index-1)*100

rename dprc_1 dprc  
rename dprc_2 dprc_elec_gas_oil_energy
rename dprc_3 dprc_elec_gas 
rename dprc_4 dprc_nrg  
rename dprc_5 dprc_serv 
rename dprc_6 dprc_x_foods  
rename dprc_7 dprc_x_nrg  
rename dprc_8 dprc_x_nrg_food  
rename dprc_9 dprc_x_nrg_foodnp  
rename dprc_10 dprc_x_nrg_foodns
rename dprc_1_SW dprc_SW
rename dprc_1_qoq dprc_qoq

foreach k in dprc dprc_elec_gas_oil_energy dprc_elec_gas dprc_nrg dprc_serv dprc_x_foods dprc_x_nrg dprc_x_nrg_food dprc_x_nrg_foodnp dprc_x_nrg_foodns dprc_qoq{
 bys id: gen l`k' = l.`k'
 bys id: gen l2`k' = l3.`k'
 bys id: gen l3`k' = l3.`k'
 bys id: gen l4`k' = l4.`k'
 bys id: gen l5`k' = l5.`k'
 bys id: gen l6`k' = l6.`k'
 bys id: gen l7`k' = l7.`k'
 bys id: gen l8`k' = l8.`k'
}

rename P_prc_1  P  
rename P_prc_2 P_elec_gas_oil_energy
rename P_prc_3 P_elec_gas 
rename P_prc_4 P_nrg  
rename P_prc_5 P_serv 
rename P_prc_6 P_x_foods  
rename P_prc_7 P_x_nrg  
rename P_prc_8 P_x_nrg_food  
rename P_prc_9 P_x_nrg_foodnp  
rename P_prc_10 P_x_nrg_foodns

foreach k in P P_elec_gas_oil_energy P_elec_gas P_nrg P_serv P_x_foods P_x_nrg P_x_nrg_food ///
P_x_nrg_foodnp P_x_nrg_foodns{
bys id: gen sum_`k' = `k' + 0.99*f.`k' + (0.99^2)*f2.`k' + (0.99^3)*f3.`k'
  bys id: gen l`k' = l.`k'
bys id: gen l4`k' = l4.`k'
bys id:gen D`k' = (`k'/l.`k'-1)*100
}

merge m:1 id year using "$OUTPUT/weights_cpi_nov22_final"
drop _merge 

xtset id time

bys id : gen dprc_energy_share = dprc*w_icp_nrg
bys id : gen dprc_food_share = dprc*w_icp_food
bys id : gen core_inf = dprc*w_icp_x_nrg_food 
bys id : gen core_inf2 = dprc*w_icp_x_nrg_foodnp
bys id : gen core_inf3 = dprc*w_icp_x_nrg_foods
save "$OUTPUT/cpi_nov22_redux_final", replace 
********************************************************************************
forvalues k=1/10{
erase cpi_nov22_`k'.dta
}
********************************************************************************
 


