*cleaning NT inflation
clear
import excel "$DATA/NT_inflation_GDPdeflator.xlsx", sheet("NonTradable_log") firstrow cellrange(A1:M85)
*Time variable
gen time = _n+39*4-1
format %tq time
drop Data
********************************************************************************
foreach k in AUSTRIA BELGIUM FINLAND FRANCE GERMANY ///
GREECE IRELAND ITALY NETHERLANDS PORTUGAL SPAIN {
preserve
keep `k' time
gen geo = "`k'"
rename `k' dp_nt
replace dp_nt = 100*dp_nt
save `k'_nt, replace
restore
}
clear 
********************************************************************************
foreach k in AUSTRIA BELGIUM FINLAND FRANCE GERMANY ///
GREECE IRELAND ITALY NETHERLANDS PORTUGAL SPAIN {
append using `k'_nt,
}

egen id = group(geo)
drop geo
save "$OUTPUT/inflation_nontradable", replace 
********************************************************************************
foreach k in AUSTRIA BELGIUM FINLAND FRANCE GERMANY ///
GREECE IRELAND ITALY NETHERLANDS PORTUGAL SPAIN {
erase `k'_nt.dta
}

********************************************************************************
clear
import excel "$DATA/NT_inflation_GDPdeflator.xlsx", sheet("NonTradable_log") firstrow cellrange(P1:AB85)

*Time variable
gen time = _n+39*4-1
format %tq time
drop Data

foreach k in AUSTRIA BELGIUM FINLAND FRANCE GERMANY ///
GREECE IRELAND ITALY NETHERLANDS PORTUGAL SPAIN {
preserve
keep `k' time
gen geo = "`k'"
rename `k' p_nt
save `k'_nt, replace
restore
}
clear 
********************************************************************************
foreach k in AUSTRIA BELGIUM FINLAND FRANCE GERMANY ///
GREECE IRELAND ITALY NETHERLANDS PORTUGAL SPAIN {
append using `k'_nt,
}

egen id = group(geo)
drop geo
xtset id time
bys id : gen dp_nt_qoq = (p_nt/l.p_nt-1)*100
bys id : gen ldp_nt_qoq = l.dp_nt_qoq

save "$OUTPUT/price_nontradable", replace 
********************************************************************************
foreach k in AUSTRIA BELGIUM FINLAND FRANCE GERMANY ///
GREECE IRELAND ITALY NETHERLANDS PORTUGAL SPAIN {
erase `k'_nt.dta
}
********************************************************************************
