*Cleaning Inflaation expectations 
********************************************************************************
clear
import excel "$DATA/exp_inflation.xls", ///
sheet("Sheet1") cellrange(A1:D3245) firstrow clear
gen t = _n

drop if country == "Latvia"
drop if country == "Lithuania"
drop if country == "Slovakia"
drop if country == "Slovenia"

egen id = group(country)
xtset id t
bys id : gen ep_1y = (cpimean_fh1 + L.cpimean_fh1 + L2.cpimean_fh1)/3
keep if month==3|month==6|month==9|month==12
drop cpimean_fh1
********************************************************************************
*Time variable
bys id: gen time = _n+40*4-1
format %tq time
drop date month t country
********************************************************************************
order id  ep 
xtset id time
bys id : gen lep_1y = l.ep_1y
bys id : gen l2ep_1y = l2.ep_1y
bys id : gen l3ep_1y = l3.ep_1y
bys id : gen l4ep_1y = l4.ep_1y
bys id : gen l5ep_1y = l5.ep_1y
bys id : gen l6ep_1y = l6.ep_1y
bys id : gen l7ep_1y = l7.ep_1y
bys id : gen l8ep_1y = l8.ep_1y
bys id : gen l1y_ma_ep_1y = 0.25*(l4.ep_1y+l5.ep_1y+l6.ep_1y+l7.ep_1y)
bys id: gen F1y_ma_ep_1y = ep_1y + F.ep_1y + F2.ep_1y + F3.ep_1y
save "$OUTPUT/expected_inflation_november22", replace 
********************************************************************************
