clear
import excel "$DATA/OECD_EconOutlook_Data_2018.xlsx", firstrow
destring Time, gen(year)
drop Time
replace y_oecd=y_oecd/1000000 
replace y_pot=y_pot/1000000 
save "$OUTPUT/oecd_unemp_nairu_data22.dta", replace 

use "$OUTPUT/data_for_nairu.dta", clear  
xtset id time 
merge m:1 id year using "$OUTPUT/oecd_unemp_nairu_data22.dta"
keep if  _merge==3
drop _merge
********************************************************************************
********************************************************************************
********************************************************************************
*Rescaling factor for original series of unemployment:
*Notice that Austria (id=1) has an outlier in unemp. in the original series (2002q1), 
*therefore we rescale by the level of unemp. of 2002q2. 
bys id: replace nairu_oecd = (nairu_oecd/u_rate_oecd[17]  )*u[17] if id!=1
bys id: replace nairu_oecd = (nairu_oecd/u_rate_oecd[18]  )*u[18] if id==1
bys id: replace y_pot_oecd = (y_pot_oecd/y_oecd[17]  )*RealGDP[17]
bys id: gen y_new = RealGDP*(y_oecd[17]/RealGDP[17])
bys id: gen u_new = u*(u_rate_oecd[17]/u[17])
********************************************************************************
order id year time nairu_oecd u u_rate_oecd
sort id time
xtset id time
bys id year : replace nairu_oecd = . if _n<4
by id: ipolate nairu_oecd time, generate(nairu_oecd2)   
order id year time nairu_oecd* u u_rate_oecd
drop nairu_oecd
rename nairu_oecd2 nairu_oecd
********************************************************************************
bys id year : replace y_pot_oecd = . if _n<4
by id: ipolate y_pot_oecd time, generate(y_pot_oecd2)   
order id year time nairu_oecd* u u_rate_oecd y_pot* y_new 
drop  y_pot_oecd
rename y_pot_oecd2 y_pot_oecd
********************************************************************************
xtset id time
bys id : gen lnairu_oecd = l.nairu_oecd
bys id : gen l2nairu_oecd = l2.nairu_oecd
bys id : gen l3nairu_oecd = l3.nairu_oecd
bys id : gen l4nairu_oecd = l4.nairu_oecd
bys id : gen l5nairu_oecd = l5.nairu_oecd
bys id : gen l6nairu_oecd = l6.nairu_oecd
bys id : gen l7nairu_oecd = l7.nairu_oecd
bys id : gen l8nairu_oecd = l8.nairu_oecd
bys id : gen l9nairu_oecd = l9.nairu_oecd
********************************************************************************
bys id : gen ly_pot_oecd = l.y_pot_oecd
bys id : gen l2y_pot_oecd = l2.y_pot_oecd
bys id : gen l3y_pot_oecd = l3.y_pot_oecd
bys id : gen l4y_pot_oecd = l4.y_pot_oecd
bys id : gen l5y_pot_oecd = l5.y_pot_oecd
bys id : gen l6y_pot_oecd = l6.y_pot_oecd
bys id : gen l7y_pot_oecd = l7.y_pot_oecd
bys id : gen l8y_pot_oecd = l8.y_pot_oecd
bys id : gen l9y_pot_oecd = l9.y_pot_oecd

bys id : gen fnairu_oecd = f.nairu_oecd
bys id : gen f2nairu_oecd = f2.nairu_oecd
bys id : gen f3nairu_oecd = f3.nairu_oecd
bys id : gen f4nairu_oecd = f4.nairu_oecd
bys id : gen f5nairu_oecd = f5.nairu_oecd
bys id : gen f6nairu_oecd = f6.nairu_oecd
bys id : gen f7nairu_oecd = f7.nairu_oecd
bys id : gen f8nairu_oecd = f8.nairu_oecd
bys id : gen f9nairu_oecd = f9.nairu_oecd

bys id : gen nairu_oecd_ma = (l4.nairu_oecd+l5.nairu_oecd+l6.nairu_oecd+l7.nairu_oecd)*0.25
bys id : gen l4nairu_oecd_ma = l.nairu_oecd_ma
bys id : gen l5nairu_oecd_ma = l2.nairu_oecd_ma
bys id : gen l6nairu_oecd_ma = l3.nairu_oecd_ma
bys id : gen l7nairu_oecd_ma = l4.nairu_oecd_ma
bys id : gen l8nairu_oecd_ma = l5.nairu_oecd_ma
bys id : gen l9nairu_oecd_ma = l9.nairu_oecd_ma

keep if year> 2001 & year< 2019 
keep id *nairu_oecd*  *y_pot_oecd* y_new time u_new
save "$OUTPUT/nairu_oecd_may2023", replace

