
******************************************************************************** 
********************************************************************************  
use "$DATA/multiple_contract.dta", clear 
keep if age=="Y15-74"  
keep if sex=="T"
  
sort geo_label
egen id = group(geo_label)
label define id 1 "Austria" 2 "Belgium" 3 "Finland" 4 "France" 5 "Germany" ///
6 "Greece" 7 "Ireland" 8 "Italy" 9 "Netherlands" 10 "Portugal" 11 "Spain"  
label values id id

sort isco08 
order isco08*
egen isco = group(isco08)
order isco 
replace isco = 13 if isco ==1
replace isco=isco-2

forvalues i=0/11{
preserve 
keep if isco ==`i'
gen multiple_isco`i'=lfsq_e2gis
  replace multiple_isco`i' = 0 if multiple_isco`i'==.
keep time id geo_l multiple_isco*
save isco_`i', replace
restore
}
use isco_0, clear 
forvalues i=1/11{
merge 1:1 id time using  isco_`i'
// keep if _merge == 3
drop _merge 
}
bys id : drop  if _n < 17
bys id : drop  if _n > 68

rename multiple_isco10 total
rename multiple_isco11 nr
order multiple*

bys id : gen multiple_r = multiple_isco4 + multiple_isco7 + multiple_isco8 
bys id : gen multiple_m = multiple_isco9 + multiple_isco6 + multiple_isco5 
bys id : gen multiple_a = multiple_isco1 + multiple_isco2 + multiple_isco3 + multiple_isco0 
 
xtset id time
merge 1:1 id time using "$OUTPUT/modified_data_october23.dta", force
keep if _merge ==3
drop _merge

preserve 
use  "$DATA/emp_lf.dta", clear 
sort geo  
egen id = group(geo)
drop geo
save emp_lf23, replace 
restore 

merge 1:1 id time using emp_lf23
keep if _merge ==3
drop _merge 
erase emp_lf23.dta

*Conditional Probabilities*
sort id time
bys id  : gen multi_r = 100*multiple_r/(emp*RoutineNarrow )
bys id  :gen multi_a = 100*(multiple_a)/(emp*Cognitive )
bys id  : gen multi_m = 100*multiple_m/(emp*ManualBroad )
keep geo time id phase_i multi_* year 
save "$OUTPUT/multiple_contract_probability.dta", replace 
********************************************************************************
********************************************************************************
forvalues i=0/11{
erase "isco_`i'.dta" 
}

********************************************************************************
********************************************************************************
