clear 
import excel "$DATA/unemp_by_occ.xlsx", sheet("Ua_share") firstrow
drop if _n==1
rename GEOLabels TIME
gen time = _n+38*4-1
format %tq time
order time 
drop TIME
drop if _n<17
drop if _n>68


foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' ua_share
save ua_share_`var', replace
restore

}

use ua_share_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using ua_share_`var'
}
sort geo time
order geo time

save ua_share.dta, replace


***********************************************************************
***********************************************************************
import excel "$DATA/unemp_by_occ.xlsx", sheet("Ur_share") firstrow clear 
drop if _n==1
rename GEOLabels TIME
gen time = _n+38*4-1
format %tq time
order time 
drop TIME
drop if _n<17
drop if _n>68


foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' ur_share

save ur_share_`var', replace
restore

}

use ur_share_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using ur_share_`var'
}
sort geo time
order geo time

save ur_share.dta, replace



import excel "$DATA/unemp_by_occ.xlsx", sheet("Um_share") firstrow clear 
drop if _n==1
rename GEOLabels TIME
gen time = _n+38*4-1
format %tq time
order time 
drop TIME
drop if _n<17
drop if _n>68

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' um_share
save um_share_`var', replace
restore

}

use um_share_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using um_share_`var'
}
sort geo time
order geo time

save um_share.dta, replace



use um_share.dta, clear
merge 1:1 geo time using ur_share.dta
drop _merge
merge 1:1 geo time using ua_share.dta
drop _merge
replace ua_share = . if geo =="Ireland" & ua_share==0
replace ur_share = . if geo =="Ireland" & ur_share==0

save "$OUTPUT/u_composition_new", replace

erase um_share.dta
erase ur_share.dta
erase ua_share.dta

 
foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase "um_share_`var'.dta"
erase "ua_share_`var'.dta"
erase "uR_share_`var'.dta"
}
********************************************************************************


use "$DATA/emp_lf.dta", clear 
merge 1:1 geo time using  "$OUTPUT/EU_flow",  
drop _merge 
merge 1:1 geo time using "$OUTPUT/u_composition_new.dta"
drop _merge
sort geo time
egen id = group(geo)
merge 1:1 id time using "$OUTPUT/data_for_otherstuff.dta" , force
keep if _merge ==3
drop _merge

xtset id time
drop t 
bys id : gen t=_n

label define id 1 "AT" 2 "BE" 3 "FI" 4 "FR" 5 "DE" 6 "GR" 7 "IE" ///
8 "IT" 9 "NL" 10 "PT" 11 "ES"
label values id id

sort id time
********************************************************************************
****************FIX MISSING POINTS FOR FRANCE & NETHERLANDS*********************
********************************************************************************

gen a  = Cognitive*emp/lf
gen r  = RoutineNarrow*emp/lf
gen m = ManualBroad*emp/lf


********France
reg ur_share  u r  time if id ==4
predict xb_fr if id ==4
order xb_fr ur_share
replace ur_share = xb_fr if ur_share==. & id ==4
drop xb_fr

reg um_share  u m  time if id ==4
predict xb_fr if id ==4
order xb_fr um_share
replace um_share = xb_fr if um_share==. & id ==4
drop xb_fr

replace ua_share = 1-ur_share-um_share if ua_share==. & id ==4

********Netherlands
reg ur_share  u r  time if id ==9
predict xb_fr if id ==9
order xb_fr ur_share
replace ur_share = xb_fr if ur_share==. & id ==9
drop xb_fr

reg um_share  u m  time if id ==9
predict xb_fr if id ==9
order xb_fr um_share
replace um_share = xb_fr if um_share==. & id ==9
drop xb_fr

replace ua_share = 1-ur_share-um_share if ua_share==. & id ==9


sort id time

*******************************************************************************
*******************************************************************************
*******************************************************************************

bys id : gen e_rate  = emp/lf
bys id : gen ea = emp*Cognitive
bys id : gen er = emp*RoutineNarrow
replace ManualBroad = 1-Cognitive- RoutineNarrow
bys id : gen em = emp*ManualBroad


bys id : gen lea = log10(Cognitive)
bys id : gen ler = log10(RoutineNarrow)
bys id : gen lem = log10(ManualBroad)
gen lt  = log10(t)
sort id time
bys id : gen dlea = d.lea
bys id : gen dler = d.ler
bys id : gen dlem = d.lem

bys id : egen mdlea  = mean(dlea)  
bys id : egen mdler  = mean(dler)  
bys id : egen mdlem  = mean(dlem)  

replace mdlea = mdlea*100
replace mdler = mdler*100
replace mdlem = mdlem*100

bys id : gen le = log(emp*Cognitive + emp*RoutineNarrow + emp*ManualBroad)

gen trend = .
gen trend_a=.
gen trend_r=.
gen trend_m=.

forvalues k=1/11{
reg lea lt if id==`k' & phase_i<2
replace trend_a = _b[lt] if id==`k'
}

forvalues k=1/11{
reg ler lt  if id==`k' & phase_i<2
replace trend_r = _b[lt] if id==`k'
}

forvalues k=1/11{
reg lem lt  if id==`k' & phase_i<2
replace trend_m = _b[lt] if id==`k'
}


bys id:gen lf_a = emp*Cognitive + (lf-emp)*ua_share
bys id:gen lf_r = emp*RoutineNarrow + (lf-emp)*ur_share
bys id:gen lf_m = emp*ManualBroad + (lf-emp)*um_share
 
sort id time
bys id: gen unemp = (lf-emp)
bys id: gen unemp_s = EU_flow
 
bys id: gen unemp_a = (lf-emp)*ua_share
bys id: gen unemp_s_a = EU_flow*ua_share
bys id: gen unemp_r = (lf-emp)*ur_share
bys id: gen unemp_s_r = EU_flow*ur_share
bys id: gen unemp_m = (lf-emp)*um_share
bys id: gen unemp_s_m = EU_flow*um_share


bys id: gen X_a =  trend_a + (F.unemp_s_a/ea) - ((d.ea + d.unemp_a)/ea)
bys id: gen X_r =  trend_r +(F.unemp_s_r/er) - ((d.er + d.unemp_r)/er)
bys id: gen X_m =  trend_m + (F.unemp_s_m/em) - ((d.em + d.unemp_m)/em)

bys id: gen h_a = (F.ea - (1 +trend_a - X_a )*ea)/unemp_a
bys id: gen h_r = (F.er - (1 +trend_r - X_r )*er)/unemp_r
bys id: gen h_m = (F.em - (1 +trend_m - X_m )*em)/unemp_m
replace h_a = . if h_a<0
replace h_r = . if h_r<0
replace h_m = . if h_m<0


sort id time
*adjustment for Ireland 
replace X_r = (L.X_r+L2.X_r+L3.X_r+L4.X_r)/4 if id ==7 & t==63
replace X_r = (L.X_r+L2.X_r+L3.X_r+L4.X_r)/4 if id ==7 & t==64
replace X_r = (L.X_r+L2.X_r+L3.X_r+L4.X_r)/4 if id ==7 & t==65

replace h_r = (L.h_r+L2.h_r+L3.h_r+L4.h_r)/4 if id ==7 & t==63
replace h_r = (L.h_r+L2.h_r+L3.h_r+L4.h_r)/4 if id ==7 & t==64
replace h_r = (L.h_r+L2.h_r+L3.h_r+L4.h_r)/4 if id ==7 & t==65


*4-quarters moving average

forvalues k=1/11{
tssmooth ma X_a2 = X_a, window(4 1 )
replace X_a = X_a2 if id==`k'
tssmooth ma h_a2 = h_a, window(4 1 )
replace h_a = h_a2 if id==`k'
drop X_a2
drop h_a2
}



forvalues k=1/11{
tssmooth ma X_r2 = X_r, window(4 1 )
replace X_r = X_r2 if id==`k'
tssmooth ma h_r2 = h_r, window(4 1 )
replace h_r = h_r2 if id==`k'
drop X_r2
drop h_r2
}


forvalues k=1/11{
tssmooth ma X_m2 = X_m, window(4 1 )
replace X_m = X_m2 if id==`k'
tssmooth ma h_m2 = h_m, window(4 1 )
replace h_m = h_m2 if id==`k'
drop X_m2
drop h_m2
}


replace X_a = . if X_a<0
replace X_r = . if X_r<0
replace X_m = . if X_m<0


replace h_a = . if h_a<0
replace h_r = . if h_r<0
replace h_m = . if h_m<0

replace X_a = X_a*100
replace X_r = X_r*100
replace X_m = X_m*100

replace h_a = h_a*100
replace h_r = h_r*100
replace h_m = h_m*100

save "$OUTPUT/conditional_hiring_separation", replace
