clear 
import excel "$DATA/data_for_aggregate_separation.xlsx", sheet("lost job<3months") firstrow
********************************************************************************
********************************************************************************
gen time = _n+42*4-1
format %tq time
order time 
drop TIME

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
preserve
keep time `var'
gen geo  = "`var'"
rename `var' EU_flow
save EU_flow_`var', replace
restore
}

use EU_flow_Belgium, clear
foreach var in  Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
append using EU_flow_`var'
}
sort geo time
order geo time
save "$OUTPUT/EU_flow.dta", replace

foreach var in Belgium Germany Ireland Greece Spain France Italy Netherlands Austria Portugal Finland{
erase "EU_flow_`var'.dta"
}


********************************************************************************
********************************************************************************
use "$DATA/emp_lf.dta", clear 
merge 1:1 geo time using  "$OUTPUT/EU_flow",  
drop _merge 
// merge 1:1 geo time using "$OUTPUT/u_composition_new.dta"
// drop _merge
// sort geo time
egen id = group(geo)
merge 1:1 id time using "$OUTPUT/data_for_otherstuff.dta" , force
keep if _merge ==3
drop _merge
xtset id time
drop t 
bys id : gen t=_n

label define id 1 "AT" 2 "BE" 3 "FI" 4 "FR" 5 "DE" 6 "GR" 7 "IE" ///
8 "IT" 9 "NL" 10 "PT" 11 "ES"
label values id id

sort id time

*******************************************************************************
*****************************Aggregate Separation Rate*************************
*******************************************************************************
*AGGREGATE SEPARATION
bys id: gen DELTA = 100*EU_flow/(L.emp)
*AGGREGATE HIRING
bys id: gen H = 100*(F.emp - (1- (DELTA/100) )*emp)/(lf-emp)
replace H = . if H<0
 
forvalues k=1/11{
tssmooth ma DELTA2 = DELTA, window(4 1 )
replace DELTA = DELTA2 if id==`k'

tssmooth ma H2 = H, window(4 1 )
replace H = H2 if id==`k'

drop DELTA2
drop H2
}

keep geo id time DELTA H phase_i u 
save "$OUTPUT/aggregate_hiring_separation", replace 

********************************************************************************
********************************************************************************
