clear
import excel "$DATA/capital_formation.xlsx", sheet("Sheet1") firstrow

sort GEO TIME
rename TIME time
encode GEO, gen(id)
encode ASSET10, gen(asset)
drop GEO UNIT NACE_R2 ASSET10 UNIT
order id time asset Value 
save capital_formation.dta, replace 

*ict 
use capital_formation.dta, clear 
keep if asset==1
rename Value ict
drop asset FlagandFootnotes
save ict.dta, replace

*intellectual property IP 
use capital_formation.dta, clear 
keep if asset==2
rename Value ip
drop asset FlagandFootnotes
save ip.dta, replace

*total assets
use capital_formation.dta, clear 
keep if asset==4
rename Value ta
drop asset FlagandFootnotes
save ta.dta, replace

*merge
use ict.dta, replace
merge 1:1 id time using ip.dta
drop _merge
merge 1:1 id time using ta.dta
drop _merge
********************************************************************************
********************************************************************************
xtset id time
by id : gen k1 = 100*ict/ta
by id : gen k1_ = 100*(ict+ip)/ta
by id: gen dk1 = (k1[_n]-k1[6])
by id: gen dk1_ = (k1_[_n]-k1_[6])
********************************************************************************
********************************************************************************
xtset id time 
keep if time<2019

*correction  for ireland 
bys id: replace k1_ = k1_ - 22 if id ==7 & time> 2014
rename k1_ inv_into_tech_change
keep inv_into_tech_change id time
save "$OUTPUT/tech_change_investment", replace 

erase "capital_formation.dta"
erase "ta.dta"
erase "ict.dta"
erase "ip.dta"
********************************************************************************
********************************************************************************
