********************************************************************************
********************************************************************************
*GOV. DEBT/GDP     
use "$DATA/gov_debt", clear 
rename gov_10q_ggdebt gov_debt_ratio
keep geo geo_label time gov_debt_ratio
tab geo_l
sort geo_l
egen id = group(geo_label)
xtset id time
keep id time gov_debt_ratio
save gov_debt_ratio, replace 
********************************************************************************
********************************************************************************

use "$DATA/fincorp_asset", clear 
rename nasq_10_f_bs fincorp_asset_F2
keep geo geo_label time fincorp_asset_F2
tab geo_l
sort geo_l
egen id = group(geo_label)
xtset id time
keep id time fincorp_asset_F2
save assets_fin_corp_F2, replace 

use "$DATA/fincorp_liab", clear 
rename nasq_10_f_bs fincorp_liab_F2
keep geo geo_label time fincorp_liab_F2
tab geo_l
sort geo_l
egen id = group(geo_label)
xtset id time
keep id time fincorp_liab_F2
save liab_fin_corp_F2, replace 

use liab_fin_corp_F2, clear 
merge 1:1 id time using assets_fin_corp_F2
drop _merge
merge 1:1 id time using gov_debt_ratio
drop _merge
save "$OUTPUT/national_account_data", replace 

erase assets_fin_corp_F2.dta
erase liab_fin_corp_F2.dta
erase gov_debt_ratio.dta
********************************************************************************
********************************************************************************



