*Cleaning of Duval et al. 2019: EPL data 
clear
import excel "$DATA/EPL_Duval_et_al.xlsx", sheet("Labor market reforms") firstrow
sort country year 

keep if country =="Austria" | country =="Belgium" | country =="Czech Republic" | country =="Finland" | country =="France" | country =="Germany" ///
| country =="Greece" | country =="Ireland" | country =="Italy" | country =="Netherlands" | country =="Portugal" | country =="Slovak Republic" ///
| country =="Spain" | country =="Sweden"

sort country 
egen id = group(country)
order country id year 
keep country id year EPLregularworkers EPLtemporaryworkers
rename EPLregularworkers EPL 
rename EPLtemporaryworkers EPLtemp 
xtset id year 

*Add extra years at the end of the series
preserve 
keep id country year
replace year  = year + 10 
keep if year> 2013 & year<2021
tempfile temp
save `temp'
restore 
append using `temp'
sort id year 

replace EPL = 0 if EPL==.

*Dummies for EPL liberalizing reforms
gen epl_lib = EPL>0
gen epl_tig = EPL<0

*Count number of lib reforms by country 
sort id epl_lib year
bys id epl_lib: gen n_lib = _n if epl_lib==1
bys id epl_lib: replace n_lib=0 if n_lib ==.

tab n_lib
save "$OUTPUT/EPL.dta", replace
 
