********************************************************************************
********************************************************************************
*************************LABOR COST DATA****************************************
********************************************************************************
********************************************************************************
********************************************************************************
use labor_cost_index_nace_2023, clear 
sort geo_label
egen id = group(geo_label)
label define id 1 "Austria" 2 "Belgium" 3 "Finland" 4 "France" 5 "Germany" ///
6 "Greece" 7 "Ireland" 8 "Italy" 9 "Netherlands" 10 "Portugal" 11 "Spain"  
label values id id
keep if nace_r2=="F"|nace_r2=="G"|nace_r2=="I"|nace_r2=="H"|nace_r2=="K"|nace_r2=="L"|nace_r2=="O"|nace_r2=="Q" 

rename lc_lci_r2_q w
order id time w 
sort id time 
keep id time w nace_r2
sort id nace_r2 time
bys id nace_r2: gen  dlw2 = (   w/w[_n-4]-1 )*100 
bys id nace_r2: gen year = 1996 if _n<5
bys id nace_r2: replace year = year[_n-4]+1 if _n>4

merge m:1 id nace_r2 year using labor_cost_weights_nace_2023
keep if _merge==3
gen dlw3 = dlw2*weight
bys id time: egen dlw =sum(dlw3)
bys id time: egen dlw_mean =mean(dlw2)
keep id time dlw dlw_mean year 
bys id time: keep if _n ==1 
keep if year<2019
keep if year>2001
rename dlw_mean w_inf_nt
xtset id time 
bys id: gen lw_inf_nt = l.w_inf_nt
bys id: gen l2w_inf_nt = l2.w_inf_nt
bys id: gen l3w_inf_nt = l3.w_inf_nt
bys id: gen l4w_inf_nt = l4.w_inf_nt
save "$OUTPUT/wage_nontradable_inflation2023", replace
 
use   labor_cost_index_nace_2023, clear 
keep if nace_r2=="B-N"
rename lc_lci_r2_q w 
egen id = group( geo_label)
xtset id time
bys id : gen inf_w_bn = (w/l4.w-1)*100
bys id : gen linf_w_bn = l.inf_w_bn
bys id : gen l2inf_w_bn = l2.inf_w_bn
bys id : gen l3inf_w_bn = l3.inf_w_bn
bys id : gen l4inf_w_bn = l4.inf_w_bn
save "$OUTPUT/labor_cost_index_nace_2023_new_BN", replace
********************************************************************************
********************************************************************************
 
