function [EMP] = Transformations(EMP,time,num_emp,num_cou)
%1. Remove statistical break - Eliminate break keeping the new part as reference
% Following all statistical breaks depending if on only on composition or
% also on total level

%2017Q3 - Ireland
break1 = 2017.5;
br1 = find(time==break1);
%2017Q1 - Belgium
break2 = 2017;
br2 = find(time==break2);
%2015Q1 - Luxembourg 
break3 = 2015;
br3 = find(time==break3);
%2014Q1 - France
break4 = 2014;
br4 = find(time==break4);
%2013Q1 - France and Netherlands (all but total)
break5 = 2013;
br5 = find(time==break5);
%2012Q1 - Germany (all but total)
break6 = 2012;
br6 = find(time==break6);
%2011Q1 - All countries (all but total)
break7 = 2011;
br7 = find(time==break7);
%2010Q1 - Germany 
break8 = 2010;
br8 = find(time==break8);
%2009Q1 - Greece Spain Cyprus Luxembourg
break9 = 2009;
br9 = find(time==break9);
%2007Q1 - Ireland Luxembourg
break10 = 2007;
br10 = find(time==break10);
%2005Q1 - all countries
break11 = 2005;
br11 = find(time==break11);
%2004Q1 - Greece Italy Austria
break12 = 2004;
br12 = find(time==break12);
%2003Q1 - France Luxembourg
break13 = 2003;
br13 = find(time==break13);
%2002Q3 - Lithuania
break14 = 2002.5;
br14 = find(time==break14);
%2002Q1 - Latvia
break15 = 2002;
br15 = find(time==break15);
%2001Q1 - Greece Slovakia
break16 = 2001;
br16 = find(time==break16);
%2000Q1 - Estonia Finland
break17 = 2000;
br17 = find(time==break17);
%1999Q1 - Belgium Slovakia
break18 = 1999;
br18 = find(time==break18);
%1998Q2 - Ireland
break19 = 1998.25;
br19 = find(time==break19);
%1998Q2 - Greece Portugal
break20 = 1998;
br20 = find(time==break20);

growth = zeros(size(EMP,1),size(EMP,2));
for i = 2:size(EMP,1)
    growth(i,:) = (EMP(i,:) - EMP(i-1,:)) ./  EMP(i-1,:);
end

%2017Q3 - Ireland
EMP_temp(:,(4*num_emp)+1:(5*num_emp)) = EMP(:,(4*num_emp)+1:(5*num_emp));
EMP_temp(br1-1,(4*num_emp)+1:(5*num_emp)) = EMP(br1,(4*num_emp)+1:(5*num_emp));
pre_break = 1:(br1-2);
pre_break = flip(pre_break);
for i = 1:br1-2
EMP_temp(pre_break(i),(4*num_emp)+1:(5*num_emp)) = EMP_temp(pre_break(i)+1,(4*num_emp)+1:(5*num_emp)) ./ (1 + growth(pre_break(i)+1,(4*num_emp)+1:(5*num_emp)));
end
EMP(:,(4*num_emp)+1:(5*num_emp)) = EMP_temp(:,(4*num_emp)+1:(5*num_emp));
clear EMP_temp

%2017Q1 - Belgium
EMP_temp(:,(1*num_emp)+1:(2*num_emp)) = EMP(:,(1*num_emp)+1:(2*num_emp));
EMP_temp(br2-1,(1*num_emp)+1:(2*num_emp)) = EMP(br2,(1*num_emp)+1:(2*num_emp));
pre_break = 1:(br2-2);
pre_break = flip(pre_break);
for i = 1:br2-2
EMP_temp(pre_break(i),(1*num_emp)+1:(2*num_emp)) = EMP_temp(pre_break(i)+1,(1*num_emp)+1:(2*num_emp)) ./ (1 + growth(pre_break(i)+1,(1*num_emp)+1:(2*num_emp)));
end
EMP(:,(1*num_emp)+1:(2*num_emp)) = EMP_temp(:,(1*num_emp)+1:(2*num_emp));
clear EMP_temp

%2015Q1 - Luxembourg
EMP_temp(:,(12*num_emp)+1:(13*num_emp)) = EMP(:,(12*num_emp)+1:(13*num_emp));
EMP_temp(br3-1,(12*num_emp)+1:(13*num_emp)) = EMP(br3,(12*num_emp)+1:(13*num_emp));
pre_break = 1:(br3-2);
pre_break = flip(pre_break);
for i = 1:br3-2
EMP_temp(pre_break(i),(12*num_emp)+1:(13*num_emp)) = EMP_temp(pre_break(i)+1,(12*num_emp)+1:(13*num_emp)) ./ (1 + growth(pre_break(i)+1,(12*num_emp)+1:(13*num_emp)));
end
EMP(:,(12*num_emp)+1:(13*num_emp)) = EMP_temp(:,(12*num_emp)+1:(13*num_emp));
clear EMP_temp

%2014Q1 - France
EMP_temp(:,(7*num_emp)+1:(8*num_emp)) = EMP(:,(7*num_emp)+1:(8*num_emp));
EMP_temp(br4-1,(7*num_emp)+1:(8*num_emp)) = EMP(br4,(7*num_emp)+1:(8*num_emp));
pre_break = 1:(br4-2);
pre_break = flip(pre_break);
for i = 1:br4-2
EMP_temp(pre_break(i),(7*num_emp)+1:(8*num_emp)) = EMP_temp(pre_break(i)+1,(7*num_emp)+1:(8*num_emp)) ./ (1 + growth(pre_break(i)+1,(7*num_emp)+1:(8*num_emp)));
end
EMP(:,(7*num_emp)+1:(8*num_emp)) = EMP_temp(:,(7*num_emp)+1:(8*num_emp));
clear EMP_temp

for i = 1:size(EMP,1)
    for k = 0:num_cou-1
        for q = 1:num_emp
            share(i,(k*num_emp)+q) = (EMP(i,(k*num_emp)+q)./EMP(i,(k*num_emp)+2));
        end
    end
end

%2013Q1 - France and Netherlands (all but total)
EMP_temp(:,[(7*num_emp)+1:(8*num_emp) (14*num_emp)+1:(15*num_emp)]) = EMP(:,[(7*num_emp)+1:(8*num_emp) (14*num_emp)+1:(15*num_emp)]);
for q = 3:num_emp
EMP_temp(br5-1,[(7*num_emp)+q (14*num_emp)+q]) = EMP(br5-1,[(7*num_emp)+2 (14*num_emp)+2]).*share(br5,[(7*num_emp)+q (14*num_emp)+q]);
end
pre_break = 1:(br5-2);
pre_break = flip(pre_break);
for i = 1:br5-2
EMP_temp(pre_break(i),[(7*num_emp)+3:(8*num_emp) (14*num_emp)+3:(15*num_emp)]) = (EMP_temp(pre_break(i)+1,[(7*num_emp)+3:(8*num_emp) (14*num_emp)+3:(15*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(7*num_emp)+3:(8*num_emp) (14*num_emp)+3:(15*num_emp)])));
end
EMP(:,[(7*num_emp)+1:(8*num_emp) (14*num_emp)+1:(15*num_emp)]) = EMP_temp(:,[(7*num_emp)+1:(8*num_emp) (14*num_emp)+1:(15*num_emp)]);
clear EMP_temp

for i = 1:size(EMP,1)
    for k = 0:num_cou-1
        for q = 1:num_emp
            share(i,(k*num_emp)+q) = (EMP(i,(k*num_emp)+q)./EMP(i,(k*num_emp)+2));
        end
    end
end

%2012Q1 Germany - all but total
EMP_temp(:,(2*num_emp)+1:(3*num_emp)) = EMP(:,(2*num_emp)+1:(3*num_emp));
for q = 3:num_emp
EMP_temp(br6-1,(2*num_emp)+q) = EMP(br6-1,(2*num_emp)+2).*share(br6,(2*num_emp)+q);
end
pre_break = 1:(br6-2);
pre_break = flip(pre_break);
for i = 1:br6-2
EMP_temp(pre_break(i),(2*num_emp)+3:(3*num_emp)) = EMP_temp(pre_break(i)+1,(2*num_emp)+3:(3*num_emp)) ./ (1 + growth(pre_break(i)+1,(2*num_emp)+3:(3*num_emp)));
end
EMP(:,(2*num_emp)+1:(3*num_emp)) = EMP_temp(:,(2*num_emp)+1:(3*num_emp));
clear EMP_temp


%2011Q1 - all countries (all but total)
EMP_temp = EMP;
for i = 1:size(EMP,1)
    for k = 0:num_cou-1
        for q = 1:num_emp
            share(i,(k*num_emp)+q) = (EMP(i,(k*num_emp)+q)./EMP(i,(k*num_emp)+2));
        end
    end
end
for k = 0:(num_cou-1)
for q = 3:num_emp
EMP_temp(br7-1,(k*num_emp)+q) = EMP(br7-1,(k*num_emp)+2).*share(br7,(k*num_emp)+q);
end
end
pre_break = 1:(br7-2);
pre_break = flip(pre_break);
for i = 1:br7-2
for k = 0:num_cou-1
EMP_temp(pre_break(i),(k*num_emp)+3:((k+1)*num_emp)) = EMP_temp(pre_break(i)+1,(k*num_emp)+3:((k+1)*num_emp)) ./ (1 + growth(pre_break(i)+1,(k*num_emp)+3:((k+1)*num_emp)));
end
end
EMP = EMP_temp;
clear EMP_temp


%2010Q1 Germany
EMP_temp(:,(2*num_emp)+1:(3*num_emp)) = EMP(:,(2*num_emp)+1:(3*num_emp));
EMP_temp(br8-1,(2*num_emp)+1:(3*num_emp)) = EMP(br8,(2*num_emp)+1:(3*num_emp));
pre_break = 1:(br8-2);
pre_break = flip(pre_break);
for i = 1:br8-2
EMP_temp(pre_break(i),(2*num_emp)+1:(3*num_emp)) = EMP_temp(pre_break(i)+1,(2*num_emp)+1:(3*num_emp)) ./ (1 + growth(pre_break(i)+1,(2*num_emp)+1:(3*num_emp)));
end
EMP(:,(2*num_emp)+1:(3*num_emp)) = EMP_temp(:,(2*num_emp)+1:(3*num_emp));
clear EMP_temp

%2009Q1 Greece Spain Cyprus Luxembourg
EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP(:,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]);
EMP_temp(br9-1,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP(br9,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]);
pre_break = 1:(br9-2);
pre_break = flip(pre_break);
for i = 1:br9-2
EMP_temp(pre_break(i),[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP_temp(pre_break(i)+1,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]));
end
EMP(:,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (6*num_emp)+1:(7*num_emp) (9*num_emp)+1:(10*num_emp) (12*num_emp)+1:(13*num_emp)]);
clear EMP_temp


%2007Q1 - Ireland Luxembourg
EMP_temp(:,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP(:,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]);
EMP_temp(br10-1,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP(br10,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]);
pre_break = 1:(br10-2);
pre_break = flip(pre_break);
for i = 1:br10-2
EMP_temp(pre_break(i),[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP_temp(pre_break(i)+1,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]));
end
EMP(:,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP_temp(:,[(4*num_emp)+1:(5*num_emp) (12*num_emp)+1:(13*num_emp)]);
clear EMP_temp

%2005Q1 - all countries
EMP_temp = EMP;
EMP_temp(br11-1,:) = EMP(br11,:);
pre_break = 1:(br11-2);
pre_break = flip(pre_break);
for i = 1:br11-2
EMP_temp(pre_break(i),:) = EMP_temp(pre_break(i)+1,:) ./ (1 + growth(pre_break(i)+1,:));
end
EMP = EMP_temp;
clear EMP_temp

%2004Q1 - Greece Italy Austria
EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]) = EMP(:,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]);
EMP_temp(br12-1,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]) = EMP(br12,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]);
pre_break = 1:(br12-2);
pre_break = flip(pre_break);
for i = 1:br12-2
EMP_temp(pre_break(i),[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]) = EMP_temp(pre_break(i)+1,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]));
end
EMP(:,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]) = EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (8*num_emp)+1:(9*num_emp) (15*num_emp)+1:(16*num_emp)]);
clear EMP_temp


%2003Q1 - France Luxembourg
EMP_temp(:,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP(:,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]);
EMP_temp(br13-1,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP(br13,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]);
pre_break = 1:(br13-2);
pre_break = flip(pre_break);
for i = 1:br13-2
EMP_temp(pre_break(i),[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP_temp(pre_break(i)+1,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]));
end
EMP(:,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]) = EMP_temp(:,[(7*num_emp)+1:(8*num_emp) (12*num_emp)+1:(13*num_emp)]);
clear EMP_temp


%2002Q3 - Lithuania
EMP_temp(:,(11*num_emp)+1:(12*num_emp)) = EMP(:,(11*num_emp)+1:(12*num_emp));
EMP_temp(br14-1,(11*num_emp)+1:(12*num_emp)) = EMP(br14,(11*num_emp)+1:(12*num_emp));
pre_break = 1:(br14-2);
pre_break = flip(pre_break);
for i = 1:br14-2
EMP_temp(pre_break(i),(11*num_emp)+1:(12*num_emp)) = EMP_temp(pre_break(i)+1,(11*num_emp)+1:(12*num_emp)) ./ (1 + growth(pre_break(i)+1,(11*num_emp)+1:(12*num_emp)));
end
EMP(:,(11*num_emp)+1:(12*num_emp)) = EMP_temp(:,(11*num_emp)+1:(12*num_emp));
clear EMP_temp


%2002Q1 - Latvia
EMP_temp(:,(10*num_emp)+1:(11*num_emp)) = EMP(:,(10*num_emp)+1:(11*num_emp));
EMP_temp(br15-1,(10*num_emp)+1:(11*num_emp)) = EMP(br15,(10*num_emp)+1:(11*num_emp));
pre_break = 1:(br15-2);
pre_break = flip(pre_break);
for i = 1:br15-2
EMP_temp(pre_break(i),(10*num_emp)+1:(11*num_emp)) = EMP_temp(pre_break(i)+1,(10*num_emp)+1:(11*num_emp)) ./ (1 + growth(pre_break(i)+1,(10*num_emp)+1:(11*num_emp)));
end
EMP(:,(10*num_emp)+1:(11*num_emp)) = EMP_temp(:,(10*num_emp)+1:(11*num_emp));
clear EMP_temp

%2001Q1 - Greece Slovakia (Slovakia all but total)
EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP(:,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]);
EMP_temp(br16-1,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP(br16,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]);
pre_break = 1:(br16-2);
pre_break = flip(pre_break);
for i = 1:br16-2
EMP_temp(pre_break(i),[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP_temp(pre_break(i)+1,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]));
end
EMP(:,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (18*num_emp)+1:(19*num_emp)]);
clear EMP_temp

%2000Q1 - Estonia Finland
EMP_temp(:,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]) = EMP(:,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]);
EMP_temp(br17-1,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]) = EMP(br17,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]);
pre_break = 1:(br17-2);
pre_break = flip(pre_break);
for i = 1:br17-2
EMP_temp(pre_break(i),[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]) = EMP_temp(pre_break(i)+1,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]));
end
EMP(:,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]) = EMP_temp(:,[(3*num_emp)+1:(4*num_emp) (19*num_emp)+1:(20*num_emp)]);
clear EMP_temp

%1999Q1 - Belgium Slovakia
EMP_temp(:,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP(:,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]);
EMP_temp(br18-1,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP(br18,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]);
pre_break = 1:(br18-2);
pre_break = flip(pre_break);
for i = 1:br18-2
EMP_temp(pre_break(i),[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP_temp(pre_break(i)+1,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]) ./ (1 + growth(pre_break(i)+1,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]));
end
EMP(:,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]) = EMP_temp(:,[(1*num_emp)+1:(2*num_emp) (18*num_emp)+1:(19*num_emp)]);
clear EMP_temp

%1998Q2 - Ireland
EMP_temp(:,(4*num_emp)+1:(5*num_emp)) = EMP(:,(4*num_emp)+1:(5*num_emp));
EMP_temp(br19-1,(4*num_emp)+1:(5*num_emp)) = EMP(br19,(4*num_emp)+1:(5*num_emp));
pre_break = 1:(br19-2);
pre_break = flip(pre_break);
for i = 1:br19-2
EMP_temp(pre_break(i),(4*num_emp)+1:(5*num_emp)) = EMP_temp(pre_break(i)+1,(4*num_emp)+1:(5*num_emp)) ./ (1 + growth(pre_break(i)+1,(4*num_emp)+1:(5*num_emp)));
end
EMP(:,(4*num_emp)+1:(5*num_emp)) = EMP_temp(:,(4*num_emp)+1:(5*num_emp));
clear EMP_temp

%1998Q1 - Greece Portugal
EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (16*num_emp)+1:(17*num_emp)]) = EMP(:,[(5*num_emp)+1:(6*num_emp) (16*num_emp)+1:(17*num_emp)]);
EMP_temp(br20,[(5*num_emp)+1:(6*num_emp) (16*num_emp)+1:(17*num_emp)]) = EMP(br20+1,[(5*num_emp)+1:(6*num_emp) (16*num_emp)+1:(17*num_emp)]);
EMP(:,[(5*num_emp)+1:(6*num_emp) (16*num_emp)+1:(17*num_emp)]) = EMP_temp(:,[(5*num_emp)+1:(6*num_emp) (16*num_emp)+1:(17*num_emp)]);
clear EMP_temp
