% Load and set folders
% Clear and close all
tic
close all
clear all
% Set the folder name
addpath 'x13tbx'
filename = '../../data/input_data/NT_Inflation_GDPdeflator.xlsx'; 
Ys_n = xlsread('../../data/input_data/NT_prices_GDPdeflator.xlsm','VA_NACE','b8:ec133');
Ys_r = xlsread('../../data/input_data/NT_prices_GDPdeflator.xlsm','VA_NACE_real','b8:ec133');


sectors = 10;

    em = [1+sectors];
    oe = [12+sectors];
    bg = [23+sectors];
    fn = [34+sectors];
    fr = [45+sectors];
    ge = [56+sectors];
    gr = [67+sectors];
    ir = [78+sectors];
    it = [89+sectors];
    nl = [100+sectors];
    pt = [111+sectors];
    sp = [122+sectors];

countries = [em oe bg fn fr ge gr ir it nl pt sp];
num_countries = size(countries,2);

time = 1991:.25:2022.25;
time_st = 1998; 
time_end = 2019.75;
st = find(time==time_st);
en = find(time==time_end);


% Domestic sectoral deflator
for i=1:num_countries
sec_def(:,i) = Ys_n(:,(i*11-10))./Ys_r(:,(i*11-10));
Yr_trd_gdp(:,i) = Ys_r(:,2+((i-1)*11)) + Ys_r(:,3+((i-1)*11)) + Ys_r(:,9+((i-1)*11));
Yr_ntd_gdp(:,i) = Ys_r(:,4+((i-1)*11)) + Ys_r(:,5+((i-1)*11)) + Ys_r(:,6+((i-1)*11)) + Ys_r(:,7+((i-1)*11)) + Ys_r(:,8+((i-1)*11)) + Ys_r(:,10+((i-1)*11)) + Ys_r(:,11+((i-1)*11));
trd_def(:,i) = (Ys_n(:,2+((i-1)*11)) + Ys_n(:,3+((i-1)*11)) + Ys_n(:,9+((i-1)*11)) ) ./ (Ys_r(:,2+((i-1)*11)) + Ys_r(:,3+((i-1)*11)) + Ys_r(:,9+((i-1)*11)) ) ;
ntd_def(:,i) = (Ys_n(:,4+((i-1)*11)) + Ys_n(:,5+((i-1)*11)) + Ys_n(:,6+((i-1)*11)) + Ys_n(:,7+((i-1)*11)) + Ys_n(:,8+((i-1)*11)) + Ys_n(:,10+((i-1)*11)) + Ys_n(:,11+((i-1)*11)) ) ./ (Ys_r(:,4+((i-1)*11)) + Ys_r(:,5+((i-1)*11)) + Ys_r(:,6+((i-1)*11)) + Ys_r(:,7+((i-1)*11)) + Ys_r(:,8+((i-1)*11)) + Ys_r(:,10+((i-1)*11)) + Ys_r(:,11+((i-1)*11))) ;
end

% Inflation 
% Domestic Sectorial total inflation
pi_sec_def =sec_def(st:en,:);
for i=1:size(pi_sec_def,1)-1
pi_sec_qoq(i,:) = (pi_sec_def(i+1,:)./pi_sec_def(i,:))-1;
pi_sec_qoq_log(i,:) = log(pi_sec_def(i+1,:))- log(pi_sec_def(i,:));
end

for i=1:size(pi_sec_def,1)-4
pi_sec_yoy(i,:) = (pi_sec_def(i+4,:)./pi_sec_def(i,:))-1;
pi_sec_yoy_log(i,:) = log(pi_sec_def(i+4,:)) - log(pi_sec_def(i,:));
end
pi_sec_ave = mean(pi_sec_yoy);


% Domestic Sectorial T/NT inflsec_ation
t_def = trd_def(st:en,:);
nt_def = ntd_def(st:en,:);
for i=1:size(t_def,1)-1
pih_sec_qoq(i,:) = (t_def(i+1,:)./t_def(i,:))-1;
pin_sec_qoq(i,:) = (nt_def(i+1,:)./nt_def(i,:))-1;

pih_sec_qoq_log(i,:) = log(t_def(i+1,:))- log(t_def(i,:));
pin_sec_qoq_log(i,:) = log(nt_def(i+1,:))-log(nt_def(i,:));
end

for i=1:size(t_def,1)-4
pih_sec_yoy(i,:) = (t_def(i+4,:)./t_def(i,:))-1;
pin_sec_yoy(i,:) = (nt_def(i+4,:)./nt_def(i,:))-1;

pih_sec_yoy_log(i,:) = log(t_def(i+4,:))-log(t_def(i,:));
pin_sec_yoy_log(i,:) = log(nt_def(i+4,:))-log(nt_def(i,:));
end

pht_ave= mean(pih_sec_yoy);
pn_ave= mean(pin_sec_yoy);

name_var = {'Data',	'EME',	'AUSTRIA',	'BELGIUM',	'FINLAND','FRANCE','GERMANY','GREECE','IRELAND','ITALY','NETHERLANDS','PORTUGAL','SPAIN'};


writematrix(pin_sec_yoy_log,filename,'Sheet','NonTradable_log','Range','B2')
writecell(name_var,filename,'Sheet','NonTradable_log','Range','A1')
writematrix(time(st+4:en)',filename,'Sheet','NonTradable_log','Range','A2')


writematrix((nt_def(5:end,:)./pi_sec_def(5:end,:))-1,filename,'Sheet','NonTradable_log','Range','Q2')
writecell(name_var,filename,'Sheet','NonTradable_log','Range','P1')
writematrix(time(st+4:en)',filename,'Sheet','NonTradable_log','Range','P2')

toc