% Replication Package of Siena and Zago, 2023, "Job Polarization, Labor
% Market Fluidity and the Flattening of the Phillips Curve" 
close all
clear
clc

%DATA CONSTRUCTION FOR EMPIRICAL ANALYSIS

%Creates the job-polarization data for the STATA analysis (taking data 
% from Eurostat [lfsq_egais] downloaded on 15/05/2020
run 'Data_polarization.m'

% External functions used (Mktight.m and Transformations.m)
%Creates the non-tradable inflation for the STATA analysis (taking data
%directly from a datastream request table)
run 'NT_inflation_GDPdeflator.m'



%THEORETICAL ANALYSIS
% Computes the Derivative of the Slope of the Price Phillips Curve in the
% Full Model with fixed unemployment and plots Figure 9
run 'BG_derivatives_Fixed_U_May23.m'
close all
% Computes the Slope and the Derivative of the Slope of the Price Phillips Curve in the
% Full Model with variable unemployment and plots Figure D1(a and b) in Appendix D
 
run 'BG_derivatives_Moving_U_May23.m' 
close all

 

%Run Time: 1 minute 26 seconds










