tic
%The figure of the papaer is done using these intervals
 flex_var_alpha  = 0.3:0.01:0.7;
 flex_var_delta  = 0.06:0.001:0.3;

% If you want the figures to be shown, set figures = 1;
figures = 1 ;

part_k = zeros(size(flex_var_alpha,2),size(flex_var_delta,2));
slope_k = zeros(size(flex_var_alpha,2),size(flex_var_delta,2));

for i = 1:size(flex_var_alpha,2)
    for j = 1: size(flex_var_delta,2)
    alpha  = flex_var_alpha(1,i); 
    delta = flex_var_delta(1,j);
Bi = 5/42;
gam  = 0.5;         
alf  = 1;           
the  = 0.5;           
beta  = 0.99;        
phi  = 1;           
eps  = 6;           
lambda = 1/12;        
mu = eps/(eps-1);    
gdel = 0.01;       
ra = 0.9;
chi = 0.9846;

% guess starting points
x_temp= (1/(Bi*mu)*(1-beta*(1-delta)))^(-1/alf);
N_temp = x_temp/(delta+(1-delta)*x_temp);
u_temp = (delta*(1-x_temp))/(delta*(1-x_temp)+x_temp);
g_temp = Bi*x_temp^alf;

fun = @(x)Mktight(x,delta,Bi,beta,alf,chi,mu,the,phi);
x0 = [x_temp N_temp g_temp u_temp];


%Running without display
%options = optimoptions('fsolve','Display','off','Diagnostics', 'off');
%x_try = fsolve(fun,x0,options);

%Running with display
x_try = fsolve(fun,x0);

x = x_try(1);
N = x_try(2);
g = x_try(3);
u = x_try(4);    

    xi_1 = (g*(1-delta)*(1 + alpha*(1 - x)))/(1 - delta * g);
    
    xi_0 = ( 1 - g * ( 1 + alpha)) / ( 1 - delta * g);
    
    diff_xi = xi_1 - xi_0;
    
    denominator_xi = 1 - delta * g;
    
    part_g = alpha * Bi * ( (delta * N)^alpha *( 1 - N))/(delta * ( 1 - N + delta * N)^(1+alpha));
    
    part_x = (N * (1 - (1 - delta) * N ) - delta * N^2)/ ( 1 - ( 1 - delta) * N)^2;
    
    part_xi_1 = 1 / ( 1 - delta * g )^2 * (( part_g * (1 - delta) * ( 1 + alpha) - g * (1 + alpha) + g * alpha * x - part_g * ( 1 - delta) * alpha * x - g * (1 - delta) * alpha * part_x)*(1 - delta * g) + (g * (1 - delta) * (1 + alpha) - g * (1 - delta) * alpha * x) * ( g + delta * part_g)); 
    
    part_xi_0 = 1/(1 - delta * g)^2 * (- part_g * (1 + alpha) * ( 1 - delta * g) + ( 1 - g * ( 1 + alpha)) * ( g + delta * part_g)); 
    
    part_h0 = - (alpha * g * mu)/(delta^2) * ( 1 + beta * (1 - delta)^2 * ( 1 - x)) + part_g * (alpha * mu)/delta * ( 1 + beta * (1 - delta)^2 * (1 - x)) - 2 * (alpha * g * mu)/delta * beta * (1- delta) * (1- x) - (alpha * g  * mu)/delta * beta * (1 - delta)^2 * part_x  - beta * g * mu * (xi_1 - xi_0) + beta * (1 - delta) * part_g * mu * (xi_1 - xi_0) + beta * ( 1 - delta) * g * mu * part_xi_1 - beta * (1 - delta) * g * mu * part_xi_0;  
    
    part_k(i,j) = - lambda/ (1 - (1 - N)) * part_h0;
    
    A0 = - (alpha * g * mu)/(delta^2) * ( 1 + beta * (1 - delta)^2 * ( 1 - x));
    
    A1 = part_g * (alpha * mu)/delta * ( 1 + beta * (1 - delta)^2 * ( 1 - x));
    
    A2 = - 2 * (alpha * g * mu)/delta * ( beta * (1 - delta) * ( 1 - x));
    
    A3 = -(alpha * g * mu)/delta * ( beta * (1 - delta)^2 * part_x);
    
    A4 = - beta * g * mu * (xi_1 - xi_0);
    
    A5 = beta * (1 - delta) * part_g * mu * (xi_1 - xi_0);
        
    A6 = beta * (1 - delta) * g * mu * part_xi_1;
    
    A7 = - beta * (1 - delta) * g * mu * part_xi_0;
    
    part_h0_1 = A0 + A1 + A2 + A3 + A4 + A5 + A6 + A7;
    
    diff_As = part_h0 - part_h0_1; 
    
    h0 = (alpha * g * mu ) / delta * ( 1 + beta * (1 - delta)^2 * (1 - x)) + beta * (1 - delta) * g * mu * (xi_0 - xi_1);
    slope_k(i,j) = -(lambda * h0) / ( 1 - ( 1 - N));
    end
    end
 
    

if figures == 1 

figure(1)
plot(flex_var_delta,part_k(1,:),flex_var_delta,zeros(size(flex_var_delta,2)))
ylabel('Change in the PC slope','FontSize',10)
xlabel('Separation Rate \delta','FontSize',10)

figure(2)
plot(flex_var_alpha,part_k(:,1),flex_var_alpha,zeros(size(flex_var_alpha,2)))
ylabel('Change in the PC slope','FontSize',10)
xlabel('Cost function curvature \alpha','FontSize',10)

part_k_try(:,1) = 1:1:size(flex_var_alpha);


f = figure(3);
[X,Y] = meshgrid(flex_var_delta',flex_var_alpha');
C = part_k;
h1 = surf(X,Y,part_k,C);
colorbar
x2 = xlabel('Separation Rate \delta','FontSize',10);
x1 = ylabel('Cost function curvature \alpha','FontSize',10);


zlabel('Change in the PC slope','FontSize',10)

set(h1,'EdgeColor','none')
hold on;
surface1 = zeros(length(flex_var_alpha'),length(flex_var_delta'));
h2 = surf(X,Y,surface1);
set(h2,'facealpha',0.4,'FaceColor','k', 'EdgeColor','none')


set(gcf, 'PaperPosition',[0 0 28 20]);
set(gcf, 'PaperSize',[28 20]); 

print('-dpdf', '-r300',  ['../../figures/' 'figure_D1a']);

g = figure(4);
[X,Y] = meshgrid(flex_var_delta',flex_var_alpha');
C = slope_k;
h1 = surf(X,Y,slope_k,C);
colorbar
x2 = xlabel('Separation Rate \delta','FontSize',10);
x1 = ylabel('Cost function curvature \alpha','FontSize',10);


zlabel('Slope of the PC','FontSize',10)

set(h1,'EdgeColor','none')
hold on;
surface1 = zeros(length(flex_var_alpha'),length(flex_var_delta'));
h2 = surf(X,Y,surface1);
set(h2,'facealpha',0.4,'FaceColor','k', 'EdgeColor','none')


set(gcf, 'PaperPosition',[0 0 28 20]);
set(gcf, 'PaperSize',[28 20]); 

print('-dpdf', '-r300',  ['../../figures/' 'figure_D1b']);


end 
toc