tic
flex_var_alpha  = 0.3:0.01:0.7;
flex_var_delta  = 0.06:0.001:0.3;
figures = 1 ;

part_k = zeros(size(flex_var_alpha,2),size(flex_var_delta,2));
%i = 1;
%j = 1;
for i = 1:size(flex_var_alpha,2)
    for j = 1: size(flex_var_delta,2)
    alpha  = flex_var_alpha(1,i); 
    delta = flex_var_delta(1,j);
    N = 0.92;
    cost_gdp = 0.01512;  
    mu = 1.2;
    lambda = 1/12;
    gamma = 0.5; 
    beta = 0.99;
    u = 1 - N;
    
    %determined N and delta, we can implicitly find x
    x = (delta * N) / ( 1 - (1 - delta) * N);
    
    %B = cost_gdp / (delta * x^alpha);
    
    B = 5/42;
    
    g = B*(x)^2;
    
    xi_1 = (g*(1-delta)*(1 + alpha*(1 - x)))/(1 - delta * g);
    
    xi_0 = ( 1 - g * ( 1 + alpha)) / ( 1 - delta * g);
    
    diff_xi = xi_1 - xi_0;
    
    denominator_xi = 1 - delta * g;
    
    part_g = alpha * B * ( (delta * N)^alpha *( 1 - N))/(delta * ( 1 - N + delta * N)^(1+alpha));
    
    part_x = (N * (1 - (1 - delta) * N ) - delta * N^2)/ ( 1 - ( 1 - delta) * N)^2;
    
    part_xi_1 = 1 / ( 1 - delta * g )^2 * (( part_g * (1 - delta) * ( 1 + alpha) - g * (1 + alpha) + g * alpha * x - part_g * ( 1 - delta) * alpha * x - g * (1 - delta) * alpha * part_x)*(1 - delta * g) + (g * (1 - delta) * (1 + alpha) - g * (1 - delta) * alpha * x) * ( g + delta * part_g)); 
    
    part_xi_0 = 1/(1 - delta * g)^2 * (- part_g * (1 + alpha) * ( 1 - delta * g) + ( 1 - g * ( 1 + alpha)) * ( g + delta * part_g)); 
    
    part_h0 = - (alpha * g * mu)/(delta^2) * ( 1 + beta * (1 - delta)^2 * ( 1 - x)) + part_g * (alpha * mu)/delta * ( 1 + beta * (1 - delta)^2 * (1 - x)) - 2 * (alpha * g * mu)/delta * beta * (1- delta) * (1- x) - (alpha * g  * mu)/delta * beta * (1 - delta)^2 * part_x  - beta * g * mu * (xi_1 - xi_0) + beta * (1 - delta) * part_g * mu * (xi_1 - xi_0) + beta * ( 1 - delta) * g * mu * part_xi_1 - beta * (1 - delta) * g * mu * part_xi_0;  
    
    part_k(i,j) = - lambda/ (1 - (1 - N)) * part_h0;
    
    A0 = - (alpha * g * mu)/(delta^2) * ( 1 + beta * (1 - delta)^2 * ( 1 - x));
    
    A1 = part_g * (alpha * mu)/delta * ( 1 + beta * (1 - delta)^2 * ( 1 - x));
    
    A2 = - 2 * (alpha * g * mu)/delta * ( beta * (1 - delta) * ( 1 - x));
    
    A3 = -(alpha * g * mu)/delta * ( beta * (1 - delta)^2 * part_x);
    
    A4 = - beta * g * mu * (xi_1 - xi_0);
    
    A5 = beta * (1 - delta) * part_g * mu * (xi_1 - xi_0);
        
    A6 = beta * (1 - delta) * g * mu * part_xi_1;
    
    A7 = - beta * (1 - delta) * g * mu * part_xi_0;
    
    part_h0_1 = A0 + A1 + A2 + A3 + A4 + A5 + A6 + A7;
    
    diff_As = part_h0 - part_h0_1; 
    
    h0 = (alpha * g * mu ) / delta * ( 1 + beta * (1 - delta)^2 * (1 - x)) + beta * (1 - delta) * g * mu * (xi_0 - xi_1);
    slope = -(lambda * h0) / ( 1 - ( 1 - N))
    end
    end
 
    
% CHECK DERIVATIONS - hand written   
%     part_xx = N * (1 - (1 - delta ) * N)^(-1) - delta * N^2 *(1 - ( 1 - delta) * N)^(-2);
%    
% 
%     part_gg = B * alpha * x^(alpha - 1) * part_xx;
%     
%     
%     xi_11 = g * (1 - delta) * ( 1 + alpha * ( 1 - x) ) * ( 1 - delta * g)^(-1);
%     
%     BBO = part_gg * (1 - delta) * ( 1 + alpha * ( 1 - x)) * ( 1 - delta * g)^(-1);
%     BB1  = - g * ( 1 + alpha * ( 1 - x) ) * ( 1 - delta * g)^(-1);
%     BB2  = - g * ( 1 - delta) *  alpha * part_xx * ( 1 - delta * g )^(-1);
%     BB3  = - g * ( 1 - delta) * (1  + alpha * ( 1 - x)) * ( 1 - delta * g)^(-2) * (- g - delta * part_gg);
%     
%     part_xi_11 = BBO + BB1 + BB2 + BB3;
%     
%     xi_00 = ( 1 - g * ( 1 + alpha)) * ( 1 - delta * g )^(-1);
%     
%     C0 = - part_gg  * ( 1 + alpha) * ( 1 - delta * g )^(-1);
%     C1  = - ( 1 - g * ( 1 + alpha)) * ( 1 - delta * g)^(-2) * ( - g  - delta * part_gg);
%     part_xi_00 = C0 + C1;
% 
%     AA0 = - delta^(-2) * alpha * g * mu * ( 1 + beta * ( 1 - delta)^2 * (1 - x));
%     AA1 = - 2 *  alpha * g * mu *  beta * ( 1 - delta) * (1 - x) * delta^(-1);
%     AA2 = part_gg * alpha * mu * ( 1 + beta * ( 1 - delta)^2 * (1 - x)) * delta^(-1);
%     AA3 = - alpha * g * mu * beta * ( 1 - delta)^2 * delta^-1 * part_xx;
%     AA4 = - beta * g * mu * (xi_11 - xi_00);
%     AA5 = beta * ( 1 - delta) * part_gg * mu * (xi_11 - xi_00); 
%     AA6 = beta * ( 1 - delta) * g * mu * part_xi_11;
%     AA7 = - beta * ( 1 - delta) * g * mu * part_xi_00;
%     
%     part_h0_11 = AA0 + AA1 + AA2 + AA3 + AA4 + AA5 + AA6 + AA7;
%     
%     part_kk = 1/(1 - (1 - N)) * lambda * part_h0_11;
%     
%     test_1 = part_xx - part_x;
%     test_2 = part_gg - part_g;
%     test_3 = part_xi_11 - part_xi_1;
%     test_4 = part_xi_00 - part_xi_0;
%     test_5 = xi_11 - xi_1;
%     test_6 = xi_00 - xi_0;
%     
%     test_7 = AA0 - A0;
%     test_8 = AA2 - A1;
%     test_9 = AA1 - A2;
%     test_10 = AA3 - A3;
%     test_11 = AA4 - A4;
%     test_12 = AA5 - A5;
%     test_13 = AA6 - A6;
%     test_14 = AA7 - A7;
%     test_15 = part_h0_11 - part_h0_1;
%     test_16 = part_kk - part_k;

if figures == 1 

figure(1)
plot(flex_var_delta,part_k(1,:),flex_var_delta,zeros(size(flex_var_delta,2)))
ylabel('Change in the PC slope','FontSize',10)
xlabel('Separation Rate \delta','FontSize',10)

figure(2)
plot(flex_var_alpha,part_k(:,1),flex_var_alpha,zeros(size(flex_var_alpha,2)))
ylabel('Change in the PC slope','FontSize',10)
xlabel('Cost function curvature \alpha','FontSize',10)

part_k_try(:,1) = 1:1:size(flex_var_alpha);


f = figure(3);
[X,Y] = meshgrid(flex_var_delta',flex_var_alpha');
C = part_k;
h1 = surf(X,Y,part_k,C);
colorbar
x2 = xlabel('Separation Rate \delta','FontSize',10);
x1 = ylabel('Cost function curvature \alpha','FontSize',10);


zlabel('Change in the PC slope','FontSize',10)
%title('Derivative of the Slope  of the Price Phillips Curve','FontSize',12)
%colormap(f,winter);
set(h1,'EdgeColor','none')
hold on;
surface1 = zeros(length(flex_var_alpha'),length(flex_var_delta'));
h2 = surf(X,Y,surface1);
set(h2,'facealpha',0.4,'FaceColor','k', 'EdgeColor','none')


set(gcf, 'PaperPosition',[0 0 28 20]);
set(gcf, 'PaperSize',[28 20]); 

print('-dpdf', '-r300',  ['../../figures/' 'figure_9']);

end 
toc