# thealtres-sources

Annotations created in the Thealtres project, which compares theater in Alsatian with popular theater in German and French. See https://thealtres.pages.unistra.fr for a project description.

## Project structure

So far the data are produced with online spreadsheets. A project goal is to later convert them to TEI feature structures, using the method devised in earlier work [(Ruiz & Bermúdez, 2022)](https://zenodo.org/doi/10.5281/zenodo.7110069).

For each tradition (Alsatian, German, French), we have two workbooks:

- **Annotations**: Character social variables, setting, number of acts/scenes, etc. Plays' bibliographic metadata are also included here.
- **Bibliographic metadata**: Most of the information here is also part of the *annotations* sheets, but here we may find more information about the source availability (e.g. print source location for sources not online). 

Each file has been assigned a DOI with the [Nakala](https://www.nakala.fr) platform hosted by the French national infrastructure for digital humanities. However, as some people may prefer online spreadsheets, we provide links to those as well (the sheets linked to from here were frozen to match the released data).

## Alsatian

For Alsatian, the data are organized slightly differently, given that a lot of the data (*Annotations 1* below) come from our earlier project, [MeThAL](https://methal.pages.unistra.fr).

- Annotations 1 (from MeThAL)
    - [ODS](./als/annots_als_methal.ods) format, or at DOI [10.34847/nkl.e4e9fqj3](https://dx.doi.org/10.34847/nkl.e4e9fqj3)
    - [Online spreadsheet](https://docs.google.com/spreadsheets/d/1TtAKvbEJa309-3Y_Xu36ap1gwkS1iiH2KrQCie_GfqA/edit?usp=sharing)

- Annotations 2 (new ones created at Thealtres)
    - [ODS](./als/annots_als_thealtres.ods) format, or at DOI [10.34847/nkl.dc8ec0k7](https://dx.doi.org/10.34847/nkl.dc8ec0k7)
    - [Online spreadsheet](https://docs.google.com/spreadsheets/d/1zGfWIvuS6UTjDgFkFZr4EkAd9UCRlfuWgBcXAA3ejY8/edit#gid=1443847021)

## German

- Annotations
    - [ODS](./ger/annots_ger_thealtres.ods) format, or at DOI [10.34847/nkl.ccb28f8t](https://dx.doi.org/10.34847/nkl.ccb28f8t)
    - [Online spreadsheet](https://docs.google.com/spreadsheets/d/1FDU3dZGDDpKs_MlP6Hcf8Tt7jUz5vExLgqJgSuX_a6E/edit?usp=sharing)
- Bibliographic metadata
    - [ODS](./ger/bibliomd_ger_thealtres.ods) format, or at DOI [10.34847/nkl.14ea0ltd](https://dx.doi.org/10.34847/nkl.14ea0ltd)
    - [Online spreadsheet](https://docs.google.com/spreadsheets/d/1Libv04CcTwCzGTznSlpLmzesf1s18h9HUC5Gbf0DkQw/edit?usp=sharing)

## French

- Annotations
    - [ODS](./fre/annots_fre_thealtres.ods) format, or at DOI [10.34847/nkl.aa6fz7oo](https://dx.doi.org/10.34847/nkl.aa6fz7oo)
    - [Online spreadsheet](https://docs.google.com/spreadsheets/d/1KmJWO_LfYYqcW_ucMC-QjdQ2UxnOhrN6SXP-3YoR8R0/edit?usp=sharing)
- Bibliographic metadata
    - [ODS](./fre/bibliomd_fre_thealtres.ods) format, or at DOI [10.34847/nkl.4c52h6y2](https://dx.doi.org/10.34847/nkl.4c52h6y2)
    - [Online spreadsheet](https://docs.google.com/spreadsheets/d/1WpPnGrhFsvqX53cRjWaYYiKDKj5EpwKH2q-P0VzBMZg/edit?usp=sharing)

## License and citation

The license is [CC-BY](LICENSE)


The data can be cited as:

Boisnard, Fanny, Schneider, Alexia, Ruiz Fabo, Pablo, Nugues, Lara, Krautter, Benjamin (2023). Thealtres project annotations: Comparing theater in Alsatian with the dramatic traditions at its source. Université de Strasbourg. https://git.unistra.fr/thealtres/thealtres-sources

Or this poster can be cited:

Ruiz Fabo, Pablo, Boisnard, Fanny, Schneider, Alexia, Nugues, Lara, Krautter, Benjamin (2023). Comparaison entre le théâtre en alsacien (1800-1929) et ses traditions dramatiques sources. *Humanistica 2023*. Poster: https://zenodo.org/doi/10.5281/zenodo.10134342 Abstract: https://hal.science/hal-04105543 Data: https://git.unistra.fr/thealtres/thealtres-sources
