# 3.4 Data Sharing

## Learning Objectives
- Carry out an EO workflow on a cloud platform independently
- Make our results `open` and `FAIR`
- Collaborate with a community of researchers to reach a common goal

## Introduction
We have reached the last chapter of the course. You know about data cubes, cloud platforms and open science. Now it's time to prove it! We will apply everything we have learned so far and complete our own EO workflow on a cloud platform adhering to the open science principles.
We have carried out a full EO workflow to produce snow cover information in an alpine catchment. To make our results impactful we need to make them openly available to other researchers and the general public. Therefore we are going to learn how to share our data set (and code) properly - following the FAIR principles. We have learned about the concepts of open science in lecture [1.3 open science](https://github.com/EO-College/cubes-and-clouds/blob/main/lectures/1.3_openscience/1.3.1_openscienceandfair.md). Now we are going to apply them! We are going to create a snow cover area map of the alps together with all the participants of the course. Everyone adds their contribution to a shared map. With every participant another small patch of the alps gets mapped! The map is openly available so that everybody can track our progress, the data is openly available and you can point to the patch you have provided!

[![Your Open Science Journey](https://img.youtube.com/vi/-8rHmtEMCx8/0.jpg)](https://www.youtube.com/watch?v=-8rHmtEMCx8) <br>
> Video content in cooperation with [Leandro Parente](https://opengeohub.org/people/leandro-parente/) (OpenGeoHub). <br>
> *"Connect - Create - Share - Repeat"* <br>
> Links to OpenGeoHub's open science projects mentioned in the video:
>  - [opengeohub](https://opengeohub.org/)
>  - open environmental data cube: [webgis](http://ecodatacube.eu), [stac catalogue](http://stac.openlandmap.org), [code and documentation](http://eumap.readthedocs.org), [publication](https://doi.org/10.7717/peerj.15478), 
>  - [open earth monitor cyberinfrastructure](https://earthmonitor.org/)

## The steps of your open science journey

### Produce your own map
  - Reuse the workflow to generate the snow covered area data cube 
  - Adapt the workflow to generate your personal contribution to mapping the snow covered area of the alps
      - Choose an extent on the map that hasn't been mapped yet. We are producing patches of roughly 1km by 1km.
      - Choose a time extent. The winter months of a given year.
      - Add a step to reduce the time dimension. We want to create one layer for the winter season of the given year.
      - Adapt the file format to Cloud Optimized GeoTiff (perfectly suitable for a raster file with one time step and one band).
  - Download the result consisting of the STAC metadata and the COG

### Validate the result
  - TBD

### Make the data FAIR and open

<iframe src="https://create.eo-college.org/wp-admin/admin-ajax.php?action=h5p_embed&id=18" width="959" height="689" frameborder="0" allowfullscreen="allowfullscreen" title="Cubes&amp;Clouds: Making your data FAIR"></iframe><script src="https://create.eo-college.org/wp-content/plugins/h5p/h5p-php-library/js/h5p-resizer.js" charset="UTF-8"></script>


  - Customize the STAC metadata (e.g. adding you as the author)
  - Trigger the update of the STAC catalogue and web map by submitting your results. Your data will be openly available!
  - A license is assigned to the whole collection of all the produced patches
  - A doi is assigned to the whole collection of all the produced patches
   
### Evaluate how FAIR the result is
  - Do the FAIR self assessment tool after you've created your results
  - You will get a score on how FAIR the dataset you have produced really is

## Exercise
Time to start your own open science journey. Produce a snow cover area map for a region that hasn't been mapped yet. FAIRify your results and make them publicly available!

[Exercise 3.3 Sharing](https://github.com/EO-College/cubes-and-clouds/blob/main/lectures/3.4_data_sharing/exercises/34_data_sharing.ipynb)

## FAIR Assessment
This tool allows you to check how FAIR your results are. Give it a shot!

**Embed: https://github.com/au-research/FAIR-Data-Assessment-Tool**

## Community Mapping Project
Have a look at your results! Have a look at the community mapping project you have contributed to!

**LINK**

## Congratulations
Congrats! You've made it through the Cubes and Clouds online course! 

[![Introduction to EO Cloud Platforms](https://img.youtube.com/vi/xoCBLAPPn0k/0.jpg)](https://youtu.be/xoCBLAPPn0k) <br>



