# Kolmogorov-Smirnov test
# Burned area data
# ******************************************************************************************
#  * Institution: National Center for Monitoring and Early Warning of Natural Disasters
#  * Purpose: Calculate the Mann Kendall test (Z) and Sen's slope (Q) test for time series of burned area data.
#  * Author: Dbora J. Dutra
# * Email: ddutra.ambiental@gmail.com
# ******************************************************************************************

# Select the desktop
setwd('D:/r')

# Import the libraries
library(ggplot2)
library(raster)
library(rgdal)
library(stats)
library(maptools)

# Import the data
gabam <- raster("gabam_ajuste.tif")/1000
gwis <- raster("gwis_ajuste.tif")/1000
mapbiomas <- raster("mapbiomas_ajuste.tif")/1000
modis <- raster("modis_ajuste.tif")/1000

# Set the number of interactions
inter <- 10000

# Create a dataframe to store all results
resultados_df <- data.frame()

# Loop for comparisons
for (i in 1:inter) {
  # GABAM X GWIS
  gabam_sorteio <- sampleRandom(gabam, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pgabam <- rasterToPoints(gabam_sorteio)
  gwis_sorteio <- sampleRandom(gwis, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pgwis <- rasterToPoints(gwis_sorteio)
  ksp <- ks.test(x = pgabam, y = pgwis)
  resultados_df <- rbind(resultados_df, data.frame(Analise = paste("GABAM_X_GWIS_", i), statistic = ksp$statistic, p.value = ksp$p.value))
  
  # GABAM X MAPBIOMAS
  gabam_sorteio <- sampleRandom(gabam, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pgabam <- rasterToPoints(gabam_sorteio)
  mapbiomas_sorteio <- sampleRandom(mapbiomas, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pmapbiomas <- rasterToPoints(mapbiomas_sorteio)
  ksp <- ks.test(x = pgabam, y = pmapbiomas)
  resultados_df <- rbind(resultados_df, data.frame(Analise = paste("GABAM_X_MAPBIOMAS_", i), statistic = ksp$statistic, p.value = ksp$p.value))
  
  # GABAM X MODIS
  gabam_sorteio <- sampleRandom(gabam, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pgabam <- rasterToPoints(gabam_sorteio)
  modis_sorteio <- sampleRandom(modis, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pmodis <- rasterToPoints(modis_sorteio)
  ksp <- ks.test(x = pgabam, y = pmodis)
  resultados_df <- rbind(resultados_df, data.frame(Analise = paste("GABAM_X_MODIS_", i), statistic = ksp$statistic, p.value = ksp$p.value))
  
  # GWIS X MODIS
  gwis_sorteio <- sampleRandom(gwis, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pgwis <- rasterToPoints(gwis_sorteio)
  modis_sorteio <- sampleRandom(modis, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pmodis <- rasterToPoints(modis_sorteio)
  ksp <- ks.test(x = pgwis, y = pmodis)
  resultados_df <- rbind(resultados_df, data.frame(Analise = paste("GWIS_X_MODIS_", i), statistic = ksp$statistic, p.value = ksp$p.value))
  
  # GWIS X MAPBIOMAS
  gwis_sorteio <- sampleRandom(gwis, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pgwis <- rasterToPoints(gwis_sorteio)
  mapbiomas_sorteio <- sampleRandom(mapbiomas, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pmapbiomas <- rasterToPoints(mapbiomas_sorteio)
  ksp <- ks.test(x = pgwis, y = pmapbiomas)
  resultados_df <- rbind(resultados_df, data.frame(Analise = paste("GWIS_X_MAPBIOMAS_", i), statistic = ksp$statistic, p.value = ksp$p.value))
  
  # MAPBIOMAS X MODIS
  mapbiomas_sorteio <- sampleRandom(mapbiomas, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pmapbiomas <- rasterToPoints(mapbiomas_sorteio)
  modis_sorteio <- sampleRandom(modis, size = 7062, na.rm = TRUE, cells = TRUE, rowcol = TRUE, sp = FALSE, asRaster = TRUE)
  pmodis <- rasterToPoints(modis_sorteio)
  ksp <- ks.test(x = pmapbiomas, y = pmodis)
  resultados_df <- rbind(resultados_df, data.frame(Analise = paste("MAPBIOMAS_X_MODIS_", i), statistic = ksp$statistic, p.value = ksp$p.value))
}

# Exportar para um nico arquivo CSV
write.csv(resultados_df, "resultados_ks_test.csv", row.names = FALSE)