# Data and code to reproduce the analyses reported in the main text of the article:

Title: "Unraveling the clonal trait space: beyond aboveground and fine-root traits"

Authors: Chelli, Stefano; Klimešová, Jitka; Tsalakos, James; Puglielli, Giacomo

Journal: Journal of Ecology

---

# Data:

## 1 - CloPla\_GSPFF\_Imputed.csv

It includes

### 1.1. - Taxonomic information

Resolved_name: species binomial according to the Plant List v.1.1.
genus: the genus to which each species belongs.
family: the family to which each species belongs.
order: the order to which each species belongs.

### 1.2. - Metadata from Klimešová et al. (2017, Ecology 98, 1179-1179)

woody (binomial): 1- woody plant, excluding small shrubs (chamaephytes) and suffruticose plants, 0 - otherwise
annual (binomial): 1 - plants typically living for one season. Includes winter annuals, 0 - otherwise.
perennial (binomial): 1 - plants that do not multiply vegetatively and are neither annual nor woody, 0 - otherwise
clonal (binomial): 1 - plants that live longer than one year, multiply vegetatively and flower several times in their lifetime, 0 - otherwise

### 1.3. - Species-specific information for leaf and plant traits defining the global spectrum of plant form and function. These are:

la (mm2): individual size of a leaf. Area of a leaf in the one-sided projection.
ln (mg g-1): leaf notrogen content on a mass basis. Ratio of the quantity of nitrogen in the leaf per respective unit dry mass.
ph (m): maximum plant height. Maximum height of a whole plant.
sla (mm2 mg-1): specific leaf area. Ratio of the area of a leaf to its dry mass.
ssd (mg mm-3): stem specific density. Ratio of the mass of the stem after drying to its volume assessed without drying
sm (mg): seed mass. Mass of a seed assessed after drying.

Note that these traits were imputed using the procedure explained in the main text of the article. Not imputed trait data were obtained from Carmona et al. (2021, Nature 597, 683–687).

### 1.4. - Clonal traits, obtained from  Klimešová et al. (2017, Ecology 98, 1179-1179). These are:

BBRsize (count): total bud-bank size. Total number of buds stored in bud bearing organs per rooting unit.
persistence (year): persistence of clonal connection. Period of connection between offspring rooting unit and parental rooting unit
offspring (count): multiplication rate. Number of offspring rooting units produced by a parental rooting unit per year.
spread (m year-1): lateral spread. Distance between offspring rooting units and parental rooting unit.

Note: NAs indicate missing information for clonal traits.

---

## 2 - CloPla\_RES\_Imputed.csv

It includes:

### 2.1. - Taxonomic information

Resolved_name: species binomial according to the Plant List v.1.1.
genus: the genus to which each species belongs.
family: the family to which each species belongs.
order: the order to which each species belongs.

### 2.2. - Metadata from Klimešová et al. (2017, Ecology 98, 1179-1179)

woody (binomial): 1- woody plant, excluding small shrubs (chamaephytes) and suffruticose plants, 0 - otherwise
annual (binomial): 1 - plants typically living for one season. Includes winter annuals, 0 - otherwise.
perennial (binomial): 1 - plants that do not multiply vegetatively and are neither annual nor woody, 0 - otherwise
clonal (binomial): 1 - plants that live longer than one year, multiply vegetatively and flower several times in their lifetime, 0 - otherwise

### 2.3. - Species-specific information for fine-root traits defining the root economics space. These are:

SRL (m g-1): Specific root length. Ratio of the length of fine roots to the corresponding fine root mass assessed after drying.
D (mm): Mean root diameter. Diameter of a fine root.
N (mg g-1): Root nitrogen content. Ratio of the quantity of nitrogen in the root to the corresponding root mass assessed after drying.
RTD (g cm-3): Ratio of root mass after drying to the volume assessed without drying.

Note that these traits were imputed using the procedure explained in the main text of the article. Not imputed trait data were obtained from Carmona et al. (2021, Nature 597, 683–687).

### 2.4. - Clonal traits, obtained from  Klimešová et al. (2017, Ecology 98, 1179-1179). These are:

BBRsize (count): total bud-bank size. Total number of buds stored in bud bearing organs per rooting unit.
persistence (year): persistence of clonal connection. Period of connection between offspring rooting unit and parental rooting unit
offspring (count): multiplication rate. Number of offspring rooting units produced by a parental rooting unit per year.
spread (m year-1): lateral spread. Distance between offspring rooting units and parental rooting unit.

Note: NAs indicate missing information for clonal traits.

---

# Code

Note that each of the following script can be executed separately given that the datasets are loaded in the global environment.

### 1 - Trait\_Space\_Growth\_Forms\_Perennials\_only

It allows reproducing Fig. 1 and all the associated results (including TPD-based dissimilarity).

### 2 - corr.plot

It allows reproducing Fig. 2.

### 3 - Aboveground\_Analysis

It allows reproducing Fig. 3 and all the associated results.

### 4 - Procustes\_Above\_and\_Dimensions

It performs procustes analysis between aboveground and clonal trait space.

### 5 - Belowground analysis

It allows reproducing Fig. 4 and all the assocaited results.

### 6 - Procustes\_Below\_and\_Dimensions

It performs procustes analysis between belowground and clonal trait space.
