# Profile data of *Cucumis melo* L. var. *agrestis* Naud. fruits

---

We collected a total of 751 fruits from 31 *Cucumis melo* L. var. *agrestis* Naud. plants, digitized the side profiles of these fruits, and applied an explicit re-expression of Preston’s equation (referred to as EPE hereinafter) to fit the planar coordinates of each fruit profile. By using the estimated parameters, we calculated the volume and surface area of each fruit. The black_white.zip file saves the black and white .bmp images at 600 dpi for the 751 fruits profiles. The edge_data.zip file includes the planar coordinates of each of the 751 fruits, and the EPE results.csv file includes the estimated parameters and goodness-of-fit of the EPE, and the fruit surface area and volume calculated by the surface area and volume formulas of the solid of revolution based on the EPE for each fruit. In addition, the EPE results.csv file also provides the measured volumes of the 751 fruits using the graduated cylinders. The MPG.csv file includes the total leaf dry mass, total stem dry mass, and total fruit volume of 31 *C. melo* var. *Agrestis* plants.

## Description of the data and file structure

In the black_white.zip file, there are 751 .bmp images at 600 dpi. The image size was scaled to its actual size using the ratio of its actual fruit length measured to the fruit length in the scanned image. This means that the image size in a .bmp file is equal to the actual size of a fruit profile.

In the edge_data.zip file, there are 751 .csv files. In each .csv file, there are two columns, which record the x- and y-coordinates in cm for an arbitrary fruit's side profile.

In the EPE results.csv file, there are 18 columns.
(1) Image represents the fruit number. The number before the underline represents the individual plant number, and the number after the underline represents the fruit number of an individual plant.
(2) x0 represents the x-coordinate of the center of a fruit profile (in cm).
(3) y0 represents the y-coordinate of the center of a fruit profile (in cm).
(4) theta represents the angle between the midline of the fruit profile and the x-axis.
(5) a, b, c1, c2 and c3 are the estimated values of the parameters of the explicit Preston equation (see He et al. [2023] for details), where the units of a and b are cm, and c1, c2, and c3 are unitless.
(6) scan.length, scan.width and scan.area represent the scanned fruit length (in cm), maximum width (in cm) and planar area (in cm2), respectively.
(7) RSS represents the residual sum of squares in y-coordinates in cm2.
(8) sample.size represents the sample size, i.e., the number of data points on a fruit profile.
(9) RMSE represents the root-mean-square error in cm.
(10) V.pre and S.pre represent the predicted fruit volume (in cm3) and surface area (in cm2) using the volume and surface area formulas based on the explicit Preston equation with the estimated parameters, respectively.
(11) V.obs represents the volume (in cm3) measured using the graduated cylinder.

In the MPG.csv file, there are 4 columns.
(1)Code represents the plant code of each of 31 *C. melo* var. *agrestis* plants.
(2)LeafM represents the total dry weight (in g) of all leaves for each plant.
(3)StemM represents the total dry weight (in g) of all stems for each plant.
(4)FruitV represents the total volume (in cm3) of all fruits for each plant.

Reference(s)
He, K.; Hui, C.; Yao, W.; Wang, J.; Wang, L.; Li, Q.; Shi, P. Evidence that field muskmelon (*Cucumis melo* L. var. *agrestis* Naud.) fruits are solids of revolution. *Plants* **2023**, in press.
