function [a,b]=ordershifts(sa,sb)
% Reordering of Sylvester ADI shifts sa,sb s.t. realification is possible
% Input:
%
%    sa,sb   vectors with a,b-shifts for Sylvester ADI, need to be
%            closed w.r.t. to complex conjugation 
%            AND complex shifts need to occur together as pairs 
%           (e.g., sa=rrrrrrccrrccrrcc, where cc={p,conj(p)}) 

%  Output:
%
%    a,b    reordered shifts so, that a complex pair in set a meets a
%           complex pair or two real shifts  in set b (or vise-versa):
%    Example:         a: rrrccrrccrrcc
%                     b: ccrccccrrrrcc
%
% Patrick Kuerschner 2011-24


J=length(sa);
L=length(sb);
G=lcm(J,L);
a=[];b=[];
for j=1:G/J
    a=[a;sa];
end
for j=1:G/L
    b=[b;sb];
end
j=1;
while j<G
    if isreal(a(j)) && isreal(b(j))
        %         do nothing
        j=j+1;
    elseif ~isreal(a(j))&&(a(j)==conj(a(j+1)))&& isreal(b(j))&&isreal(b(j+1))
        %         do nothing
        j=j+2;
    elseif ~isreal(b(j))&&(b(j)==conj(b(j+1)))&& isreal(a(j))&&isreal(a(j+1))
        %         do nothing
        j=j+2;
    elseif ~isreal(a(j))&&(a(j)==conj(a(j+1))) && (~isreal(b(j))&&(b(j)==conj(b(j+1))))
        %  do nothing
        j=j+2;
    elseif ~isreal(a(j))&&(a(j)==conj(a(j+1))) && (isreal(b(j))&&(~isreal(b(j+1))))
        t=b(j); b(j:j+1)=b(j+1:j+2); b(j+2)=t;
        j=j+2;
    elseif ~isreal(b(j))&&(b(j)==conj(b(j+1))) && (isreal(a(j))&&(~isreal(a(j+1))))
        t=a(j); a(j:j+1)=a(j+1:j+2); a(j+2)=t;
        j=j+2;
    end
end

