% DEMO 1 for a Sylvester Equation AX+XB+fg'=0, where A,B are 
%  nonsymmetric and come from FD discretizations of 2D elliptic operators
% with convection terms.
% This demo also showcases the exact LR-ADI as well as the inexact LR-ADI.

clear
clf
load('demo0_data.mat')
n=size(A,1);
m=size(B,1);
r=size(F,2);
[~,Rg]=qr(F,0);
[~,Rf]=qr(G,0);
res0=norm(Rf*Rg');

% or generate from scratch using dataset form M.M.E.S.S
% A = fdm_2d_matrix(200,'10','200','x');
% B = fdm_2d_matrix(150,'10','1000','x*y');
% n=size(A,1);
% m=size(B,1);
% r=2;
% F=rand(n,r);
% G=rand(m,r);

% standard/generalized Sylv.eqn, for standard case, M=C=[] is ok
M=speye(n); %spdiags([-1,2,-1],[-1:1],n,n);
C=speye(m); %spdiags([-1,4,-1],[-1:1],m,m);

%%
l0A=30; % number of ADI a-shifts
l0B=30; % number of ADI b-shifts
kpA=10; % number of Ritz values of A
kmA=20; % number of inverse Ritz values of A
kpB=10; % number of Ritz values of B
kmB=20; % number of inverse Ritz values of A
%
% generate ADI shifts
% Ritzvalues of  A using Arnoldi
[Hp,Vp] = arn_pl(A,M,kpA,F*ones(r,1));
rwp= eig(Hp(1:kpA,1:kpA));
% (inverse) Ritzvalues of A (using direct solves)
[Hm,Vm] = arn_inv(A,M,kmA,F*ones(r,1));
rwm = ones(kmA,1)./eig(Hm(1:kmA,1:kmA));
sA=sort([rwp;rwm]);
sA=sA(1:l0A);
% Ritzvalues of  B
[Hp,Vp] =arn_pl(B,C,kpB,G*ones(r,1));
rwp = eig(Hp(1:kpB,1:kpB));
% (inverse) Ritzvalues of B (using direct solves)
[Hm,Vm] = arn_inv(B,C,kmB,G*ones(r,1));
 rwm = ones(kmB,1)./eig(Hm(1:kmB,1:kmB));
 sB=sort([rwp;rwm]);
 sB=sB(1:l0B);
[sA,sB]=ordershifts(sA,sB); %reordering for realification
[sA,sB]=pseudominmax(sA,sB);
 %%
 % global ADI settings
 maxit=50; % max. number of steps
 tol=1e-8; % desired scaled Sylv. norm
 % norm of rhs
 [~,Rf]=qr(F,0); [~,Rg]=qr(G,0);
 res0=norm(Rf*Rg'); 

 %%
 disp('LR-ADI for Sylvester, direct solves, complex')
 % the very basic method, only supports direct linear solves
 tic
 [Z,D,Y,res,niter,timings]=lr_adi_sylv_ex_cpx(A,B,M,C,F,G,sA,sB,maxit,tol);
 t=toc
 res1_ex=syl_r_norm(A,B,F,G,Z,D,Y,m,M,C,[],[])/res0 % check res. via Lanczos estimate
%%
 % realified version, but only supports direct linear solves
 tic
 [Zr,Dr,Yr,res1r,niter1r,timings1r]=lr_adi_sylv_ex_real(A,-B,M,C,-F,G,sA,-sB,maxit,tol);
 tr=toc
 % Note that this version works on A*X*C -M*X*B = F*G'
 res1R_ex=syl_r_norm(A,B,F,G,Zr,Dr,Yr,m,M,C,[],[])/res0 % check res. via Lanczos estimate
 %%
disp('inexact LR-ADI for Sylvester with iterative linear solves (complex only)')
% allowing iterative linear solves used many more
% settings for the solver/precond./tolerances
opts.inner_tol=tol/20;
opts.itolmax=1e-0;
opts.itolmin=1e-12;
opts.maxit_inner=500;
opts.linsolverA='bicgstab';
opts.linsolverB='bicgstab';
opts.intolstrat='fixed';
intolstrat='relax';
opts.rgap_update =1;
opts.backlook=0;
opts.debug=0;
opts.M1A=[];
opts.M2A=[];
opts.M1B=[];
opts.M2B=[];
opts.bal_q=1;
opts.symA=0;
opts.symB=0;
opts.savg=1;
opts.MtypeA=[]; opts.MtypeB=[];
precAset.droptol=0.01;
[opts.M1A,opts.M2A]=ilu(A+mean(sB)*M,precAset);
[opts.M1B,opts.M2B]=ilu(B'+mean(sA)*C',precAset);

 %% fixed inner tols
 opts.intolstrat='fixed';
 tic
 [Z2,D2,Y2,res2,niter2,timings2,out2]=lr_adi_sylv(A,B,M,C,F,G,sA,sB,maxit,tol,opts);
 t2=toc
res2_ex=syl_r_norm(A,B,F,G,Z2,D2,Y2,m,M,C,[],[])/res0 % check res. via Lanczos estimate

 %% relaxed inner tols
 opts.intolstrat='relax';
 opts.u_update = 1;
 opts.backlook=1;
 tic
 [Z3,D3,Y3,res3,niter3,timings3,out3]=lr_adi_sylv(A,B,M,C,F,G,sA,sB,maxit,tol,opts);
 t2=toc 
res3_ex=syl_r_norm(A,B,F,G,Z3,D3,Y3,m,M,C,[],[])/res0 % check res. via Lanczos estimate
 %% relaxed inner tols, B-mode
 opts.intolstrat='bal_relax';
 opts.u_update = 1;
 opts.backlook=1;
 opts.bal_q=0;
 tic
 [Z4,D4,Y4,res4,niter4,timings4,out4]=lr_adi_sylv(A,B,M,C,F,G,sA,sB,maxit,tol,opts);
 t4=toc
 res4_ex=syl_r_norm(A,B,F,G,Z4,D4,Y4,m,M,C,[],[])/res0 % check res. via Lanczos estimate

%%
fprintf('fixed-tol: \t total: %d, \t in-it A: %d,\t in-it B: %d\t\n',...
    sum(sum(out2.nrit,2)),(sum(out2.nrit(1,:),2)),(sum(out2.nrit(2,:),2)))
fprintf('relax-tol: \t total: %d, \t in-it A: %d,\t in-it B: %d, reldiff2fix: %4.2f%% \n',...
    sum(sum(out3.nrit,2)),(sum(out3.nrit(1,:),2)),(sum(out3.nrit(2,:),2)),sum(sum(out3.nrit))/sum(sum(out2.nrit))*100)
fprintf('relax-tol-B: \t total: %d, \t in-it A: %d,\t in-it B: %d, reldiff2fix: %4.2f%% \t\n',...
    sum(sum(out4.nrit,2)),(sum(out4.nrit(1,:),2)),(sum(out4.nrit(2,:),2)),sum(sum(out4.nrit))/sum(sum(out2.nrit))*100)


%%
figure(1),
 semilogy(1:length(res(1,:)),res(1,:),'k-.',...
     res1r(2,:),res1r(1,:),'k--',...
   1:length(res2(1,:)),res2(1,:),'r-+',...  
  1:length(res3(1,:)),res3(1,:),'b-+',...
  1:length(res4(1,:)),res4(1,:),'m-.')
 xlabel('step')
 ylabel('sylv res')
 legend('direct','direct-R','fixed','relax','relax,B')


figure(2),
 plot(1:niter2,cumsum(out2.nrit(1,:)),'k-.',...
     1:niter2,cumsum(out2.nrit(2,:)),'r--',...
     1:niter3,cumsum(out3.nrit(1,:)),'b-+',...
  1:niter3,cumsum(out3.nrit(2,:)),'b-v',...
  1:niter4,cumsum(out4.nrit(1,:)),'m-s',...
  1:niter4,cumsum(out4.nrit(2,:)),'m-o')
 xlabel('step')
 ylabel('sum(inner iters)')
 legend('fix,A','fix,B','relax,A','relax,B','brelax,A','brelax,B')
 title('cummulative sum of inner steps')


 
 figure(3),
 semilogy(1:length(res3(1,:)),out3.inres(1,:),'k--',...
     1:length(res3(1,:)),out3.itol(1,:),'k:',...
  1:length(res3(1,:)),out3.inres(2,:),'b-+',...
  1:length(res3(1,:)),out3.itol(2,:),'b:')
 legend('inres,A','itol,A','inres,B','itol,B')
 xlabel('step')
 ylabel('inner res and tol')
 title('basic relaxation')

 figure(4),
   semilogy(1:length(res4(1,:)),out4.inres(1,:),'k--',...
  1:length(res4(1,:)),out4.itol(1,:),'k:',...
  1:length(res4(1,:)),out4.inres(2,:),'b-+',...
  1:length(res4(1,:)),out4.itol(2,:),'b:')
 legend('inres,A','itol,A','inres,B','itol,B')
 xlabel('step')
 ylabel('inner res and tol')
 title('B-mode relaxation')