function z = MV(M, x, adj)
% matrix-vector-product
% INPUT:    x - vector
%           M - matrix or function handle for M*x
%           adj - 1 for adjoint product M'*y, 0 otherwise
% OUTPUT:   y=M*x or y=M'*x
%
% (C) Patrick Kuerschner 2011-24

if nargin < 3 || isempty(adj)
    adj=0;
end
if  ~isempty(M)
    if isnumeric(M)
        if ~adj
            if ~isempty(M)
                z = M*x;
            else
                z = x;
            end
        else
            if ~isempty(M)
                z = (x'*M)';
                %             z = M'*x;
            else
                z = x;
            end
        end
    else %function handle
        if ~adj
            z = M(x,adj);
        else
            z = M(x,adj);
        end
    end
else
    z=x;
end
    