# Tibetan Abbreviations
This repository contains a table of Tibetan abbreviations found in sources being explored by the ERC project *The Dawn of Tibetan Buddhist Scholasticism (11th-13th c.) (TibSchol)*. Cf. https://www.oeaw.ac.at/projects/tibschol for more information. 

This project, hosted at the Institute for Cultural and Intellectual History of Asia of the Austrian Academy of Sciences, has received funding from the European Research Council (ERC) under the European Union's Horizon 2020 research and innovation programme (grant agreement No. 101001002). See https://cordis.europa.eu/project/id/101001002.

The table was compiled by [Rachael Griffiths](https://github.com/rgriffiths1) and will be updated over the course of the project. 

To access the table directly, click on [abbr.csv](https://github.com/ERC-TibSchol/abbreviations/blob/master/abbr.csv). 

# Sources
A large part of TibSchol’s corpus appeared in the series bKa’ gdams gsung ’bum phyogs bsgrigs thengs dang po/gnyis pa/gsum pa/bzhi pa. 120 vols. Ed. dPal brtsegs bod yig dpe rnying zhib ’jug khang. Chengdu: Si khron mi rigs dpe skrun khang, 2006, 2007, 2009, 2015.

# Notes
The table is arranged alphabetically using the [Python port of BDRC's JS Library](https://github.com/Esukhia/tibetan-sort-python). For more on sorting Tibetan in alphabetical order, see [this](https://www.bdrc.io/blog/2022/03/30/sorting-out-tibetan-alphabetical-order/?lang=bo) post by [Élie Roux](https://github.com/eroux).

The database is in [CSV](https://en.wikipedia.org/wiki/Comma-separated_values). Columns 1 and 2 present the abbreviations to the degree it is possible using the [Extended Wylie Transliteration Scheme](https://www.thlib.org/reference/transliteration/#!essay=/thl/ewts/intro/) (EWTS) and existing Tibetan Unicode. Columns 3 and 4 present the expansions in EWTS and Unicode.

# Other Resources
A list of 300+ abbreviations can be found on [Babelstone](https://www.babelstone.co.uk/Tibetan/Contractions.html).

The [Resources for Kanjur and Tenjur Studies](http://www.rkts.org/abb/index.php) (rKTs) has compiled a list of 3000+ abbreviations.

Dawa Shönu has posted a list of abbreviations [here](https://dawashonu.blogspot.com/2022/02/blog-post_8.html). 

A list of abbreviations can be found in Appendix I of van der Kuijp, Leonard W. J., et al. Bcom Ldan Ral Gri (1227-1305) on Indian Buddhist Logic and Epistemology : His Commentary on Dignāga's Pramāṇasamuccaya. Wien: [WSTB 80](https://wstb.univie.ac.at/product/wstb-no-80/), 2013.

Shes rab. sKung yig gsal byed nor bu’i me long. Beijing: Mi rigs dpe skrun khang, 2003. [BDRC: MW25257](http://purl.bdrc.io/resource/MW25257). A book of Tibetan abbreviations arranged alphabetically.
