# Tibetan-Cursive-Ground-Truth
This repository contains the Ground Truth (GT) for Handwritten Text Recognition (HTR) models to recognize the handwritten Tibetan scripts Drutsa ('bru tsha) and Betsug (dpe tshugs). The models trained on this basis are public on Transkribus (model IDs: [54525](https://readcoop.eu/model/tibetan-cursive-drutsa/) and [54935](https://readcoop.eu/model/tibetan-cursive-betsug/)).

The Ground Truth was prepared in the framework of the ERC  project "The Dawn of Tibetan Buddhist Scholasticism (11th-13th c.)" (TibSchol). Cf. https://www.oeaw.ac.at/projects/tibschol for more information. This project has received funding from the European Research Council (ERC) under the European Union's Horizon 2020 research and innovation programme (grant agreement No. 101001002). See https://cordis.europa.eu/project/id/101001002.

This dataset comprises of 27 files drawn from a selection of Tibetan manuscripts in cursive script. Files contain transcriptions in .txt format. Images are not hosted here. The table in the [Ground Truth Overview](https://github.com/ERC-TibSchol/Tibetan-Cursive-GT/blob/master/Ground%20Truth%20Overview.csv) allows users to match the transcription provided with the corresponding images. 

**Filename**: The file name is composed of a letter indicating the script – B for Betsug, D for Drutsa – and a reference number internal to the TibSchol project.

**Number of pages**: Number of pages (one folio side).

**Image Reference**: The source of the images. The table gives the reference to the abbreviated title and pages of the print publication, and the corresponding reference number for this item assigned by the [Buddhist Digital Resource Center](https://www.bdrc.io/) (BDRC). Some images are exclusively accessible via BDRC. For those, the table gives the title, range of folio used, and BDRC reference number.  

# Abbreviations
**KDSB** bKaʼ gdams gsung ʼbum phyogs bsgrigs thengs dang po/gnyis pa/gsum pa/bzhi pa. dByangs can lha mo et al. (eds). Chengdu: Si khron dpe skrun tshogs pa si khron mi rigs dpe skrun khang, 2006/2007/2009/2015. 
