# Contributing to Detectors 🧐

Hi there, Thank you for even being interested in contributing to Detectors

To contribute to this project, please follow a ["fork and pull request"](https://docs.github.com/en/get-started/quickstart/contributing-to-projects) workflow.

## Contributing guidelines

Our issues page is kept up to date with bugs, improvements, and feature requests. There is a taxonomy of labels to help with sorting and discovery of issues of interest. These include:

- `method`
- `pipeline`
- `dataset`
- `model`
- `example`
- `documentation`
- `test`
- `bug`

If you start working on an issue, please assign it to yourself.

If you are adding an issue, please try to keep it focused on a single modular bug/improvement/feature. If the two issues are related, or blocking, please link them rather than keep them as one single one.

We will try to keep these issues as up to date as possible.

### How to submit changes

To contribute to this project, please follow a ["fork and pull request"](https://docs.github.com/en/get-started/quickstart/contributing-to-projects) workflow.

### How to report a bug

Create an issue with the `bug` label.

### How to suggest a feature or enhancement

Create an issue with the appropriate label or labels related to the desired feature or enhancement.

### Getting help

Although we try to have a developer setup to make it as easy as possible for others to contribute (see below) it is possible that some pain point may arise around environment setup, linting, documentation, or other. Should that occur, please contact a maintainer! Not only do we want to help get you unblocked, but we also want to make sure that the process is smooth for future contributors.

### Release process

The entire release process, including running tests, building documentation, and publishing to PyPI are automated with Github flows and will be triggered upon a successful push on the `master` branch.

---

## Installing dependencies

To install development requirements:

```bash
pip install -e ".[dev]"
```

This will install all requirements for running the package, examples, linting, formatting, tests, and coverage.

## Testing

Unit tests are written using [pytest](https://docs.pytest.org/en/stable/).

Code coverage (i.e. the amount of code that is covered by unit tests) helps identify areas of the code that are potentially more or less brittle.

To run the tests, run:

```bash
make test
```

---

## Documentation

### Contribute Documentation

Docs are largely autogenerated by [sphinx](https://www.sphinx-doc.org/en/master/) from the code.

### Build Documentation Locally

To build the documentation locally, run:

```bash
make doc
```

---

## Coding conventions

### Code Formatting

Formatting for this project is done via a combination of [Black](https://black.readthedocs.io/en/stable/) and [isort](https://pycqa.github.io/isort/).

To format the code, run:

```bash
make format
```

### Linting

Linting for this project is done via a combination of [Black](https://black.readthedocs.io/en/stable/), [isort](https://pycqa.github.io/isort/), and [flake8](https://flake8.pycqa.org/en/latest/).

To lint the code, run:

```bash
make lint
```

## Thanks! 🧐
