from setuptools import find_packages, setup

install_requires = [
    "Pillow",
    "numpy",
    "optuna",
    "scikit-learn",
    "scikit-image",
    "timm>=0.8.19.dev0",
    "torch>=1.13.1",
    "torchvision",
    "tqdm",
    "scipy",
    "accelerate",
    "psutil",
    "pandas",
    "wilds",
    "faiss-cpu",
    "matplotlib",
]

dev_requires = [
    "black",
    "isort",
    "flake8",
    "pytest",
    "pytest-cov",
    "pytest-timeout",
    "pytest-xdist",
    "twine",
    "sphinx",
    "sphinx_rtd_theme",
    "myst-parser",
    "six",
]

setup(
    name="detectors",
    # version="{{VERSION_PLACEHOLDER}}",
    version="0.1.11",
    author="Eduardo Dadalto",
    author_email="edadaltocg@gmail.com",
    description="Detectors: a python package to benchmark generalized out-of-distribution detection methods.",
    long_description=open("README.md", "r", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    keywords="vision deep learning pytorch OOD",
    license="APACHE 2.0",
    url="https:c/github.com/edadaltocg/detectors",
    package_dir={"": "src"},
    packages=find_packages("src"),
    include_package_data=True,
    python_requires=">=3.8.0",
    install_requires=install_requires,
    extras_require={
        "dev": dev_requires,
    },
    classifiers=[
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Intended Audience :: Science/Research",
        "Operating System :: OS Independent",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
    ],
)
