/**
 * BioSimulations Data Service
 * RESTful application programming interface documentation for the Biosimulations Data Service, based on the HDF Scalable Data Service (HSDS) from the HDF Group.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */

import { HttpService } from '@nestjs/axios';
import { Inject, Injectable, Optional } from '@nestjs/common';
import { AxiosResponse } from 'axios';
import { Observable } from 'rxjs';
import { InlineResponse20014 } from '../model/inlineResponse20014';
import { InlineResponse20015 } from '../model/inlineResponse20015';
import { Configuration } from '../configuration';

@Injectable()
export class AttributeService {
  protected basePath = 'https://data.biosimulations.dev';
  public defaultHeaders: Record<string, string> = {};
  public configuration = new Configuration();

  constructor(protected httpClient: HttpService, @Optional() configuration: Configuration) {
    this.configuration = configuration || this.configuration;
    this.basePath = configuration?.basePath || this.basePath;
  }

  /**
   * @param consumes string[] mime-types
   * @return true: consumes contains 'multipart/form-data', false: otherwise
   */
  private canConsumeForm(consumes: string[]): boolean {
    const form = 'multipart/form-data';
    return consumes.includes(form);
  }

  /**
   * Get information about an Attribute.
   *
   * @param collection Collection of object (Group, Dataset, or Datatype).
   * @param objUuid UUID of object.
   * @param attr Name of attribute.
   * @param authorization
   * @param domain
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public collectionObjUuidAttributesAttrGet(
    collection: 'groups' | 'datasets' | 'datatypes',
    objUuid: string,
    attr: string,
    authorization?: string,
    domain?: string,
  ): Observable<AxiosResponse<InlineResponse20015>>;
  public collectionObjUuidAttributesAttrGet(
    collection: 'groups' | 'datasets' | 'datatypes',
    objUuid: string,
    attr: string,
    authorization?: string,
    domain?: string,
  ): Observable<any> {
    if (collection === null || collection === undefined) {
      throw new Error(
        'Required parameter collection was null or undefined when calling collectionObjUuidAttributesAttrGet.',
      );
    }

    if (objUuid === null || objUuid === undefined) {
      throw new Error(
        'Required parameter objUuid was null or undefined when calling collectionObjUuidAttributesAttrGet.',
      );
    }

    if (attr === null || attr === undefined) {
      throw new Error('Required parameter attr was null or undefined when calling collectionObjUuidAttributesAttrGet.');
    }

    let queryParameters: any = {};
    if (domain !== undefined && domain !== null) {
      queryParameters['domain'] = <any>domain;
    }

    let headers = this.defaultHeaders;
    if (authorization !== undefined && authorization !== null) {
      headers['Authorization'] = String(authorization);
    }

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = [];
    return this.httpClient.get<InlineResponse20015>(
      `${this.basePath}/${encodeURIComponent(String(collection))}/${encodeURIComponent(
        String(objUuid),
      )}/attributes/${encodeURIComponent(String(attr))}`,
      {
        params: queryParameters,
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Create an attribute with name &#x60;attr&#x60; and assign it to HDF5 object &#x60;obj_uudi&#x60;.
   *
   * @param collection The collection of the HDF5 object (&#x60;groups&#x60;, &#x60;datasets&#x60;, or &#x60;datatypes&#x60;).
   * @param objUuid HDF5 object\&#39;s UUID.
   * @param attr Name of attribute.
   * @param body Information to create a new attribute of the HDF5 object &#x60;objUuid&#x60;.
   * @param authorization
   * @param domain
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public collectionObjUuidAttributesAttrPut(
    collection: 'groups' | 'datasets' | 'datatypes',
    objUuid: string,
    attr: string,
    body: object,
    authorization?: string,
    domain?: string,
  ): Observable<AxiosResponse<object>>;
  public collectionObjUuidAttributesAttrPut(
    collection: 'groups' | 'datasets' | 'datatypes',
    objUuid: string,
    attr: string,
    body: object,
    authorization?: string,
    domain?: string,
  ): Observable<any> {
    if (collection === null || collection === undefined) {
      throw new Error(
        'Required parameter collection was null or undefined when calling collectionObjUuidAttributesAttrPut.',
      );
    }

    if (objUuid === null || objUuid === undefined) {
      throw new Error(
        'Required parameter objUuid was null or undefined when calling collectionObjUuidAttributesAttrPut.',
      );
    }

    if (attr === null || attr === undefined) {
      throw new Error('Required parameter attr was null or undefined when calling collectionObjUuidAttributesAttrPut.');
    }

    if (body === null || body === undefined) {
      throw new Error('Required parameter body was null or undefined when calling collectionObjUuidAttributesAttrPut.');
    }

    let queryParameters: any = {};
    if (domain !== undefined && domain !== null) {
      queryParameters['domain'] = <any>domain;
    }

    let headers = this.defaultHeaders;
    if (authorization !== undefined && authorization !== null) {
      headers['Authorization'] = String(authorization);
    }

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['application/json'];
    const httpContentTypeSelected: string | undefined = this.configuration.selectHeaderContentType(consumes);
    if (httpContentTypeSelected != undefined) {
      headers['Content-Type'] = httpContentTypeSelected;
    }
    return this.httpClient.put<object>(
      `${this.basePath}/${encodeURIComponent(String(collection))}/${encodeURIComponent(
        String(objUuid),
      )}/attributes/${encodeURIComponent(String(attr))}`,
      body,
      {
        params: queryParameters,
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * List all Attributes attached to the HDF5 object &#x60;objUuid&#x60;.
   * Attributes sorted alphanumerically by name.
   * @param collection The collection of the HDF5 object (one of: &#x60;groups&#x60;, &#x60;datasets&#x60;, or &#x60;datatypes&#x60;).
   * @param objUuid UUID of object.
   * @param authorization
   * @param domain
   * @param limit Cap the number of Attributes listed. Can be used with &#x60;Marker&#x60;.
   * @param marker Start Attribute listing _after_ the given name.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public collectionObjUuidAttributesGet(
    collection: 'groups' | 'datasets' | 'datatypes',
    objUuid: string,
    authorization?: string,
    domain?: string,
    limit?: number,
    marker?: string,
  ): Observable<AxiosResponse<InlineResponse20014>>;
  public collectionObjUuidAttributesGet(
    collection: 'groups' | 'datasets' | 'datatypes',
    objUuid: string,
    authorization?: string,
    domain?: string,
    limit?: number,
    marker?: string,
  ): Observable<any> {
    if (collection === null || collection === undefined) {
      throw new Error(
        'Required parameter collection was null or undefined when calling collectionObjUuidAttributesGet.',
      );
    }

    if (objUuid === null || objUuid === undefined) {
      throw new Error('Required parameter objUuid was null or undefined when calling collectionObjUuidAttributesGet.');
    }

    let queryParameters: any = {};
    if (domain !== undefined && domain !== null) {
      queryParameters['domain'] = <any>domain;
    }
    if (limit !== undefined && limit !== null) {
      queryParameters['Limit'] = <any>limit;
    }
    if (marker !== undefined && marker !== null) {
      queryParameters['Marker'] = <any>marker;
    }

    let headers = this.defaultHeaders;
    if (authorization !== undefined && authorization !== null) {
      headers['Authorization'] = String(authorization);
    }

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = [];
    return this.httpClient.get<InlineResponse20014>(
      `${this.basePath}/${encodeURIComponent(String(collection))}/${encodeURIComponent(String(objUuid))}/attributes`,
      {
        params: queryParameters,
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
}
