/**
 * BioSimulations COMBINE API
 * Endpoints for working with models (e.g., [CellML](https://cellml.org/), [SBML](http://sbml.org/)), simulation experiments (e.g., [Simulation Experiment Description Language (SED-ML)](https://sed-ml.org/)), metadata ([OMEX Metadata](https://sys-bio.github.io/libOmexMeta/)), and simulation projects ([COMBINE/OMEX archives](https://combinearchive.org/)).  Note, this API may change significantly in the future.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { CombineArchiveFileContent } from './combineArchiveFileContent';
import { FilenameOrUrl } from './filenameOrUrl';

/**
 * A COMBINE/OMEX archive and an additional content items that should be added to the archive.
 */
export interface CombineArchiveAndAdditionalContent {
  archive: FilenameOrUrl;
  /**
   * Whether to overwrite the location if it already exists, or to add the content at an alternative location (indicated location plus a unique integer).  Default: true
   */
  overwriteLocations?: boolean;
  /**
   * Whether to download the modified COMBINE/OMEX archive or return a URL where it can be retrieved.  Default: false
   */
  download?: boolean;
  /**
   * Files to add to the COMBINE/OMEX archive and, optionally, the archive.
   */
  files: Array<Blob>;
  newContent: CombineArchiveFileContent;
}
