# Guide to using BioSimulations and BioSimulators

This section contains a brief guide for using BioSimulations and BioSimulators to create, publish, and find simulation projects and simulation tools. Please use the menu to the left to navigate through the guide. Below are links to additional tutorials and documentation.

## Live and recorded tutorials
Information about upcoming live tutorials and recordings of past events is available [here](./live-tutorials.md).

## Deeper interactive tutorials on using the REST APIs and Python libraries
Jupyter notebooks with interactive tutorials are available from [Binder](https://tutorial.biosimulators.org/).

* Programmatically introspecting model/simulation files
* Programmatically creating SED-ML files and COMBINE/OMEX archives from archetypical model/simulation files
* Programmatically retrieving information about the capabilities of simulation tools
* Programmatically executing simulations in Python

## Example simulation projects
Several example model files, SED-ML files, Vega files, and COMBINE/OMEX archives are available [here](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples). This includes examples for all currently supported model languages.

## Documentation for the REST APIs
Links to detailed examples and documentation for the REST APIs is available [here](./api.md).

## Documentation for the BioSimulators simulation tools and core packages
Links to detailed documentation each simulation tool and the core BioSimulators packages are available [here](./biosimulators-packages.md).


--8<-- "glossary.md"